/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.common.util.biome.BiomeUtil;
import biomesoplenty.common.world.BOPLayerUtil;
import biomesoplenty.common.world.layer.traits.IAreaTransformer3;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.area.IArea;
import net.minecraft.world.gen.layer.traits.IDimOffset0Transformer;

public enum BOPMixOceansLayer implements IAreaTransformer3,
IDimOffset0Transformer
{
    INSTANCE;


    @Override
    public int applyPixel(INoiseRandom context, IArea biomeArea, IArea oceanArea, IArea climateArea, int x, int z) {
        int biomeId = biomeArea.func_202678_a(x, z);
        int oceanId = oceanArea.func_202678_a(x, z);
        int climateVal = climateArea.func_202678_a(x, z);
        BOPClimates climate = BOPClimates.lookup(climateVal);
        if (!BOPLayerUtil.isOcean(biomeId)) {
            return biomeId;
        }
        switch (climate) {
            case ICE_CAP: {
                oceanId = BOPLayerUtil.FROZEN_OCEAN;
                break;
            }
            case TUNDRA: 
            case WET_BOREAL: 
            case DRY_BOREAL: {
                oceanId = BOPLayerUtil.COLD_OCEAN;
                break;
            }
            case WARM_TEMPERATE: 
            case SUBTROPICAL: 
            case MEDITERRANEAN: 
            case SAVANNA: {
                oceanId = BOPLayerUtil.LUKEWARM_OCEAN;
                break;
            }
            case TROPICAL: 
            case HOT_DESERT: {
                oceanId = BOPLayerUtil.WARM_OCEAN;
                break;
            }
            default: {
                oceanId = BOPLayerUtil.OCEAN;
            }
        }
        if (biomeId == BOPLayerUtil.DEEP_OCEAN) {
            if (oceanId == BOPLayerUtil.WARM_OCEAN) {
                return BOPLayerUtil.DEEP_WARM_OCEAN;
            }
            if (oceanId == BOPLayerUtil.LUKEWARM_OCEAN) {
                return BOPLayerUtil.DEEP_LUKEWARM_OCEAN;
            }
            if (oceanId == BOPLayerUtil.OCEAN) {
                return BOPLayerUtil.DEEP_OCEAN;
            }
            if (oceanId == BOPLayerUtil.COLD_OCEAN) {
                return BOPLayerUtil.DEEP_COLD_OCEAN;
            }
            if (oceanId == BOPLayerUtil.FROZEN_OCEAN) {
                return BOPLayerUtil.DEEP_FROZEN_OCEAN;
            }
            if (BiomeUtil.exists(BOPBiomes.wasteland) && oceanId == BiomeUtil.getBiomeId(BOPBiomes.wasteland)) {
                return BiomeUtil.getBiomeId(BOPBiomes.wasteland);
            }
        }
        return oceanId;
    }
}

