/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer;

import biomesoplenty.common.world.SimplexNoise;
import biomesoplenty.common.world.layer.traits.IBOPAreaTransformer0;
import biomesoplenty.common.world.layer.traits.IBOPContextExtended;

public enum TemperatureNoiseLayer implements IBOPAreaTransformer0
{
    SMALL_ZONES(0.16),
    MEDIUM_ZONES(0.06),
    LARGE_ZONES(0.01);

    private final double scale;

    private TemperatureNoiseLayer(double scale) {
        this.scale = scale;
    }

    @Override
    public int applyPixel(IBOPContextExtended context, int x, int z) {
        long seed = context.getWorldSeed();
        double noiseVal = SimplexNoise.noise(seed ^ 0xAB1C154F2C586F42L, (double)x * this.scale + SimplexNoise.TRIANGLE_START_X, (double)z * this.scale + SimplexNoise.TRIANGLE_START_Y);
        if (noiseVal < -0.7290668901192167) {
            return 0;
        }
        if (noiseVal < -0.5226116882660503) {
            return 1;
        }
        if (noiseVal < -0.31460282189018446) {
            return 2;
        }
        if (noiseVal < -0.10524117177898246) {
            return 3;
        }
        if (noiseVal < 0.10524117177898246) {
            return 4;
        }
        if (noiseVal < 0.31460282189018446) {
            return 5;
        }
        if (noiseVal < 0.5226116882660503) {
            return 6;
        }
        if (noiseVal < 0.7290668901192167) {
            return 7;
        }
        return 8;
    }
}

