/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.crafting.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import net.darkhax.bookshelf.serialization.Serializers;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class IngredientPotion
extends Ingredient {
    public static final Serializer SERIALIZER = new Serializer();
    public static final Ingredient WATER_BOTTLE = new IngredientPotion(Items.field_151068_bn, Potions.field_185230_b);
    public static final Ingredient AWKWARD = new IngredientPotion(Items.field_151068_bn, Potions.field_185233_e);
    private final Item item;
    private final Potion potion;

    public IngredientPotion(Item item, Potion potion) {
        super(Stream.of(new Ingredient.SingleItemList(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)item), (Potion)potion))));
        this.item = item;
        this.potion = potion;
    }

    public boolean test(ItemStack input) {
        return input != null && !input.func_190926_b() && this.item == input.func_77973_b() && PotionUtils.func_185191_c((ItemStack)input) == this.potion;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)SERIALIZER).toString());
        json.add("item", Serializers.ITEM.write(this.item));
        json.add("potion", Serializers.POTION.write(this.potion));
        return json;
    }

    static class Serializer
    implements IIngredientSerializer<IngredientPotion> {
        Serializer() {
        }

        public IngredientPotion parse(PacketBuffer buffer) {
            Item item = Serializers.ITEM.read(buffer);
            Potion potion = Serializers.POTION.read(buffer);
            return new IngredientPotion(item, potion);
        }

        public IngredientPotion parse(JsonObject json) {
            Item item = Serializers.ITEM.read(json, "item");
            Potion potion = Serializers.POTION.read(json, "potion");
            return new IngredientPotion(item, potion);
        }

        public void write(PacketBuffer buffer, IngredientPotion ingredient) {
            Serializers.ITEM.write(ingredient.item);
            Serializers.POTION.write(ingredient.potion);
        }
    }
}

