/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.darkhax.bookshelf.serialization.ISerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;

public class SerializerNBT
implements ISerializer<CompoundNBT> {
    public static final ISerializer<CompoundNBT> SERIALIZER = new SerializerNBT();
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    private SerializerNBT() {
    }

    @Override
    public CompoundNBT read(JsonElement json) {
        try {
            if (json.isJsonObject()) {
                return JsonToNBT.func_180713_a((String)GSON.toJson(json));
            }
            return JsonToNBT.func_180713_a((String)JSONUtils.func_151206_a((JsonElement)json, (String)"nbt"));
        }
        catch (CommandSyntaxException e) {
            throw new JsonParseException("Failed to read NBT from " + JSONUtils.func_151222_d((JsonElement)json), (Throwable)e);
        }
    }

    @Override
    public JsonElement write(CompoundNBT toWrite) {
        return new JsonPrimitive(toWrite.toString());
    }

    @Override
    public CompoundNBT read(PacketBuffer buffer) {
        return buffer.func_150793_b();
    }

    @Override
    public void write(PacketBuffer buffer, CompoundNBT toWrite) {
        buffer.func_150786_a(toWrite);
    }

    @Override
    public INBT writeNBT(CompoundNBT toWrite) {
        return toWrite;
    }

    @Override
    public CompoundNBT read(INBT nbt) {
        if (nbt instanceof CompoundNBT) {
            return (CompoundNBT)nbt;
        }
        throw new IllegalArgumentException("Expected NBT to be a compound tag. Class was " + nbt.getClass() + " with ID " + nbt.func_74732_a() + " instead.");
    }
}

