/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.util;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import team.chisel.api.IChiselItem;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.ICarvingGroup;
import team.chisel.api.carving.ICarvingVariation;
import team.chisel.common.init.ChiselSounds;

@ParametersAreNonnullByDefault
public class SoundUtil {
    public static SoundEvent getSound(PlayerEntity player, ItemStack chisel, @Nullable Block target) {
        SoundEvent evt;
        if (target != null && !chisel.func_190926_b() && (evt = ((IChiselItem)chisel.func_77973_b()).getOverrideSound(player.func_130014_f_(), player, chisel, target)) != null) {
            return evt;
        }
        return CarvingUtils.getChiselRegistry().getGroup(target != null ? target.getBlock() : Blocks.field_150350_a).map(ICarvingGroup::getSound).orElse(ChiselSounds.fallback);
    }

    public static void playSound(PlayerEntity player, ItemStack chisel, ItemStack source) {
        Block block;
        ICarvingVariation v = CarvingUtils.getChiselRegistry().getVariation(source.func_77973_b()).orElse(null);
        Block block2 = block = v == null ? null : v.getBlock();
        if (block == null) {
            block = source.func_77973_b() instanceof BlockItem ? ((BlockItem)source.func_77973_b()).func_179223_d() : Blocks.field_150348_b;
        }
        SoundUtil.playSound(player, chisel, block);
    }

    public static void playSound(PlayerEntity player, ItemStack chisel, @Nullable Block target) {
        SoundEvent sound = SoundUtil.getSound(player, chisel, target);
        SoundUtil.playSound(player, player.func_233580_cy_(), sound);
    }

    public static void playSound(PlayerEntity player, BlockPos pos, SoundEvent sound) {
        SoundUtil.playSound(player, pos, sound, SoundCategory.BLOCKS);
    }

    public static void playSound(PlayerEntity player, BlockPos pos, SoundEvent sound, SoundCategory category) {
        World world = player.func_130014_f_();
        world.func_184133_a(player, pos, sound, category, 0.3f + 0.7f * world.field_73012_v.nextFloat(), 0.6f + 0.4f * world.field_73012_v.nextFloat());
    }
}

