/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.holder;

import java.lang.reflect.Field;
import team.creative.creativecore.common.config.ConfigTypeConveration;
import team.creative.creativecore.common.config.holder.ConfigHolder;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;

public class ConfigHolderDynamic
extends ConfigHolder<ConfigKey> {
    public ConfigHolderDynamic(ICreativeConfigHolder parent, String key, ConfigSynchronization synchronization) {
        super(parent, key, synchronization);
    }

    ConfigHolderDynamic() {
    }

    public ConfigHolderDynamic registerFolder(String key) {
        return this.registerFolder(key, ConfigSynchronization.UNIVERSAL);
    }

    public ConfigHolderDynamic registerFolder(String key, ConfigSynchronization synchronization) {
        if (key.contains(".") || key.contains("/")) {
            throw new RuntimeException("Invalid key " + key + "");
        }
        if (this.fields.containsKey(key)) {
            throw new RuntimeException("Key already registered " + key + "");
        }
        synchronization = this.synchronization != ConfigSynchronization.UNIVERSAL ? this.synchronization : synchronization;
        ConfigHolderDynamic holder = new ConfigHolderDynamic(this, key, synchronization);
        this.fields.add(key, new ConfigKey.ConfigKeyDynamic(key, holder, synchronization, false));
        return holder;
    }

    public ConfigHolderDynamic registerValue(String key, Object defaultValue) {
        return this.registerValue(key, defaultValue, ConfigSynchronization.UNIVERSAL, false);
    }

    public ConfigHolderDynamic registerValue(String key, Object defaultValue, ConfigSynchronization synchronization, boolean requiresRestart) {
        if (ConfigTypeConveration.has(defaultValue.getClass())) {
            throw new IllegalArgumentException("Only holder objects are allowed");
        }
        if (key.contains(".") || key.contains("/")) {
            throw new RuntimeException("Invalid key " + key + "");
        }
        if (this.fields.containsKey(key)) {
            throw new RuntimeException("Key already registered " + key + "");
        }
        synchronization = this.synchronization != ConfigSynchronization.UNIVERSAL ? this.synchronization : synchronization;
        this.fields.add(key, new ConfigKey.ConfigKeyDynamic(key, ConfigTypeConveration.parseObject(this, synchronization, key, defaultValue), synchronization, requiresRestart));
        return this;
    }

    public void registerField(String key, Field field, Object object) {
        this.registerField(key, field, object, ConfigSynchronization.CLIENT, false);
    }

    public void registerField(String key, Field field, Object object, ConfigSynchronization synchronization, boolean requiresRestart) {
        ConfigSynchronization configSynchronization = synchronization = this.synchronization != ConfigSynchronization.UNIVERSAL ? this.synchronization : synchronization;
        if (!ConfigTypeConveration.has(field.getType())) {
            throw new RuntimeException("Field cannot contain holder object, use register value instead");
        }
        try {
            ConfigKey.ConfigKeyDynamicField configKey = new ConfigKey.ConfigKeyDynamicField(field, key, field.get(object), synchronization, requiresRestart, object);
            this.fields.add(key, configKey);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }
}

