/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.util.text.ITextComponent;
import team.creative.creativecore.client.render.text.CompiledText;
import team.creative.creativecore.common.util.text.ITextCollection;

public class TextMapBuilder<K>
implements ITextCollection {
    private LinkedHashMap<K, List<ITextComponent>> lines = new LinkedHashMap();
    private Predicate<String> filter;

    public TextMapBuilder<K> setFilter(Predicate<String> predicate) {
        this.filter = predicate;
        return this;
    }

    private void addNewLine(K key, ITextComponent line) {
        ArrayList<ITextComponent> newLine = new ArrayList<ITextComponent>();
        newLine.add(line);
        this.addNewLine(key, newLine);
    }

    private void addNewLine(K key, List<ITextComponent> line) {
        if (this.filter != null) {
            StringBuilder builder = new StringBuilder();
            for (ITextComponent component : line) {
                builder.append(component.getString());
            }
            if (!this.filter.test(builder.toString())) {
                return;
            }
        }
        this.lines.put(key, line);
    }

    public TextMapBuilder addComponent(K[] array, Function<K, ITextComponent> toComponent) {
        for (int i = 0; i < array.length; ++i) {
            this.addNewLine(array[i], toComponent.apply(array[i]));
        }
        return this;
    }

    public TextMapBuilder addComponent(Collection<K> collection, Function<K, ITextComponent> toComponent) {
        for (K t : collection) {
            this.addNewLine(t, toComponent.apply(t));
        }
        return this;
    }

    public TextMapBuilder addComponents(Collection<K> collection, Function<K, List<ITextComponent>> toComponent) {
        for (K t : collection) {
            this.addNewLine(t, toComponent.apply(t));
        }
        return this;
    }

    @Override
    public CompiledText[] build() {
        CompiledText[] lines = new CompiledText[this.lines.size()];
        int i = 0;
        for (List<ITextComponent> text : this.lines.values()) {
            lines[i] = CompiledText.createAnySize();
            lines[i].setText(text);
            ++i;
        }
        return lines;
    }

    public List<K> keys() {
        return new ArrayList<K>(this.lines.keySet());
    }
}

