/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.armor;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import com.kwpugh.gobber2.init.ItemInit;
import com.kwpugh.gobber2.util.PlayerSpecialAbilities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCustomArmorDragon
extends ArmorItem {
    boolean enablePerks = (Boolean)GobberConfigBuilder.ENABLE_GOBBER_DRAGON_ARMOR_HEALTH_PERKS.get();
    int hunger = (Integer)GobberConfigBuilder.GOBBER_DRAGON_ARMOR_HUNGER.get();
    double saturation = (Double)GobberConfigBuilder.GOBBER_DRAGON_ARMOR_SATURATION.get();

    public ItemCustomArmorDragon(IArmorMaterial materialIn, EquipmentSlotType slots, Item.Properties builder) {
        super(materialIn, slots, builder);
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (!player.getPersistentData().func_74764_b("wearingFullDragonArmor")) {
            player.getPersistentData().func_74757_a("wearingFullDragonArmor", false);
        }
        ItemStack head = player.func_184582_a(EquipmentSlotType.HEAD);
        ItemStack chest = player.func_184582_a(EquipmentSlotType.CHEST);
        ItemStack legs = player.func_184582_a(EquipmentSlotType.LEGS);
        ItemStack feet = player.func_184582_a(EquipmentSlotType.FEET);
        this.setDamage(head, 0);
        this.setDamage(chest, 0);
        this.setDamage(legs, 0);
        this.setDamage(feet, 0);
        boolean iswearingFullDragonArmor = head != null && head.func_77973_b() == ItemInit.GOBBER2_HELMET_DRAGON.get() && chest != null && chest.func_77973_b() == ItemInit.GOBBER2_CHESTPLATE_DRAGON.get() && legs != null && legs.func_77973_b() == ItemInit.GOBBER2_LEGGINGS_DRAGON.get() && feet != null && feet.func_77973_b() == ItemInit.GOBBER2_BOOTS_DRAGON.get();
        boolean wasWearingDragonArmorLastTick = player.getPersistentData().func_74767_n("wearingFullDragonArmor");
        if (!iswearingFullDragonArmor && wasWearingDragonArmorLastTick && !player.func_184812_l_()) {
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
        } else if (iswearingFullDragonArmor && (world.func_234923_W_().equals(World.field_234918_g_) || world.func_234923_W_().equals(World.field_234919_h_) || world.func_234923_W_().equals(World.field_234920_i_))) {
            player.field_71075_bZ.field_75101_c = true;
        }
        player.getPersistentData().func_74757_a("wearingFullDragonArmor", iswearingFullDragonArmor);
        if (this.enablePerks) {
            if (iswearingFullDragonArmor) {
                if (player.func_70660_b(Effects.field_76440_q) != null) {
                    player.func_195063_d(Effects.field_76440_q);
                }
                if (player.func_70660_b(Effects.field_76421_d) != null) {
                    player.func_195063_d(Effects.field_76421_d);
                }
                if (player.func_70660_b(Effects.field_76419_f) != null) {
                    player.func_195063_d(Effects.field_76419_f);
                }
                if (player.func_70660_b(Effects.field_76433_i) != null) {
                    player.func_195063_d(Effects.field_76433_i);
                }
                if (player.func_70660_b(Effects.field_76431_k) != null) {
                    player.func_195063_d(Effects.field_76431_k);
                }
                if (player.func_70660_b(Effects.field_76438_s) != null) {
                    player.func_195063_d(Effects.field_76438_s);
                }
                if (player.func_70660_b(Effects.field_76436_u) != null) {
                    player.func_195063_d(Effects.field_76436_u);
                }
                if (player.func_70660_b(Effects.field_82731_v) != null) {
                    player.func_195063_d(Effects.field_82731_v);
                }
                if (player.func_70660_b(Effects.field_188424_y) != null) {
                    player.func_195063_d(Effects.field_188424_y);
                }
                if (player.func_70660_b(Effects.field_189112_A) != null) {
                    player.func_195063_d(Effects.field_189112_A);
                }
                if (player.func_70660_b(Effects.field_76437_t) != null) {
                    player.func_195063_d(Effects.field_76437_t);
                }
            }
            if (head.func_77973_b() == ItemInit.GOBBER2_HELMET_DRAGON.get()) {
                PlayerSpecialAbilities.giveYellowHearts(world, (LivingEntity)player, stack, 20, 0.66f);
                PlayerSpecialAbilities.giveRegenEffect(world, player, stack, this.hunger, (float)this.saturation);
            } else {
                PlayerSpecialAbilities.giveNoExtraHearts(world, player, stack);
            }
        }
        if (chest.func_77973_b() == ItemInit.GOBBER2_CHESTPLATE_DRAGON.get()) {
            // empty if block
        }
        if (legs.func_77973_b() == ItemInit.GOBBER2_LEGGINGS_DRAGON.get()) {
            // empty if block
        }
        if (feet.func_77973_b() == ItemInit.GOBBER2_BOOTS_DRAGON.get()) {
            // empty if block
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        stack.func_196082_o().func_74757_a("Unbreakable", true);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == ItemInit.GOBBER2_INGOT_END.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_armor_dragon.line1").func_240699_a_(TextFormatting.LIGHT_PURPLE));
        if (this.enablePerks) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_armor_dragon.line2").func_240699_a_(TextFormatting.GOLD));
        }
    }
}

