/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCustomRingTeleport
extends Item {
    public ItemCustomRingTeleport(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        Direction direction = context.func_196000_l();
        ItemStack stackRing = context.func_195999_j().func_184614_ca();
        if (ItemCustomRingTeleport.getPosition(stackRing) == null && player.func_213453_ef()) {
            ItemCustomRingTeleport.setPosition(stackRing, world, pos.func_177972_a(direction), player);
            player.func_145747_a((ITextComponent)new TranslationTextComponent("item.gobber2.ring_teleport.line1").func_240699_a_(TextFormatting.YELLOW), null);
            return ActionResultType.SUCCESS;
        }
        if (ItemCustomRingTeleport.getPosition(stackRing) != null) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("item.gobber2.ring_teleport.line2").func_240699_a_(TextFormatting.YELLOW), null);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (ItemCustomRingTeleport.getPosition(stack) != null && !player.func_213453_ef()) {
            this.teleport(player, world, stack);
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187544_ad, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        if (ItemCustomRingTeleport.getPosition(stack) != null && player.func_213453_ef()) {
            ItemCustomRingTeleport.setPosition(stack, world, null, player);
            player.func_145747_a((ITextComponent)new TranslationTextComponent("item.gobber2.ring_teleport.line3").func_240699_a_(TextFormatting.YELLOW), null);
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    public static BlockPos getPosition(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        CompoundNBT tags = stack.func_77978_p();
        if (tags.func_74764_b("pos")) {
            return NBTUtil.func_186861_c((CompoundNBT)((CompoundNBT)tags.func_74781_a("pos")));
        }
        return null;
    }

    public static int getDimension(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return Integer.MAX_VALUE;
        }
        CompoundNBT tags = stack.func_77978_p();
        if (tags.func_74764_b("dim")) {
            return tags.func_74762_e("dim");
        }
        return Integer.MAX_VALUE;
    }

    public static void setPosition(ItemStack stack, World world, BlockPos pos, PlayerEntity player) {
        if (world.field_72995_K) {
            return;
        }
        CompoundNBT tags = !stack.func_77942_o() ? new CompoundNBT() : stack.func_77978_p();
        if (pos == null) {
            tags.func_82580_o("pos");
            tags.func_82580_o("dim");
        } else {
            tags.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)pos));
            if (world.func_234923_W_().equals(World.field_234918_g_)) {
                tags.func_74768_a("dim", 0);
            }
            if (world.func_234923_W_().equals(World.field_234919_h_)) {
                tags.func_74768_a("dim", -1);
            }
            if (world.func_234923_W_().equals(World.field_234920_i_)) {
                tags.func_74768_a("dim", 1);
            }
        }
        stack.func_77982_d(tags);
    }

    public void teleport(PlayerEntity player, World world, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        BlockPos pos = ItemCustomRingTeleport.getPosition(stack);
        int dim = ItemCustomRingTeleport.getDimension(stack);
        if (world.func_234923_W_().equals(World.field_234918_g_) && dim == 0) {
            player.func_70634_a((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
        } else if (world.func_234923_W_().equals(World.field_234919_h_) && dim == -1) {
            player.func_70634_a((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
        } else if (world.func_234923_W_().equals(World.field_234920_i_) && dim == 1) {
            player.func_70634_a((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
        } else {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("item.gobber2.ring_teleport.line8").func_240699_a_(TextFormatting.YELLOW), null);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        String dimName;
        switch (ItemCustomRingTeleport.getDimension(stack)) {
            case 1: {
                dimName = "End";
                break;
            }
            case 0: {
                dimName = "OverWorld";
                break;
            }
            case -1: {
                dimName = "Nether";
                break;
            }
            default: {
                dimName = "Unknown";
            }
        }
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.ring_teleport.line9").func_240699_a_(TextFormatting.GREEN));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.ring_teleport.line10").func_240699_a_(TextFormatting.AQUA));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.ring_teleport.line11").func_240699_a_(TextFormatting.BLUE));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.ring_teleport.line12").func_240699_a_(TextFormatting.RED));
        if (ItemCustomRingTeleport.getPosition(stack) != null) {
            BlockPos pos = ItemCustomRingTeleport.getPosition(stack);
            tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.ring_teleport.line13").func_240699_a_(TextFormatting.GREEN));
            tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.ring_teleport.line14", new Object[]{dimName, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}).func_240699_a_(TextFormatting.LIGHT_PURPLE));
        }
    }
}

