/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.tools.paxel;

import com.kwpugh.gobber2.items.toolbaseclasses.PaxelBase;
import com.kwpugh.gobber2.util.EnableUtil;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCustomPaxelStars
extends PaxelBase {
    public ItemCustomPaxelStars(float attackDamageIn, float attackSpeedIn, IItemTier tier, Set<Block> effectiveBlocksIn, Item.Properties builder) {
        super(attackDamageIn, attackSpeedIn, tier, EFFECTIVE_ON, builder);
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext iuc) {
        BlockPos torchPos;
        BlockPos pos = iuc.func_195995_a();
        World world = iuc.func_195991_k();
        BlockPos blockpos = iuc.func_195995_a();
        PlayerEntity player = iuc.func_195999_j();
        ItemStack stack = player.func_184614_ca();
        BlockState blockstate = world.func_180495_p(blockpos);
        BlockState resultToSet = null;
        Block strippedResult = (Block)BLOCK_STRIPPING_MAP.get(blockstate.func_177230_c());
        if (!EnableUtil.isEnabled(stack)) {
            if (strippedResult != null) {
                world.func_184133_a(player, blockpos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
                resultToSet = (BlockState)strippedResult.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, blockstate.func_177229_b((Property)RotatedPillarBlock.field_176298_M));
            } else {
                if (iuc.func_196000_l() == Direction.DOWN) {
                    return ActionResultType.PASS;
                }
                BlockState foundResult = (BlockState)SHOVEL_LOOKUP.get(blockstate.func_177230_c());
                if (foundResult != null && world.func_175623_d(blockpos.func_177984_a())) {
                    world.func_184133_a(player, blockpos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    resultToSet = foundResult;
                } else if (blockstate.func_177230_c() instanceof CampfireBlock && ((Boolean)blockstate.func_177229_b((Property)CampfireBlock.field_220101_b)).booleanValue()) {
                    world.func_217378_a(null, 1009, blockpos, 0);
                    resultToSet = (BlockState)blockstate.func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(false));
                }
            }
            if (resultToSet == null) {
                return ActionResultType.PASS;
            }
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, resultToSet, 11);
                if (player != null) {
                    iuc.func_195996_i().func_222118_a(0, (LivingEntity)player, onBroken -> onBroken.func_213334_d(iuc.func_221531_n()));
                }
            }
            stack.func_196085_b(0);
            return ActionResultType.SUCCESS;
        }
        if (iuc.func_195991_k().func_180495_p(pos).func_177230_c() == Blocks.field_150478_aa || iuc.func_195991_k().func_180495_p(pos).func_177230_c() == Blocks.field_196591_bQ) {
            return ActionResultType.FAIL;
        }
        Boolean isWallTorch = false;
        switch (iuc.func_196000_l()) {
            case DOWN: {
                return ActionResultType.FAIL;
            }
            case UP: {
                torchPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
                break;
            }
            case NORTH: {
                torchPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1);
                isWallTorch = true;
                break;
            }
            case SOUTH: {
                torchPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1);
                isWallTorch = true;
                break;
            }
            case WEST: {
                torchPos = new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
                isWallTorch = true;
                break;
            }
            case EAST: {
                torchPos = new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
                isWallTorch = true;
                break;
            }
            default: {
                return ActionResultType.FAIL;
            }
        }
        if (iuc.func_195991_k().func_180495_p(torchPos).func_196958_f() || iuc.func_195991_k().func_180495_p(torchPos).func_204520_s().func_206889_d()) {
            if (blockstate.func_215686_e((IBlockReader)world, pos)) {
                if (isWallTorch.booleanValue()) {
                    iuc.func_195991_k().func_175656_a(torchPos, (BlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)iuc.func_196000_l()));
                    iuc.func_195991_k().func_184133_a(null, iuc.func_195999_j().func_233580_cy_(), SoundEvents.field_187891_gV, SoundCategory.NEUTRAL, 8.0f, (float)((double)0.7f + Math.random() * 0.3));
                } else {
                    iuc.func_195991_k().func_175656_a(torchPos, Blocks.field_150478_aa.func_176223_P());
                    iuc.func_195991_k().func_184133_a(null, iuc.func_195999_j().func_233580_cy_(), SoundEvents.field_187891_gV, SoundCategory.NEUTRAL, 8.0f, (float)((double)0.7f + Math.random() * 0.3));
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && player.func_225608_bj_()) {
            EnableUtil.changeEnabled(player, hand);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_paxel_stars.line4", new Object[]{EnableUtil.isEnabled(stack)}).func_240699_a_(TextFormatting.RED), true);
            return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_196085_b(0);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!worldIn.field_72995_K && (double)state.func_185887_b((IBlockReader)worldIn, pos) != 0.0) {
            stack.func_196085_b(0);
        }
        return true;
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        stack.func_196082_o().func_74757_a("Unbreakable", true);
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_paxel_stars.line2").func_240699_a_(TextFormatting.YELLOW));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_paxel_stars.line3").func_240699_a_(TextFormatting.YELLOW));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_paxel_stars.line4", new Object[]{EnableUtil.isEnabled(stack)}).func_240699_a_(TextFormatting.RED));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_paxel_stars.line5").func_240699_a_(TextFormatting.LIGHT_PURPLE));
    }
}

