/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.IETileTypes;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockTileEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class CrusherTileEntity
extends PoweredMultiblockTileEntity<CrusherTileEntity, CrusherRecipe>
implements IEBlockInterfaces.ISoundTile,
IEBlockInterfaces.IBlockBounds {
    public float animation_barrelRotation = 0.0f;
    private Pair<BlockState, AxisAlignedBB> renderAABB;
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(CrusherTileEntity::getShape);
    private final CapabilityReference<IItemHandler> output = CapabilityReference.forTileEntityAt(this, () -> new DirectionalBlockPos(this.func_174877_v().func_177982_a(0, -1, 0).func_177967_a(this.getFacing(), -2), this.getFacing()), CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    LazyOptional<IItemHandler> insertionHandler = this.registerConstantCap(new PoweredMultiblockTileEntity.MultiblockInventoryHandler_DirectProcessing(this).setProcessStacking(true));

    public CrusherTileEntity() {
        super(IEMultiblocks.CRUSHER, 32000, true, (TileEntityType)IETileTypes.CRUSHER.get());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K && !this.isDummy()) {
            boolean active = this.shouldRenderAsActive();
            ImmersiveEngineering.proxy.handleTileSound(IESounds.crusher, this, active, 0.5f, 1.0f);
            if (active) {
                this.animation_barrelRotation += 18.0f;
                this.animation_barrelRotation %= 360.0f;
            }
        }
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null || this.renderAABB.getKey() != this.func_195044_w()) {
            this.renderAABB = Pair.of((Object)this.func_195044_w(), (Object)new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - (this.getFacing().func_176740_k() == Direction.Axis.Z ? 2 : 1)), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() - (this.getFacing().func_176740_k() == Direction.Axis.X ? 2 : 1)), (double)(this.func_174877_v().func_177958_n() + (this.getFacing().func_176740_k() == Direction.Axis.Z ? 3 : 2)), (double)(this.func_174877_v().func_177956_o() + 3), (double)(this.func_174877_v().func_177952_p() + (this.getFacing().func_176740_k() == Direction.Axis.X ? 3 : 2))));
        }
        return (AxisAlignedBB)this.renderAABB.getRight();
    }

    public static VoxelShape getBasicShape(BlockPos posInMultiblock) {
        ImmutableSet slabs = ImmutableSet.of((Object)new BlockPos(3, 0, 2), (Object)new BlockPos(1, 0, 2), (Object)new BlockPos(0, 0, 2), (Object)new BlockPos(3, 0, 1), (Object)new BlockPos(1, 0, 1), (Object)new BlockPos(3, 0, 0), (Object[])new BlockPos[]{new BlockPos(2, 0, 0), new BlockPos(1, 0, 0), new BlockPos(0, 0, 0), new BlockPos(0, 1, 1)});
        if (slabs.contains(posInMultiblock)) {
            return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0);
        }
        if (new BlockPos(2, 1, 1).equals((Object)posInMultiblock)) {
            return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.75, (double)1.0);
        }
        if (new BlockPos(2, 2, 1).equals((Object)posInMultiblock)) {
            return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        }
        if (posInMultiblock.func_177956_o() > 0 && posInMultiblock.func_177958_n() > 0 && posInMultiblock.func_177958_n() < 4) {
            float minX = 0.0f;
            float maxX = 1.0f;
            float minZ = 0.0f;
            float maxZ = 1.0f;
            if (posInMultiblock.func_177958_n() == 3) {
                minX = 0.1875f;
                maxX = 1.0f;
                minZ = 0.0f;
                maxZ = 1.0f;
            } else if (posInMultiblock.func_177958_n() == 1) {
                minX = 0.0f;
                maxX = 0.8125f;
                minZ = 0.0f;
                maxZ = 1.0f;
            }
            if (posInMultiblock.func_177952_p() == 2) {
                maxZ = 0.8125f;
            }
            return VoxelShapes.func_197873_a((double)minX, (double)0.0, (double)minZ, (double)maxX, (double)1.0, (double)maxZ);
        }
        if (new BlockPos(0, 1, 2).equals((Object)posInMultiblock)) {
            return VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0);
        }
        return VoxelShapes.func_197868_b();
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable ISelectionContext ctx) {
        return SHAPES.get(this.posInMultiblock, (Pair<Direction, Boolean>)Pair.of((Object)this.getFacing(), (Object)this.getIsMirrored()));
    }

    private static List<AxisAlignedBB> getShape(BlockPos posInMultiblock) {
        if (posInMultiblock.func_177952_p() == 1 && posInMultiblock.func_177958_n() == 2) {
            return CrusherTileEntity.getBasicShape(posInMultiblock).func_197756_d();
        }
        if (new BlockPos(0, 0, 2).equals((Object)posInMultiblock)) {
            ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)});
            list.add(new AxisAlignedBB(0.125, 0.5, 0.625, 0.25, 1.0, 0.875));
            list.add(new AxisAlignedBB(0.75, 0.5, 0.625, 0.875, 1.0, 0.875));
            return list;
        }
        if (new MutableBoundingBox(1, 1, 1, 3, 2, 1).func_175898_b((Vector3i)posInMultiblock)) {
            float maxX;
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>(3);
            float minY = 0.5f;
            float minX = posInMultiblock.func_177958_n() == 1 ? 0.4375f : 0.0f;
            float f = maxX = posInMultiblock.func_177958_n() == 3 ? 0.5625f : 1.0f;
            if (posInMultiblock.func_177956_o() == 1) {
                list.add(new AxisAlignedBB((double)minX, 0.5, 0.0, (double)maxX, 0.75, 1.0));
            } else {
                minY = 0.0f;
            }
            if (posInMultiblock.func_177958_n() == 1) {
                minX = 0.1875f;
            } else {
                float f2 = minX = posInMultiblock.func_177958_n() == 3 ? 0.5625f : 0.0f;
            }
            maxX = posInMultiblock.func_177958_n() == 3 ? 0.8125f : (posInMultiblock.func_177958_n() == 1 ? 0.4375f : 1.0f);
            list.add(new AxisAlignedBB((double)minX, (double)minY, 0.0, (double)maxX, 1.0, 1.0));
            return list;
        }
        if ((posInMultiblock.func_177952_p() == 0 || posInMultiblock.func_177952_p() == 2) && posInMultiblock.func_177956_o() > 0 && posInMultiblock.func_177958_n() > 0 && posInMultiblock.func_177958_n() < 4) {
            float maxZ;
            boolean front = posInMultiblock.func_177952_p() == 0;
            boolean right = posInMultiblock.func_177958_n() == 1;
            boolean left = posInMultiblock.func_177958_n() == 3;
            ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>(3);
            float minY = 0.5f;
            float minX = right ? 0.4375f : 0.0f;
            float maxX = left ? 0.5625f : 1.0f;
            float minZ = front ? 0.4375f : 0.0f;
            float f = maxZ = !front ? 0.5625f : 1.0f;
            if (posInMultiblock.func_177956_o() == 1) {
                list.add(new AxisAlignedBB((double)minX, 0.5, (double)minZ, (double)maxX, 0.75, (double)maxZ));
            } else {
                minY = 0.0f;
            }
            minX = right ? 0.1875f : 0.0f;
            maxX = left ? 0.8125f : 1.0f;
            minZ = front ? 0.1875f : 0.5625f;
            maxZ = !front ? 0.8125f : 0.4375f;
            list.add(new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, 1.0, (double)maxZ));
            if (!ImmutableSet.of((Object)new BlockPos(2, 1, 2), (Object)new BlockPos(2, 2, 2), (Object)new BlockPos(2, 1, 0), (Object)new BlockPos(2, 2, 0)).contains((Object)posInMultiblock)) {
                minX = right ? 0.1875f : 0.5625f;
                maxX = left ? 0.8125f : 0.4375f;
                minZ = front ? 0.4375f : 0.0f;
                maxZ = !front ? 0.5625f : 1.0f;
                list.add(new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, 1.0, (double)maxZ));
                if (ImmutableSet.of((Object)new BlockPos(3, 1, 2), (Object)new BlockPos(2, 1, 2), (Object)new BlockPos(1, 1, 2), (Object)new BlockPos(3, 1, 0), (Object)new BlockPos(2, 1, 0), (Object)new BlockPos(1, 1, 0), (Object[])new BlockPos[0]).contains((Object)posInMultiblock)) {
                    minZ = front ? 0.25f : 0.5f;
                    maxZ = front ? 0.5f : 0.75f;
                    list.add(new AxisAlignedBB(0.25, 0.0, (double)minZ, 0.75, 0.5, (double)maxZ));
                }
            }
            return list;
        }
        if (ImmutableSet.of((Object)new BlockPos(3, 0, 2), (Object)new BlockPos(1, 0, 2), (Object)new BlockPos(3, 0, 0), (Object)new BlockPos(1, 0, 0)).contains((Object)posInMultiblock)) {
            return Utils.flipBoxes(posInMultiblock.func_177952_p() == 0, posInMultiblock.func_177958_n() == 3, new AxisAlignedBB(0.25, 0.5, 0.5, 0.5, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0));
        }
        return CrusherTileEntity.getBasicShape(posInMultiblock).func_197756_d();
    }

    private boolean isInInput(boolean allowMiddleLayer) {
        if (this.posInMultiblock.func_177956_o() == 2 || allowMiddleLayer && this.posInMultiblock.func_177956_o() == 1) {
            return this.posInMultiblock.func_177958_n() > 0 && this.posInMultiblock.func_177958_n() < 4;
        }
        return false;
    }

    @Override
    public void onEntityCollision(World world, Entity entity) {
        boolean bpos = this.isInInput(true);
        if (bpos && !world.field_72995_K && entity.func_70089_S() && !this.isRSDisabled()) {
            int consumed;
            CrusherTileEntity master = (CrusherTileEntity)this.master();
            if (master == null) {
                return;
            }
            Vector3d center = Vector3d.func_237489_a_((Vector3i)master.func_174877_v()).func_72441_c(0.0, 0.25, 0.0);
            AxisAlignedBB crusherInternal = new AxisAlignedBB(center.field_72450_a - 1.0625, center.field_72448_b, center.field_72449_c - 1.0625, center.field_72450_a + 1.0625, center.field_72448_b + 1.25, center.field_72449_c + 1.0625);
            if (!entity.func_174813_aQ().func_72326_a(crusherInternal)) {
                return;
            }
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                ItemStack stack = itemEntity.func_92059_d();
                if (stack.func_190926_b()) {
                    return;
                }
                CrusherRecipe recipe = master.findRecipeForInsertion(stack);
                if (recipe == null) {
                    return;
                }
                ItemStack displayStack = recipe.getDisplayStack(stack);
                PoweredMultiblockTileEntity.MultiblockProcessInWorld<CrusherRecipe> process = new PoweredMultiblockTileEntity.MultiblockProcessInWorld<CrusherRecipe>(recipe, 0.5f, Utils.createNonNullItemStackListFromItemStack(displayStack));
                if (master.addProcessToQueue(process, true, true)) {
                    master.addProcessToQueue(process, false, true);
                    stack = stack.func_77946_l();
                    stack.func_190918_g(displayStack.func_190916_E());
                    if (stack.func_190926_b()) {
                        entity.func_70106_y();
                    } else {
                        itemEntity.func_92058_a(stack);
                    }
                }
            } else if (!(!(entity instanceof LivingEntity) || entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75102_a || (consumed = master.energyStorage.extractEnergy(80, true)) <= 0)) {
                master.energyStorage.extractEnergy(consumed, false);
                EventHandler.crusherMap.put(entity.func_110124_au(), master);
                entity.func_70097_a(IEDamageSources.crusher, (float)consumed / 20.0f);
            }
        }
    }

    @Override
    public Set<BlockPos> getEnergyPos() {
        return ImmutableSet.of((Object)new BlockPos(4, 1, 1));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(0, 1, 2));
    }

    @Override
    protected int getComparatorValueOnMaster() {
        float fill = (float)this.processQueue.size() / (float)this.getProcessQueueMaxLength();
        return MathHelper.func_76141_d((float)(fill * 14.0f)) + (fill > 0.0f ? 1 : 0);
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return true;
    }

    @Override
    public boolean additionalCanProcessCheck(PoweredMultiblockTileEntity.MultiblockProcess<CrusherRecipe> process) {
        return true;
    }

    @Override
    protected boolean shouldSyncProcessQueue() {
        return false;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.output, output, false)).func_190926_b()) {
            Utils.dropStackAtPos(this.field_145850_b, this.func_174877_v().func_177982_a(0, -1, 0).func_177967_a(this.getFacing(), -2), output, this.getFacing().func_176734_d());
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(PoweredMultiblockTileEntity.MultiblockProcess<CrusherRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 1;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 2048;
    }

    @Override
    public float getMinProcessDistance(PoweredMultiblockTileEntity.MultiblockProcess<CrusherRecipe> process) {
        return 0.0f;
    }

    @Override
    public int[] getCurrentProcessesStep() {
        CrusherTileEntity master = (CrusherTileEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesStep();
        }
        int[] ia = new int[this.processQueue.size() > 0 ? 1 : 0];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = ((PoweredMultiblockTileEntity.MultiblockProcess)this.processQueue.get((int)i)).processTick;
        }
        return ia;
    }

    @Override
    public int[] getCurrentProcessesMax() {
        CrusherTileEntity master = (CrusherTileEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesMax();
        }
        int[] ia = new int[this.processQueue.size() > 0 ? 1 : 0];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = ((PoweredMultiblockTileEntity.MultiblockProcess)this.processQueue.get((int)i)).maxTicks;
        }
        return ia;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 0;
    }

    @Override
    public int[] getOutputSlots() {
        return null;
    }

    @Override
    public int[] getOutputTanks() {
        return null;
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return null;
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(Direction side) {
        return new IFluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, Direction side, FluidStack resources) {
        return false;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, Direction side) {
        return false;
    }

    @Override
    public void doGraphicalUpdates() {
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        CrusherTileEntity master;
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.isInInput(false) && (master = (CrusherTileEntity)this.master()) != null) {
            return master.insertionHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public CrusherRecipe findRecipeForInsertion(ItemStack inserting) {
        return CrusherRecipe.findRecipe(inserting);
    }

    @Override
    protected CrusherRecipe getRecipeForId(ResourceLocation id) {
        return CrusherRecipe.recipeList.get(id);
    }

    @Override
    public boolean shouldPlaySound(String sound) {
        return this.shouldRenderAsActive();
    }
}

