/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.entities.ChemthrowerShotEntity;
import blusunrize.immersiveengineering.common.util.IEPotions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class ChemthrowerEffects {
    public static void register() {
        ChemthrowerHandler.registerEffect((ITag<Fluid>)FluidTags.field_206959_a, new ChemthrowerHandler.ChemthrowerEffect_Extinguish());
        ChemthrowerHandler.registerEffect(IETags.fluidPotion, new ChemthrowerHandler.ChemthrowerEffect(){

            @Override
            public void applyToEntity(LivingEntity target, @Nullable PlayerEntity shooter, ItemStack thrower, FluidStack fluid) {
                if (fluid.hasTag()) {
                    List effects = PotionUtils.func_185185_a((CompoundNBT)fluid.getOrCreateTag());
                    for (EffectInstance e : effects) {
                        EffectInstance newEffect = new EffectInstance(e.func_188419_a(), (int)Math.ceil((double)e.func_76459_b() * 0.05), e.func_76458_c());
                        newEffect.setCurativeItems(new ArrayList(e.getCurativeItems()));
                        target.func_195064_c(newEffect);
                    }
                }
            }

            @Override
            public void applyToEntity(LivingEntity target, @Nullable PlayerEntity shooter, ItemStack thrower, Fluid fluid) {
            }

            @Override
            public void applyToBlock(World world, RayTraceResult mop, @Nullable PlayerEntity shooter, ItemStack thrower, FluidStack fluid) {
            }

            @Override
            public void applyToBlock(World world, RayTraceResult mop, @Nullable PlayerEntity shooter, ItemStack thrower, Fluid fluid) {
            }
        });
        ChemthrowerHandler.registerEffect(IETags.fluidConcrete, new ChemthrowerHandler.ChemthrowerEffect(){

            @Override
            public void applyToEntity(LivingEntity target, @Nullable PlayerEntity shooter, ItemStack thrower, FluidStack fluid) {
                this.hit(target.field_70170_p, target.func_233580_cy_(), Direction.UP);
            }

            @Override
            public void applyToEntity(LivingEntity target, @Nullable PlayerEntity shooter, ItemStack thrower, Fluid fluid) {
            }

            @Override
            public void applyToBlock(World world, RayTraceResult mop, @Nullable PlayerEntity shooter, ItemStack thrower, FluidStack fluid) {
                if (!(mop instanceof BlockRayTraceResult)) {
                    return;
                }
                BlockRayTraceResult brtr = (BlockRayTraceResult)mop;
                BlockState hit = world.func_180495_p(brtr.func_216350_a());
                if (hit.func_177230_c() != IEBlocks.StoneDecoration.concreteSprayed) {
                    BlockPos pos = brtr.func_216350_a().func_177972_a(brtr.func_216354_b());
                    if (!world.func_175623_d(pos)) {
                        return;
                    }
                    AxisAlignedBB aabb = new AxisAlignedBB(pos);
                    List otherProjectiles = world.func_217357_a(ChemthrowerShotEntity.class, aabb);
                    if (otherProjectiles.size() >= 8) {
                        this.hit(world, pos, brtr.func_216354_b());
                    }
                }
            }

            @Override
            public void applyToBlock(World world, RayTraceResult mop, @Nullable PlayerEntity shooter, ItemStack thrower, Fluid fluid) {
            }

            private void hit(World world, BlockPos pos, Direction side) {
                AxisAlignedBB aabb = new AxisAlignedBB(pos);
                List otherProjectiles = world.func_217357_a(ChemthrowerShotEntity.class, aabb);
                for (ChemthrowerShotEntity shot : otherProjectiles) {
                    shot.func_70106_y();
                }
                world.func_175656_a(pos, IEBlocks.StoneDecoration.concreteSprayed.func_176223_P());
                for (LivingEntity living : world.func_217357_a(LivingEntity.class, aabb)) {
                    living.func_195064_c(new EffectInstance(IEPotions.concreteFeet, Integer.MAX_VALUE));
                }
            }
        });
        ChemthrowerHandler.registerEffect(IETags.fluidHerbicide, new ChemthrowerHandler.ChemthrowerEffect(){

            @Override
            public void applyToEntity(LivingEntity target, @Nullable PlayerEntity shooter, ItemStack thrower, Fluid fluid) {
            }

            @Override
            public void applyToBlock(World world, RayTraceResult mop, @Nullable PlayerEntity shooter, ItemStack thrower, Fluid fluid) {
                if (!(mop instanceof BlockRayTraceResult)) {
                    return;
                }
                BlockRayTraceResult brtr = (BlockRayTraceResult)mop;
                BlockState hit = world.func_180495_p(brtr.func_216350_a());
                if (hit.func_235714_a_((ITag)BlockTags.field_206952_E)) {
                    world.func_217377_a(brtr.func_216350_a(), false);
                } else if (hit.func_177230_c() instanceof SnowyDirtBlock || hit.func_177230_c() instanceof FarmlandBlock) {
                    world.func_175656_a(brtr.func_216350_a(), Blocks.field_150346_d.func_176223_P());
                    BlockPos above = brtr.func_216350_a().func_177984_a();
                    if (world.func_180495_p(above).func_177230_c() instanceof BushBlock) {
                        world.func_217377_a(above, false);
                    }
                }
                AxisAlignedBB aabb = new AxisAlignedBB(brtr.func_216350_a()).func_186662_g(0.25);
                List otherProjectiles = world.func_217357_a(ChemthrowerShotEntity.class, aabb);
                for (ChemthrowerShotEntity shot : otherProjectiles) {
                    shot.func_70106_y();
                }
            }
        });
        ChemthrowerHandler.registerEffect(IETags.fluidCreosote, new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, IEPotions.flammable, 140, 0));
        ChemthrowerHandler.registerFlammable(IETags.fluidCreosote);
        ChemthrowerHandler.registerEffect(IETags.fluidBiodiesel, new ChemthrowerHandler.ChemthrowerEffect_Potion(null, 0.0f, IEPotions.flammable, 140, 1));
        ChemthrowerHandler.registerFlammable(IETags.fluidBiodiesel);
        ChemthrowerHandler.registerFlammable(IETags.fluidEthanol);
    }
}

