/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.fluids.IEItemFluidHandler;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Triple;

public abstract class DieselToolItem
extends UpgradeableToolItem
implements IEItemInterfaces.IAdvancedFluidItem,
IOBJModelCallback<ItemStack>,
ITool {
    protected static final int CAPACITY = 2000;
    private final Map<UUID, Integer> animationTimer = new HashMap<UUID, Integer>();

    public DieselToolItem(String name, Item.Properties props, String upgradeType) {
        super(name, props, upgradeType);
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }

    public int func_77619_b() {
        return 0;
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT ret = super.getShareTag(stack);
        ret = ret == null ? new CompoundNBT() : ret.func_74737_b();
        ItemStack head = this.getHead(stack);
        if (!head.func_190926_b()) {
            ret.func_218657_a("head", (INBT)head.func_77955_b(new CompoundNBT()));
        }
        return ret;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (nbt != null) {
            this.setHead(stack, ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("head")));
            nbt.func_82580_o("head");
        }
        super.readShareTag(stack, nbt);
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundNBT nbt) {
        if (!stack.func_190926_b()) {
            return new IEItemStackHandler(stack){
                private final LazyOptional<IEItemFluidHandler> fluids;
                private final LazyOptional<CapabilityShader.ShaderWrapper_Item> shaders;
                {
                    super(stack2);
                    this.fluids = CapabilityUtils.constantOptional(new IEItemFluidHandler(stack, 2000));
                    this.shaders = CapabilityUtils.constantOptional(new CapabilityShader.ShaderWrapper_Item(DieselToolItem.this.getRegistryName(), stack));
                }

                @Override
                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                        return this.fluids.cast();
                    }
                    if (capability == CapabilityShader.SHADER_CAPABILITY) {
                        return this.shaders.cast();
                    }
                    return super.getCapability(capability, facing);
                }
            };
        }
        return null;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)this.getHeadDamage(stack) / (double)this.getMaxHeadDamage(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getHeadDamage(stack) > 0;
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public void finishUpgradeRecalculation(ItemStack stack) {
        super.finishUpgradeRecalculation(stack);
        FluidStack fs = this.getFluid(stack);
        if (fs != null && fs.getAmount() > this.getCapacity(stack, 2000)) {
            fs.setAmount(this.getCapacity(stack, 2000));
            ItemNBTHelper.setFluidStack(stack, "Fluid", fs);
        }
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity player) {
        this.consumeDurability(stack, target.func_130014_f_(), null, null, player);
        return true;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    @Override
    public int getCapacity(ItemStack container, int baseCapacity) {
        return baseCapacity + this.getUpgrades(container).func_74762_e("capacity");
    }

    @Override
    public boolean allowFluid(ItemStack container, FluidStack fluid) {
        return fluid != null && DieselHandler.isValidDrillFuel(fluid.getFluid());
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        return this.isEffective(stack, state.func_185904_a()) && this.canToolBeUsed(stack, null);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        ItemStack head;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (slot == EquipmentSlotType.MAINHAND && !(head = this.getHead(stack)).func_190926_b() && this.canToolBeUsed(stack, null)) {
            builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", this.getAttackDamage(stack, head), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", -2.5, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        LazyOptional wrapperOld = oldStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
        Optional sameShader = wrapperOld.map(wOld -> {
            LazyOptional wrapperNew = newStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
            return wrapperNew.map(w -> ItemStack.func_77989_b((ItemStack)wOld.getShaderItem(), (ItemStack)w.getShaderItem())).orElse(true);
        });
        if (!sameShader.orElse(true).booleanValue()) {
            return true;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (this.canToolBeUsed(stack, entity)) {
            if (!this.animationTimer.containsKey(entity.func_110124_au())) {
                this.animationTimer.put(entity.func_110124_au(), 40);
            } else if (this.animationTimer.get(entity.func_110124_au()) < 20) {
                this.animationTimer.put(entity.func_110124_au(), 20);
            }
        }
        return true;
    }

    protected void consumeDurability(ItemStack stack, World world, @Nullable BlockState state, @Nullable BlockPos pos, LivingEntity living) {
        Preconditions.checkArgument((pos == null == (state == null) ? 1 : 0) != 0);
        if (state == null || state.func_185887_b((IBlockReader)world, pos) != 0.0f) {
            int dmg = state == null || ForgeHooks.isToolEffective((IWorldReader)world, (BlockPos)pos, (ItemStack)stack) || this.isEffective(stack, state.func_185904_a()) ? 1 : 3;
            ItemStack head = this.getHead(stack);
            if (!head.func_190926_b()) {
                if (!this.getUpgrades(stack).func_74767_n("oiled") || Utils.RAND.nextInt(4) == 0) {
                    this.damageHead(head, dmg, living);
                }
                this.setHead(stack, head);
                IFluidHandler handler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)stack).orElseThrow(RuntimeException::new);
                handler.drain(1, IFluidHandler.FluidAction.EXECUTE);
                Triple<ItemStack, ShaderRegistry.ShaderRegistryEntry, ShaderCase> shader = ShaderRegistry.getStoredShaderAndCase(stack);
                if (shader != null) {
                    Vector3d particlePos = pos != null ? Vector3d.func_237489_a_((Vector3i)pos) : living.func_213303_ch();
                    ((ShaderRegistry.ShaderRegistryEntry)shader.getMiddle()).getEffectFunction().execute(world, (ItemStack)shader.getLeft(), stack, ((ShaderCase)shader.getRight()).getShaderType().toString(), particlePos, null, 0.375f);
                }
            }
        }
    }

    protected boolean shouldRotate(LivingEntity entity, ItemStack stack, ItemCameraTransforms.TransformType transform) {
        return !(entity == null || !this.canToolBeUsed(stack, entity) || entity.func_184586_b(Hand.MAIN_HAND) != stack && entity.func_184586_b(Hand.OFF_HAND) != stack || transform != ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND && transform != ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND && transform != ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND && transform != ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND);
    }

    protected abstract void damageHead(ItemStack var1, int var2, LivingEntity var3);

    protected abstract double getAttackDamage(ItemStack var1, ItemStack var2);

    public abstract boolean isEffective(ItemStack var1, Material var2);

    protected abstract boolean canToolBeUsed(ItemStack var1, @Nullable LivingEntity var2);

    protected abstract ItemStack getHead(ItemStack var1);

    protected abstract void setHead(ItemStack var1, ItemStack var2);

    public abstract int getMaxHeadDamage(ItemStack var1);

    public abstract int getHeadDamage(ItemStack var1);
}

