/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.IEPotions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpawnInterdictionHandler {
    private static final Map<RegistryKey<World>, Set<IEBlockInterfaces.ISpawnInterdiction>> interdictionTiles = new HashMap<RegistryKey<World>, Set<IEBlockInterfaces.ISpawnInterdiction>>();

    @SubscribeEvent
    public static void onEnderTeleport(EnderTeleportEvent event) {
        if (SpawnInterdictionHandler.shouldCancel(event.getEntity()) || event.getEntityLiving().func_70660_b(IEPotions.stunned) != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntitySpawnCheck(LivingSpawnEvent.CheckSpawn event) {
        if (event.getResult() == Event.Result.ALLOW || event.getResult() == Event.Result.DENY || event.isSpawner()) {
            return;
        }
        if (SpawnInterdictionHandler.shouldCancel(event.getEntity())) {
            event.setResult(Event.Result.DENY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean shouldCancel(Entity entity) {
        if (entity.func_200600_R().func_220339_d() != EntityClassification.MONSTER) {
            return false;
        }
        RegistryKey dimension = entity.field_70170_p.func_234923_W_();
        Map<RegistryKey<World>, Set<IEBlockInterfaces.ISpawnInterdiction>> map = interdictionTiles;
        synchronized (map) {
            if (!interdictionTiles.containsKey(dimension)) {
                return false;
            }
            Iterator<IEBlockInterfaces.ISpawnInterdiction> it = interdictionTiles.get(dimension).iterator();
            while (it.hasNext()) {
                Vector3d tilePos;
                IEBlockInterfaces.ISpawnInterdiction interdictor = it.next();
                if (!(interdictor instanceof TileEntity)) continue;
                TileEntity interdictorTE = (TileEntity)interdictor;
                if (interdictorTE.func_145837_r() || interdictorTE.func_145831_w() == null) {
                    it.remove();
                    continue;
                }
                if (!SafeChunkUtils.isChunkSafe((IWorld)interdictorTE.func_145831_w(), interdictorTE.func_174877_v()) || !((tilePos = Vector3d.func_237489_a_((Vector3i)interdictorTE.func_174877_v())).func_72436_e(entity.func_213303_ch()) <= interdictor.getInterdictionRangeSquared())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TileEntity> void removeFromInterdictionTiles(T tile) {
        Map<RegistryKey<World>, Set<IEBlockInterfaces.ISpawnInterdiction>> map = interdictionTiles;
        synchronized (map) {
            Set<IEBlockInterfaces.ISpawnInterdiction> inDimension = interdictionTiles.get(tile.func_145831_w().func_234923_W_());
            if (inDimension != null) {
                inDimension.remove(tile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TileEntity> void addInterdictionTile(T tile) {
        World world = tile.func_145831_w();
        if (world != null && ((Boolean)IEServerConfig.MACHINES.floodlight_spawnPrevent.get()).booleanValue()) {
            Map<RegistryKey<World>, Set<IEBlockInterfaces.ISpawnInterdiction>> map = interdictionTiles;
            synchronized (map) {
                Set forDim = interdictionTiles.computeIfAbsent((RegistryKey<World>)world.func_234923_W_(), x -> new HashSet());
                forDim.add((IEBlockInterfaces.ISpawnInterdiction)tile);
            }
        }
    }
}

