/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker.managers;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CrTIngredientUtil;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.AbstractActionGenericRemoveRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.actions.ActionAddRecipeCustomOutput;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.brackets.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.item.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.fluid.MCFluidStackMutable;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="mods/immersiveengineering/Squeezer")
@ZenCodeType.Name(value="mods.immersiveengineering.Squeezer")
public class SqueezerRecipeManager
implements IRecipeManager {
    public IRecipeType<SqueezerRecipe> getRecipeType() {
        return SqueezerRecipe.TYPE;
    }

    @ZenCodeType.Method
    public void removeRecipe(final IFluidStack fluidStack) {
        AbstractActionGenericRemoveRecipe<SqueezerRecipe> action = new AbstractActionGenericRemoveRecipe<SqueezerRecipe>((IRecipeManager)this, (CommandStringDisplayable)fluidStack){

            @Override
            public boolean shouldRemove(SqueezerRecipe recipe) {
                return recipe.fluidOutput.isFluidStackIdentical(fluidStack.getInternal());
            }
        };
        CraftTweakerAPI.apply((IAction)action);
    }

    @ZenCodeType.Method
    public void removeRecipe(final Fluid fluid) {
        AbstractActionGenericRemoveRecipe<SqueezerRecipe> action = new AbstractActionGenericRemoveRecipe<SqueezerRecipe>((IRecipeManager)this, fluid){

            @Override
            public boolean shouldRemove(SqueezerRecipe recipe) {
                return fluid.func_207187_a(recipe.fluidOutput.getFluid());
            }
        };
        CraftTweakerAPI.apply((IAction)action);
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, IIngredientWithAmount input, int energy, IFluidStack fluidOutput, @ZenCodeType.Optional(value="<item:minecraft:air>") IItemStack itemOutput) {
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", recipePath);
        IngredientWithSize inputWithSize = CrTIngredientUtil.getIngredientWithSize(input);
        FluidStack fluidOut = fluidOutput.getInternal();
        ItemStack itemOut = itemOutput.getInternal();
        SqueezerRecipe recipe = new SqueezerRecipe(resourceLocation, fluidOut, itemOut, inputWithSize, energy);
        String outputDescription = String.format("%s and %s", fluidOutput.getCommandString(), itemOutput.getCommandString());
        CraftTweakerAPI.apply((IAction)new ActionAddRecipeCustomOutput((IRecipeManager)this, recipe, outputDescription));
    }

    @ZenCodeType.Method
    public void addRecipe(String recipePath, IIngredientWithAmount input, int energy, IItemStack itemOutput) {
        this.addRecipe(recipePath, input, energy, (IFluidStack)new MCFluidStackMutable(FluidStack.EMPTY), itemOutput);
    }
}

