/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.core;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.addons.core.PluginCore;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITaggableList;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.block.BlockState;
import net.minecraft.block.TrappedChestBlock;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.INameable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import snownee.jade.Jade;
import snownee.jade.JadeCommonConfig;
import snownee.jade.JadePlugin;
import snownee.jade.Renderables;
import snownee.jade.addon.vanilla.TrappedChestProvider;

public class HUDHandlerBlocks
implements IComponentProvider,
IServerDataProvider<TileEntity> {
    public static final HUDHandlerBlocks INSTANCE = new HUDHandlerBlocks();
    public static final ResourceLocation OBJECT_NAME_TAG = new ResourceLocation("waila", "object_name");
    public static final ResourceLocation REGISTRY_NAME_TAG = new ResourceLocation("waila", "registry_name");
    public static final ResourceLocation MOD_NAME_TAG = new ResourceLocation("waila", "mod_name");

    @Override
    public void appendHead(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        ItemStack pick;
        Object name = null;
        if (accessor.getServerData().func_150297_b("givenName", 8)) {
            name = ITextComponent.Serializer.func_240643_a_((String)accessor.getServerData().func_74779_i("givenName"));
        }
        if (name == null && accessor.getBlockState().func_235714_a_(Jade.PICK) && (pick = accessor.getBlockState().getPickBlock(accessor.getHitResult(), (IBlockReader)accessor.getWorld(), accessor.getPosition(), accessor.getPlayer())) != null && !pick.func_190926_b()) {
            name = pick.func_200301_q();
        }
        if (name == null) {
            ItemStack stack;
            String key = accessor.getBlock().func_149739_a();
            name = I18n.func_188566_a((String)key) ? accessor.getBlock().func_235333_g_() : ((stack = accessor.getBlockState().getPickBlock(accessor.getHitResult(), (IBlockReader)accessor.getWorld(), accessor.getPosition(), accessor.getPlayer())) != null && !stack.func_190926_b() ? stack.func_200301_q() : new StringTextComponent(key));
        }
        ((ITaggableList)tooltip).setTag(OBJECT_NAME_TAG, new StringTextComponent(String.format(Waila.CONFIG.get().getFormatting().getBlockName(), name.getString())));
        if (config.get(PluginCore.CONFIG_SHOW_REGISTRY)) {
            ((ITaggableList)tooltip).setTag(REGISTRY_NAME_TAG, new StringTextComponent(accessor.getBlock().getRegistryName().toString()).func_240699_a_(TextFormatting.GRAY));
        }
        if (accessor.getBlock() instanceof TrappedChestBlock) {
            TrappedChestProvider.INSTANCE.appendHead(tooltip, accessor, config);
        }
    }

    @Override
    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (config.get(PluginCore.CONFIG_SHOW_STATES)) {
            BlockState state = accessor.getBlockState();
            Collection properties = state.func_235904_r_();
            if (properties.isEmpty()) {
                return;
            }
            ITextComponent[] lines = new ITextComponent[properties.size()];
            int i = 0;
            for (Property p : state.func_235904_r_()) {
                Comparable value = state.func_177229_b(p);
                IFormattableTextComponent valueText = new StringTextComponent(" " + value.toString()).func_240699_a_(p instanceof BooleanProperty ? (value == Boolean.TRUE ? TextFormatting.GREEN : TextFormatting.RED) : TextFormatting.WHITE);
                lines[i] = new StringTextComponent(p.func_177701_a() + ":").func_230529_a_((ITextComponent)valueText);
                ++i;
            }
            tooltip.add((ITextComponent)Renderables.box(lines));
        }
    }

    @Override
    public void appendTail(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        if (config.get(JadePlugin.HIDE_MOD_NAME)) {
            return;
        }
        String modName = ModIdentification.getModName(accessor.getBlock());
        if (!Strings.isNullOrEmpty((String)modName)) {
            modName = String.format(Waila.CONFIG.get().getFormatting().getModName(), modName);
            ((ITaggableList)tooltip).setTag(MOD_NAME_TAG, new StringTextComponent(modName));
        }
    }

    @Override
    public void appendServerData(CompoundNBT data, ServerPlayerEntity player, World world, TileEntity t) {
        INameable nameable;
        if (t instanceof INameable && JadeCommonConfig.shouldShowCustomName(t) && (nameable = (INameable)t).func_145818_k_()) {
            data.func_74778_a("givenName", ITextComponent.Serializer.func_150696_a((ITextComponent)nameable.func_200201_e()));
        }
    }
}

