/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.minecraft;

import java.util.List;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.addons.minecraft.PluginMinecraft;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITaggableList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.JukeboxBlock;
import net.minecraft.block.LeverBlock;
import net.minecraft.block.SilverfishBlock;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ComparatorMode;
import net.minecraft.tileentity.JukeboxTileEntity;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class HUDHandlerVanilla
implements IComponentProvider,
IServerDataProvider<TileEntity> {
    static final HUDHandlerVanilla INSTANCE = new HUDHandlerVanilla();
    static final ResourceLocation OBJECT_NAME_TAG = new ResourceLocation("waila", "object_name");

    @Override
    public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
        Block block = accessor.getBlock();
        if (config.get(PluginMinecraft.CONFIG_HIDE_SILVERFISH) && block instanceof SilverfishBlock) {
            return new ItemStack((IItemProvider)((SilverfishBlock)block).func_196468_d().func_199767_j());
        }
        if (block == Blocks.field_150464_aj) {
            return new ItemStack((IItemProvider)Items.field_151015_O);
        }
        if (block == Blocks.field_185773_cZ) {
            return new ItemStack((IItemProvider)Items.field_185164_cV);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void appendHead(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        Block block = accessor.getBlock();
        if (config.get(PluginMinecraft.CONFIG_HIDE_SILVERFISH) && block instanceof SilverfishBlock) {
            ((ITaggableList)tooltip).setTag(OBJECT_NAME_TAG, new StringTextComponent(String.format(Waila.CONFIG.get().getFormatting().getBlockName(), accessor.getStack().func_200301_q().getString())));
        }
        if (block == Blocks.field_150474_ac && config.get(PluginMinecraft.CONFIG_SPAWNER_TYPE)) {
            MobSpawnerTileEntity spawner = (MobSpawnerTileEntity)accessor.getTileEntity();
            String name = I18n.func_135052_a((String)accessor.getBlock().func_149739_a(), (Object[])new Object[0]);
            name = I18n.func_135052_a((String)"jade.spawner", (Object[])new Object[]{name, spawner.func_145881_a().func_184994_d().func_145748_c_().getString()});
            name = String.format(Waila.CONFIG.get().getFormatting().getBlockName(), name);
            ((ITaggableList)tooltip).setTag(OBJECT_NAME_TAG, new StringTextComponent(name));
        }
    }

    @Override
    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        BlockState state = accessor.getBlockState();
        Block block = state.func_177230_c();
        if (config.get(PluginMinecraft.CONFIG_CROP_PROGRESS)) {
            if (block instanceof CropsBlock) {
                CropsBlock crop = (CropsBlock)block;
                HUDHandlerVanilla.addMaturityTooltip(tooltip, (float)((Integer)state.func_177229_b((Property)crop.func_185524_e())).intValue() / (float)crop.func_185526_g());
            } else if (block == Blocks.field_150394_bc || block == Blocks.field_150393_bb) {
                HUDHandlerVanilla.addMaturityTooltip(tooltip, (float)((Integer)state.func_177229_b((Property)BlockStateProperties.field_208170_W)).intValue() / 7.0f);
            } else if (block == Blocks.field_150375_by) {
                HUDHandlerVanilla.addMaturityTooltip(tooltip, (float)((Integer)state.func_177229_b((Property)BlockStateProperties.field_208167_T)).intValue() / 2.0f);
            }
        }
        if (config.get(PluginMinecraft.CONFIG_LEVER) && block instanceof LeverBlock) {
            boolean active = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u);
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waila.state", new Object[]{new TranslationTextComponent("tooltip.waila.state_" + (active ? "on" : "off"))}));
            return;
        }
        if (config.get(PluginMinecraft.CONFIG_REPEATER) && block == Blocks.field_196633_cV) {
            int delay = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208126_aa);
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waila.delay", new Object[]{TextFormatting.WHITE.toString() + delay}));
            return;
        }
        if (config.get(PluginMinecraft.CONFIG_COMPARATOR) && block == Blocks.field_196762_fd) {
            ComparatorMode mode = (ComparatorMode)state.func_177229_b((Property)BlockStateProperties.field_208141_ap);
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waila.mode", new Object[]{new TranslationTextComponent("tooltip.waila.mode_" + (mode == ComparatorMode.COMPARE ? "comparator" : "subtractor"))}));
            return;
        }
        if (config.get(PluginMinecraft.CONFIG_REDSTONE) && state.func_235901_b_((Property)BlockStateProperties.field_208136_ak)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waila.power", new Object[]{TextFormatting.WHITE.toString() + state.func_177229_b((Property)BlockStateProperties.field_208136_ak)}));
            return;
        }
        if (config.get(PluginMinecraft.CONFIG_JUKEBOX) && block == Blocks.field_150421_aI) {
            if (((Boolean)state.func_177229_b((Property)JukeboxBlock.field_176432_a)).booleanValue() && accessor.getServerData().func_74764_b("record")) {
                try {
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(accessor.getServerData().func_74779_i("record")));
                    if (item instanceof MusicDiscItem) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("record.nowPlaying", new Object[]{((MusicDiscItem)item).func_234801_g_()}));
                    }
                }
                catch (Exception e) {
                    Waila.LOGGER.catching((Throwable)e);
                }
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waila.empty"));
            }
        }
    }

    @Override
    public void appendServerData(CompoundNBT data, ServerPlayerEntity player, World world, TileEntity blockEntity) {
        JukeboxTileEntity jukebox;
        ItemStack stack;
        if (blockEntity instanceof JukeboxTileEntity && !(stack = (jukebox = (JukeboxTileEntity)blockEntity).func_195537_c()).func_190926_b()) {
            data.func_74778_a("record", stack.func_77973_b().getRegistryName().toString());
        }
    }

    private static void addMaturityTooltip(List<ITextComponent> tooltip, float growthValue) {
        if ((growthValue *= 100.0f) < 100.0f) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waila.crop_growth", new Object[]{TextFormatting.WHITE + String.format("%.0f%%", Float.valueOf(growthValue))}));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.waila.crop_growth", new Object[]{new TranslationTextComponent("tooltip.waila.crop_mature").func_240699_a_(TextFormatting.GREEN)}));
        }
    }
}

