/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common;

import java.util.Random;
import mekanism.api.providers.IItemProvider;
import mekanism.common.Mekanism;
import mekanism.common.base.IModModule;
import mekanism.common.config.MekanismModConfig;
import mekanism.common.lib.Version;
import mekanism.tools.common.config.MekanismToolsConfig;
import mekanism.tools.common.config.ToolsConfig;
import mekanism.tools.common.registries.ToolsItems;
import mekanism.tools.common.registries.ToolsRecipeSerializers;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="mekanismtools")
public class MekanismTools
implements IModModule {
    public static final String MODID = "mekanismtools";
    public static MekanismTools instance;
    public final Version versionNumber;

    public MekanismTools() {
        instance = this;
        Mekanism.modulesLoaded.add(instance);
        MekanismToolsConfig.registerConfigs(ModLoadingContext.get());
        MinecraftForge.EVENT_BUS.addListener(this::onLivingSpecialSpawn);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onConfigLoad);
        ToolsItems.ITEMS.register(modEventBus);
        ToolsRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        this.versionNumber = new Version(ModLoadingContext.get().getActiveContainer());
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    private void onConfigLoad(ModConfig.ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals(MODID) && config instanceof MekanismModConfig) {
            ((MekanismModConfig)config).clearCache();
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        Mekanism.logger.info("Loaded 'Mekanism: Tools' module.");
    }

    private void setStackIfEmpty(LivingEntity entity, EquipmentSlotType slot, ItemStack item) {
        if (entity.func_184582_a(slot).func_190926_b()) {
            entity.func_184201_a(slot, item);
        }
    }

    private void setEntityArmorWithChance(Random random, LivingEntity entity, IItemProvider sword, IItemProvider helmet, IItemProvider chestplate, IItemProvider leggings, IItemProvider boots, ToolsConfig.ArmorSpawnChanceConfig chanceConfig) {
        if (entity instanceof ZombieEntity && random.nextDouble() < chanceConfig.swordChance.get()) {
            this.setStackIfEmpty(entity, EquipmentSlotType.MAINHAND, sword.getItemStack());
        }
        if (random.nextDouble() < chanceConfig.helmetChance.get()) {
            this.setStackIfEmpty(entity, EquipmentSlotType.HEAD, helmet.getItemStack());
        }
        if (random.nextDouble() < chanceConfig.chestplateChance.get()) {
            this.setStackIfEmpty(entity, EquipmentSlotType.CHEST, chestplate.getItemStack());
        }
        if (random.nextDouble() < chanceConfig.leggingsChance.get()) {
            this.setStackIfEmpty(entity, EquipmentSlotType.LEGS, leggings.getItemStack());
        }
        if (random.nextDouble() < chanceConfig.bootsChance.get()) {
            this.setStackIfEmpty(entity, EquipmentSlotType.FEET, boots.getItemStack());
        }
    }

    private void onLivingSpecialSpawn(LivingSpawnEvent.SpecialSpawn event) {
        Random random;
        double chance;
        LivingEntity entity = event.getEntityLiving();
        if ((entity instanceof ZombieEntity || entity instanceof SkeletonEntity || entity instanceof PiglinEntity) && (chance = (random = event.getWorld().func_201674_k()).nextDouble()) < MekanismToolsConfig.tools.armorSpawnRate.get()) {
            int armorType;
            int n = armorType = entity instanceof PiglinEntity ? 0 : random.nextInt(6);
            if (armorType == 0) {
                this.setEntityArmorWithChance(random, entity, (IItemProvider)ToolsItems.REFINED_GLOWSTONE_SWORD, (IItemProvider)ToolsItems.REFINED_GLOWSTONE_HELMET, (IItemProvider)ToolsItems.REFINED_GLOWSTONE_CHESTPLATE, (IItemProvider)ToolsItems.REFINED_GLOWSTONE_LEGGINGS, (IItemProvider)ToolsItems.REFINED_GLOWSTONE_BOOTS, MekanismToolsConfig.tools.refinedGlowstoneSpawnRate);
            } else if (armorType == 1) {
                this.setEntityArmorWithChance(random, entity, (IItemProvider)ToolsItems.LAPIS_LAZULI_SWORD, (IItemProvider)ToolsItems.LAPIS_LAZULI_HELMET, (IItemProvider)ToolsItems.LAPIS_LAZULI_CHESTPLATE, (IItemProvider)ToolsItems.LAPIS_LAZULI_LEGGINGS, (IItemProvider)ToolsItems.LAPIS_LAZULI_BOOTS, MekanismToolsConfig.tools.lapisLazuliSpawnRate);
            } else if (armorType == 2) {
                this.setEntityArmorWithChance(random, entity, (IItemProvider)ToolsItems.REFINED_OBSIDIAN_SWORD, (IItemProvider)ToolsItems.REFINED_OBSIDIAN_HELMET, (IItemProvider)ToolsItems.REFINED_OBSIDIAN_CHESTPLATE, (IItemProvider)ToolsItems.REFINED_OBSIDIAN_LEGGINGS, (IItemProvider)ToolsItems.REFINED_OBSIDIAN_BOOTS, MekanismToolsConfig.tools.refinedObsidianSpawnRate);
            } else if (armorType == 3) {
                this.setEntityArmorWithChance(random, entity, (IItemProvider)ToolsItems.STEEL_SWORD, (IItemProvider)ToolsItems.STEEL_HELMET, (IItemProvider)ToolsItems.STEEL_CHESTPLATE, (IItemProvider)ToolsItems.STEEL_LEGGINGS, (IItemProvider)ToolsItems.STEEL_BOOTS, MekanismToolsConfig.tools.steelSpawnRate);
            } else if (armorType == 4) {
                this.setEntityArmorWithChance(random, entity, (IItemProvider)ToolsItems.BRONZE_SWORD, (IItemProvider)ToolsItems.BRONZE_HELMET, (IItemProvider)ToolsItems.BRONZE_CHESTPLATE, (IItemProvider)ToolsItems.BRONZE_LEGGINGS, (IItemProvider)ToolsItems.BRONZE_BOOTS, MekanismToolsConfig.tools.bronzeSpawnRate);
            } else {
                this.setEntityArmorWithChance(random, entity, (IItemProvider)ToolsItems.OSMIUM_SWORD, (IItemProvider)ToolsItems.OSMIUM_HELMET, (IItemProvider)ToolsItems.OSMIUM_CHESTPLATE, (IItemProvider)ToolsItems.OSMIUM_LEGGINGS, (IItemProvider)ToolsItems.OSMIUM_BOOTS, MekanismToolsConfig.tools.osmiumSpawnRate);
            }
        }
    }

    public Version getVersion() {
        return this.versionNumber;
    }

    public String getName() {
        return "Tools";
    }

    public void resetClient() {
    }
}

