/*
 * Decompiled with CFR 0.152.
 */
package mekanism.tools.common.material;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedFloatValue;
import mekanism.common.config.value.CachedIntValue;
import mekanism.tools.common.material.BaseMekanismMaterial;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.ForgeConfigSpec;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class MaterialCreator
extends BaseMekanismMaterial {
    private final BaseMekanismMaterial fallBack;
    private final CachedIntValue shieldDurability;
    public final CachedFloatValue swordDamage;
    public final CachedFloatValue swordAtkSpeed;
    public final CachedFloatValue shovelDamage;
    public final CachedFloatValue shovelAtkSpeed;
    public final CachedFloatValue axeDamage;
    public final CachedFloatValue axeAtkSpeed;
    public final CachedFloatValue pickaxeDamage;
    public final CachedFloatValue pickaxeAtkSpeed;
    public final CachedFloatValue hoeDamage;
    public final CachedFloatValue hoeAtkSpeed;
    private final CachedIntValue paxelHarvestLevel;
    public final CachedFloatValue paxelDamage;
    public final CachedFloatValue paxelAtkSpeed;
    private final CachedFloatValue paxelEfficiency;
    private final CachedIntValue paxelEnchantability;
    private final CachedIntValue paxelMaxUses;
    private final CachedIntValue toolMaxUses;
    private final CachedFloatValue efficiency;
    public final CachedFloatValue attackDamage;
    private final CachedIntValue harvestLevel;
    private final CachedIntValue enchantability;
    public final CachedFloatValue toughness;
    public final CachedFloatValue knockbackResistance;
    private final CachedIntValue bootDurability;
    private final CachedIntValue leggingDurability;
    private final CachedIntValue chestplateDurability;
    private final CachedIntValue helmetDurability;
    public final CachedIntValue bootArmor;
    public final CachedIntValue leggingArmor;
    public final CachedIntValue chestplateArmor;
    public final CachedIntValue helmetArmor;

    public MaterialCreator(IMekanismConfig config, ForgeConfigSpec.Builder builder, BaseMekanismMaterial materialDefaults) {
        this.fallBack = materialDefaults;
        String toolKey = this.getRegistryPrefix();
        String name = this.getConfigCommentName();
        builder.comment("Material Settings for " + name).push(toolKey);
        this.attackDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Base attack damage of " + name + " items.").defineInRange(toolKey + "AttackDamage", (double)materialDefaults.func_200929_c(), 0.0, 3.4028234663852886E38));
        Predicate<Object> damageModifierPredicate = value -> {
            if (value instanceof Double) {
                double val = (Double)value;
                float actualValue = val > 3.4028234663852886E38 ? Float.MAX_VALUE : (val < -3.4028234663852886E38 ? -3.4028235E38f : (float)val);
                float baseDamage = this.attackDamage.get();
                return actualValue >= -baseDamage && actualValue <= Float.MAX_VALUE - baseDamage;
            }
            return false;
        };
        this.shieldDurability = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " shields.").defineInRange(toolKey + "ShieldDurability", materialDefaults.getShieldDurability(), 0, Integer.MAX_VALUE));
        this.swordDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + name + " swords.").define(toolKey + "SwordDamage", (Object)materialDefaults.getSwordDamage(), damageModifierPredicate));
        this.swordAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack speed of " + name + " swords.").define(toolKey + "SwordAtkSpeed", (Object)materialDefaults.getSwordAtkSpeed()));
        this.shovelDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + name + " shovels.").define(toolKey + "ShovelDamage", (Object)materialDefaults.getShovelDamage(), damageModifierPredicate));
        this.shovelAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack speed of " + name + " shovels.").define(toolKey + "ShovelAtkSpeed", (Object)materialDefaults.getShovelAtkSpeed()));
        this.axeDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + name + " axes.").define(toolKey + "AxeDamage", (Object)materialDefaults.getAxeDamage(), damageModifierPredicate));
        this.axeAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack speed of " + name + " axes.").define(toolKey + "AxeAtkSpeed", (Object)materialDefaults.getAxeAtkSpeed()));
        this.pickaxeDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + name + " pickaxes.").define(toolKey + "PickaxeDamage", (Object)materialDefaults.getPickaxeDamage(), damageModifierPredicate));
        this.pickaxeAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack speed of " + name + " pickaxes.").define(toolKey + "PickaxeAtkSpeed", (Object)materialDefaults.getPickaxeAtkSpeed()));
        this.hoeDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + name + " hoes.").define(toolKey + "HoeDamage", (Object)materialDefaults.getHoeDamage(), damageModifierPredicate));
        this.hoeAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack speed of " + name + " hoes.").define(toolKey + "HoeAtkSpeed", (Object)materialDefaults.getHoeAtkSpeed()));
        this.toolMaxUses = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " tools.").defineInRange(toolKey + "ToolMaxUses", materialDefaults.func_200926_a(), 1, Integer.MAX_VALUE));
        this.efficiency = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Efficiency of " + name + " tools.").define(toolKey + "Efficiency", (Object)materialDefaults.func_200928_b()));
        this.paxelHarvestLevel = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Harvest level of " + name + " paxels.").defineInRange(toolKey + "PaxelHarvestLevel", materialDefaults.getPaxelHarvestLevel(), 0, Integer.MAX_VALUE));
        this.paxelDamage = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack damage modifier of " + name + " paxels.").define(toolKey + "PaxelDamage", (Object)materialDefaults.getPaxelDamage(), damageModifierPredicate));
        this.paxelAtkSpeed = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Attack speed of " + name + " paxels.").define(toolKey + "PaxelAtkSpeed", (Object)materialDefaults.getPaxelAtkSpeed()));
        this.paxelEfficiency = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Efficiency of " + name + " paxels.").define(toolKey + "PaxelEfficiency", (Object)materialDefaults.getPaxelEfficiency()));
        this.paxelEnchantability = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Natural enchantability factor of " + name + " paxels.").defineInRange(toolKey + "PaxelEnchantability", materialDefaults.getPaxelEnchantability(), 0, Integer.MAX_VALUE));
        this.paxelMaxUses = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " paxels.").defineInRange(toolKey + "PaxelMaxUses", materialDefaults.getPaxelMaxUses(), 1, Integer.MAX_VALUE));
        this.harvestLevel = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Harvest level of " + name + " tools.").defineInRange(toolKey + "HarvestLevel", materialDefaults.func_200925_d(), 0, Integer.MAX_VALUE));
        this.enchantability = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Natural enchantability factor of " + name + " items.").defineInRange(toolKey + "Enchantability", materialDefaults.getCommonEnchantability(), 0, Integer.MAX_VALUE));
        this.toughness = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Base armor toughness value of " + name + " armor.").defineInRange(toolKey + "Toughness", (double)materialDefaults.func_200901_e(), 0.0, 3.4028234663852886E38));
        this.knockbackResistance = CachedFloatValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Base armor knockback resistance value of " + name + " armor.").defineInRange(toolKey + "KnockbackResistance", (double)materialDefaults.func_230304_f_(), 0.0, 3.4028234663852886E38));
        this.bootDurability = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " boots.").defineInRange(toolKey + "BootDurability", materialDefaults.func_200896_a(EquipmentSlotType.FEET), 1, Integer.MAX_VALUE));
        this.leggingDurability = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " leggings.").defineInRange(toolKey + "LeggingDurability", materialDefaults.func_200896_a(EquipmentSlotType.LEGS), 1, Integer.MAX_VALUE));
        this.chestplateDurability = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " chestplates.").defineInRange(toolKey + "ChestplateDurability", materialDefaults.func_200896_a(EquipmentSlotType.CHEST), 1, Integer.MAX_VALUE));
        this.helmetDurability = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Maximum durability of " + name + " helmets.").defineInRange(toolKey + "HelmetDurability", materialDefaults.func_200896_a(EquipmentSlotType.HEAD), 1, Integer.MAX_VALUE));
        this.bootArmor = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Protection value of " + name + " boots.").defineInRange(toolKey + "BootArmor", materialDefaults.func_200902_b(EquipmentSlotType.FEET), 0, Integer.MAX_VALUE));
        this.leggingArmor = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Protection value of " + name + " leggings.").defineInRange(toolKey + "LeggingArmor", materialDefaults.func_200902_b(EquipmentSlotType.LEGS), 0, Integer.MAX_VALUE));
        this.chestplateArmor = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Protection value of " + name + " chestplates.").defineInRange(toolKey + "ChestplateArmor", materialDefaults.func_200902_b(EquipmentSlotType.CHEST), 0, Integer.MAX_VALUE));
        this.helmetArmor = CachedIntValue.wrap((IMekanismConfig)config, (ForgeConfigSpec.ConfigValue)builder.comment("Protection value of " + name + " helmets.").defineInRange(toolKey + "HelmetArmor", materialDefaults.func_200902_b(EquipmentSlotType.HEAD), 0, Integer.MAX_VALUE));
        builder.pop();
    }

    @Override
    public int getShieldDurability() {
        return this.shieldDurability.get();
    }

    @Override
    public float getSwordDamage() {
        return this.swordDamage.get();
    }

    @Override
    public float getSwordAtkSpeed() {
        return this.swordAtkSpeed.get();
    }

    @Override
    public float getShovelDamage() {
        return this.shovelDamage.get();
    }

    @Override
    public float getShovelAtkSpeed() {
        return this.shovelAtkSpeed.get();
    }

    @Override
    public float getAxeDamage() {
        return this.axeDamage.get();
    }

    @Override
    public float getAxeAtkSpeed() {
        return this.axeAtkSpeed.get();
    }

    @Override
    public float getPickaxeDamage() {
        return this.pickaxeDamage.get();
    }

    @Override
    public float getPickaxeAtkSpeed() {
        return this.pickaxeAtkSpeed.get();
    }

    @Override
    public float getHoeDamage() {
        return this.hoeDamage.get();
    }

    @Override
    public float getHoeAtkSpeed() {
        return this.hoeAtkSpeed.get();
    }

    @Override
    public int getPaxelHarvestLevel() {
        return this.paxelHarvestLevel.get();
    }

    @Override
    public int getPaxelMaxUses() {
        return this.paxelMaxUses.get();
    }

    @Override
    public float getPaxelEfficiency() {
        return this.paxelEfficiency.get();
    }

    @Override
    public float getPaxelDamage() {
        return this.paxelDamage.get();
    }

    @Override
    public float getPaxelAtkSpeed() {
        return this.paxelAtkSpeed.get();
    }

    public int func_200926_a() {
        return this.toolMaxUses.get();
    }

    public float func_200928_b() {
        return this.efficiency.get();
    }

    public float func_200929_c() {
        return this.attackDamage.get();
    }

    public int func_200925_d() {
        return this.harvestLevel.get();
    }

    public int func_200896_a(EquipmentSlotType slotType) {
        switch (slotType) {
            case FEET: {
                return this.bootDurability.get();
            }
            case LEGS: {
                return this.leggingDurability.get();
            }
            case CHEST: {
                return this.chestplateDurability.get();
            }
            case HEAD: {
                return this.helmetDurability.get();
            }
        }
        return this.fallBack.func_200896_a(slotType);
    }

    public int func_200902_b(EquipmentSlotType slotType) {
        switch (slotType) {
            case FEET: {
                return this.bootArmor.get();
            }
            case LEGS: {
                return this.leggingArmor.get();
            }
            case CHEST: {
                return this.chestplateArmor.get();
            }
            case HEAD: {
                return this.helmetArmor.get();
            }
        }
        return this.fallBack.func_200902_b(slotType);
    }

    @Override
    public int getCommonEnchantability() {
        return this.enchantability.get();
    }

    @Override
    public boolean burnsInFire() {
        return this.fallBack.burnsInFire();
    }

    public float func_200901_e() {
        return this.toughness.get();
    }

    @Nonnull
    public SoundEvent func_200899_b() {
        return this.fallBack.func_200899_b();
    }

    @Override
    @Nonnull
    public Ingredient getCommonRepairMaterial() {
        return this.fallBack.getCommonRepairMaterial();
    }

    @Override
    public String getConfigCommentName() {
        return this.fallBack.getConfigCommentName();
    }

    @Override
    @Nonnull
    public String func_200897_d() {
        return this.fallBack.func_200897_d();
    }

    @Override
    @Nonnull
    public String getRegistryPrefix() {
        return this.fallBack.getRegistryPrefix();
    }

    @Override
    public int getPaxelEnchantability() {
        return this.paxelEnchantability.get();
    }

    public float func_230304_f_() {
        return this.knockbackResistance.get();
    }
}

