/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.util.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.placebo.util.json.NBTAdapter;

public class ItemAdapter
implements JsonDeserializer<ItemStack>,
JsonSerializer<ItemStack> {
    public static final ItemAdapter INSTANCE = new ItemAdapter();
    public static final Gson ITEM_READER = new GsonBuilder().registerTypeAdapter(ItemStack.class, (Object)INSTANCE).registerTypeAdapter(CompoundNBT.class, (Object)NBTAdapter.INSTANCE).create();

    public ItemStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
        JsonObject obj = json.getAsJsonObject();
        ResourceLocation id = new ResourceLocation(obj.get("item").getAsString());
        Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
        if (item == Items.field_190931_a && !id.equals((Object)Items.field_190931_a.getRegistryName())) {
            throw new JsonParseException("Failed to read item " + id);
        }
        int count = obj.has("count") ? obj.get("count").getAsInt() : 1;
        CompoundNBT tag = obj.has("nbt") ? (CompoundNBT)ctx.deserialize(obj.get("nbt"), CompoundNBT.class) : null;
        CompoundNBT capTag = obj.has("cap_nbt") ? (CompoundNBT)ctx.deserialize(obj.get("cap_nbt"), CompoundNBT.class) : null;
        ItemStack stack = new ItemStack((IItemProvider)item, count, capTag);
        stack.func_77982_d(tag);
        return stack;
    }

    public JsonElement serialize(ItemStack stack, Type typeOfSrc, JsonSerializationContext ctx) {
        CompoundNBT written = stack.func_77955_b(new CompoundNBT());
        JsonObject obj = new JsonObject();
        obj.add("item", ctx.serialize((Object)stack.func_77973_b().getRegistryName().toString()));
        obj.add("count", ctx.serialize((Object)stack.func_190916_E()));
        if (stack.func_77942_o()) {
            obj.add("nbt", ctx.serialize((Object)stack.func_77978_p()));
        }
        if (written.func_74764_b("ForgeCaps")) {
            obj.add("cap_nbt", ctx.serialize((Object)written.func_74775_l("ForgeCaps")));
        }
        return obj;
    }
}

