/*
 * Decompiled with CFR 0.152.
 */
package ru.DmN.AE2AO;

import java.util.function.Predicate;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import ru.DmN.AE2AO.AE2AOMain;

public class Config {
    public static final ForgeConfigSpec Instance_Spec;
    public static final Config Instance;
    public final ForgeConfigSpec.BooleanValue DisableChannels;
    public final ForgeConfigSpec.BooleanValue ControllerLimits;
    public final ForgeConfigSpec.BooleanValue ControllerCross;
    public final ForgeConfigSpec.BooleanValue MultipleControllers;
    public final MaxBoxSize ControllerSizeLimits;
    public final ForgeConfigSpec.BooleanValue CellFireResistance;
    public final ForgeConfigSpec.BooleanValue CellExplosionResistance;
    public final ForgeConfigSpec.BooleanValue PortableCellFireResistance;
    public final ForgeConfigSpec.BooleanValue PortableCellExplosionResistance;
    public final ForgeConfigSpec.ConfigValue<Integer> ItemsPerByte;
    public final ForgeConfigSpec.ConfigValue<Integer> MbPerByte;

    Config(ForgeConfigSpec.Builder builder) {
        this.DisableChannels = builder.comment("Disable all channels logic. If true amount of used channels is always 0.").define("DisableChannels", false);
        builder.push("Cells");
        this.CellFireResistance = builder.define("CellFireResistance", false);
        this.CellExplosionResistance = builder.define("CellExplosionResistance", false);
        this.PortableCellFireResistance = builder.define("PortableCellFireResistance", false);
        this.PortableCellExplosionResistance = builder.define("PortableCellExplosionResistance", false);
        this.ItemsPerByte = builder.define("ItemsPerByte", (Object)8, new MoreOrEqual(Integer.class, Integer.valueOf(1), null));
        this.MbPerByte = builder.define("MbPerByte", (Object)8000, new MoreOrEqual(Integer.class, Integer.valueOf(1), null));
        builder.pop();
        builder.push("Controllers");
        this.ControllerLimits = builder.comment("Control all controller limits. If is false, any variant of controller structure is correct.").define("ControllerLimits", true);
        this.ControllerCross = builder.comment("If is false, possible structure with cross pattern, i.e. two neighbors on two or three axes.").define("ControllerCross", false);
        this.MultipleControllers = builder.comment("If is true, possible connect to one me net multiple controller structure.").define("MultipleControllers", false);
        this.ControllerSizeLimits = new MaxBoxSize(builder, "ControllerSizeLimits");
        builder.pop();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Config::new);
        Instance = (Config)specPair.getLeft();
        Instance_Spec = (ForgeConfigSpec)specPair.getRight();
    }

    public static class MaxBoxSize {
        public final ForgeConfigSpec.ConfigValue<Integer> Max_X;
        public final ForgeConfigSpec.ConfigValue<Integer> Max_Y;
        public final ForgeConfigSpec.ConfigValue<Integer> Max_Z;

        MaxBoxSize(ForgeConfigSpec.Builder builder, String name) {
            builder.push(name);
            this.Max_X = builder.define("Max_X", (Object)7, new MoreOrEqual(Integer.class, Integer.valueOf(1), null));
            this.Max_Y = builder.define("Max_Y", (Object)7, new MoreOrEqual(Integer.class, Integer.valueOf(1), null));
            this.Max_Z = builder.define("Max_Z", (Object)7, new MoreOrEqual(Integer.class, Integer.valueOf(1), null));
            builder.pop();
        }
    }

    private static class MoreOrEqual<V extends Comparable<? super V>>
    implements Predicate<Object> {
        private final Class<? extends V> clazz;
        private final V min;

        private MoreOrEqual(Class<V> clazz, V min) {
            this.clazz = clazz;
            this.min = min;
        }

        @Override
        public boolean test(Object t) {
            boolean result;
            if (!this.clazz.isInstance(t)) {
                return false;
            }
            Comparable c = (Comparable)this.clazz.cast(t);
            boolean bl = result = c.compareTo(this.min) >= 0;
            if (!result) {
                AE2AOMain.LOGGER.debug("Value {} is less than minimal = {}", (Object)c, this.min);
            }
            return result;
        }

        public String toString() {
            return ">= " + this.min;
        }

        /* synthetic */ MoreOrEqual(Class x0, Comparable x1, 1 x2) {
            this(x0, x1);
        }
    }
}

