/*
 * Decompiled with CFR 0.152.
 */
package ru.DmN.AE2AO;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridVisitor;
import appeng.api.networking.pathing.ControllerState;
import appeng.api.util.AEPartLocation;
import appeng.tile.networking.ControllerTileEntity;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.util.math.BlockPos;
import ru.DmN.AE2AO.AE2AOMain;

public class MegaControllerValidator
implements IGridVisitor {
    private boolean valid = true;
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;
    private final HashSet<ControllerTileEntity> block_set;

    public MegaControllerValidator(BlockPos pos, HashSet<ControllerTileEntity> block_set) {
        this.minX = pos.func_177958_n();
        this.maxX = pos.func_177958_n();
        this.minY = pos.func_177956_o();
        this.maxY = pos.func_177956_o();
        this.minZ = pos.func_177952_p();
        this.maxZ = pos.func_177952_p();
        this.block_set = block_set;
    }

    public boolean visitNode(IGridNode n) {
        IGridHost host = n.getMachine();
        if (this.isValid() && host instanceof ControllerTileEntity) {
            ControllerTileEntity c = (ControllerTileEntity)host;
            BlockPos pos = c.func_174877_v();
            this.minX = Math.min(pos.func_177958_n(), this.minX);
            this.maxX = Math.max(pos.func_177958_n(), this.maxX);
            this.minY = Math.min(pos.func_177956_o(), this.minY);
            this.maxY = Math.max(pos.func_177956_o(), this.maxY);
            this.minZ = Math.min(pos.func_177952_p(), this.minZ);
            this.maxZ = Math.max(pos.func_177952_p(), this.maxZ);
            if (this.maxX - this.minX < (Integer)AE2AOMain.config.ControllerSizeLimits.Max_X.get() && this.maxY - this.minY < (Integer)AE2AOMain.config.ControllerSizeLimits.Max_Y.get() && this.maxZ - this.minZ < (Integer)AE2AOMain.config.ControllerSizeLimits.Max_Z.get()) {
                this.block_set.remove(c);
                return true;
            }
            this.valid = false;
        }
        return false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public static ControllerState calculateState(Collection<ControllerTileEntity> controllers) {
        if (controllers.isEmpty()) {
            return ControllerState.NO_CONTROLLER;
        }
        if (!((Boolean)AE2AOMain.config.ControllerLimits.get()).booleanValue()) {
            return ControllerState.CONTROLLER_ONLINE;
        }
        HashSet<ControllerTileEntity> sad = new HashSet<ControllerTileEntity>(controllers);
        while (!sad.isEmpty()) {
            ControllerTileEntity startingController = sad.iterator().next();
            IGridNode startingNode = startingController.getGridNode(AEPartLocation.INTERNAL);
            if (startingNode == null) {
                return ControllerState.CONTROLLER_CONFLICT;
            }
            sad.remove(startingController);
            MegaControllerValidator cv = new MegaControllerValidator(startingController.func_174877_v(), sad);
            startingNode.beginVisit((IGridVisitor)cv);
            if (!cv.isValid()) {
                return ControllerState.CONTROLLER_CONFLICT;
            }
            if (((Boolean)AE2AOMain.config.MultipleControllers.get()).booleanValue() || sad.isEmpty()) continue;
            return ControllerState.CONTROLLER_CONFLICT;
        }
        return ControllerState.CONTROLLER_ONLINE;
    }
}

