/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.the9grounds.aeadditions.client.gui.widget.IWidget;
import com.the9grounds.aeadditions.client.helpers.Blit;
import com.the9grounds.aeadditions.container.slot.AEASlot;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/B7\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00040\n\u00a2\u0006\u0002\u0010\fJF\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020#J(\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0016J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004H\u0016R\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0018\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000f\u00a8\u00060"}, d2={"Lcom/the9grounds/aeadditions/client/gui/widget/UpgradePanel;", "Lnet/minecraft/client/gui/AbstractGui;", "Lcom/the9grounds/aeadditions/client/gui/widget/IWidget;", "slots", "", "Lnet/minecraft/inventory/container/Slot;", "posX", "", "posY", "tooltipFactory", "Lkotlin/Function0;", "Lnet/minecraft/util/text/ITextComponent;", "(Ljava/util/List;IILkotlin/jvm/functions/Function0;)V", "height", "getHeight", "()I", "getPosX", "getPosY", "getSlots", "()Ljava/util/List;", "getTooltipFactory", "()Lkotlin/jvm/functions/Function0;", "upgradeSlotCount", "getUpgradeSlotCount", "width", "getWidth", "drawSlot", "", "matrices", "Lcom/mojang/blaze3d/matrix/MatrixStack;", "zIndex", "", "x", "y", "borderLeft", "", "borderTop", "borderRight", "borderBottom", "drawWidgetBackground", "matrixStack", "font", "Lnet/minecraft/client/gui/FontRenderer;", "mouseX", "", "mouseY", "getTooltip", "Companion", "AEAdditions-1.16.5"})
public final class UpgradePanel
extends AbstractGui
implements IWidget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Slot> slots;
    private final int posX;
    private final int posY;
    @NotNull
    private final Function0<List<ITextComponent>> tooltipFactory;
    private final int height;
    private final int width;
    public static final int SLOT_SIZE = 18;
    public static final int PADDING = 7;
    public static final int MAX_ROWS = 8;
    @NotNull
    private static final Blit background = new Blit("gui/extra_panels.png", 128, 128);
    @NotNull
    private static final Blit innerCorner = background.copy().src(12, 33, 18, 18);

    public UpgradePanel(@NotNull List<? extends Slot> slots, int posX, int posY, @NotNull Function0<? extends List<? extends ITextComponent>> tooltipFactory) {
        Intrinsics.checkNotNullParameter(slots, (String)"slots");
        Intrinsics.checkNotNullParameter(tooltipFactory, (String)"tooltipFactory");
        this.slots = slots;
        this.posX = posX;
        this.posY = posY;
        this.tooltipFactory = tooltipFactory;
        int slotCount = this.getUpgradeSlotCount();
        int n = 8;
        boolean bl = false;
        this.height = 14 + Math.min(n, slotCount) * 18;
        this.width = 14 + (slotCount + 8 - 1) / 8 * 18;
        int slotOriginX = this.posX + 7;
        int slotOriginY = this.posY + 7;
        for (Slot slot : this.slots) {
            if (!slot.func_111238_b()) continue;
            slot.field_75223_e = slotOriginX + 1;
            slot.field_75221_f = slotOriginY + 1;
            slotOriginY += 18;
        }
    }

    @NotNull
    public final List<Slot> getSlots() {
        return this.slots;
    }

    public final int getPosX() {
        return this.posX;
    }

    public final int getPosY() {
        return this.posY;
    }

    @NotNull
    public final Function0<List<ITextComponent>> getTooltipFactory() {
        return this.tooltipFactory;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getWidth() {
        return this.width;
    }

    @Override
    public void drawWidgetBackground(@NotNull MatrixStack matrixStack, @NotNull FontRenderer font, double mouseX, double mouseY) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        int slotCount = this.getUpgradeSlotCount();
        if (slotCount <= 0) {
            return;
        }
        int slotOriginX = this.posX + 7;
        int slotOriginY = this.posY + 7;
        int n = 0;
        if (n < slotCount) {
            do {
                int i = n++;
                int row = i % 8;
                int col = i / 8;
                int x = slotOriginX + col * 18;
                int y = slotOriginY + row * 18;
                boolean borderLeft = col == 0;
                boolean borderTop = row == 0;
                boolean lastSlot = i + 1 >= slotCount;
                boolean lastRow = row + 1 >= 8;
                boolean borderBottom = lastRow || lastSlot;
                boolean borderRight = i >= slotCount - 8;
                this.drawSlot(matrixStack, 0.0f, x, y, borderLeft, borderTop, borderRight, borderBottom);
                if (col <= 0 || !lastSlot || lastRow) continue;
                innerCorner.dest(x, y + 18).draw(matrixStack, 0.0f);
            } while (n < slotCount);
        }
    }

    public final void drawSlot(@NotNull MatrixStack matrices, float zIndex, int x, int y, boolean borderLeft, boolean borderTop, boolean borderRight, boolean borderBottom) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        int x2 = x;
        int y2 = y;
        int srcX = 7;
        int srcY = 7;
        int srcWidth = 18;
        int srcHeight = 18;
        if (borderLeft) {
            x2 -= 7;
            srcX = 0;
            srcWidth += 7;
        }
        if (borderRight) {
            srcWidth += 7;
        }
        if (borderTop) {
            y2 -= 7;
            srcY = 0;
            srcHeight += 7;
        }
        if (borderBottom) {
            srcHeight += 7;
        }
        background.src(srcX, srcY, srcWidth, srcHeight).dest(x2, y2).draw(matrices, zIndex);
    }

    @Override
    @NotNull
    public List<ITextComponent> getTooltip() {
        if (this.getUpgradeSlotCount() == 0) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        return (List)this.tooltipFactory.invoke();
    }

    public final int getUpgradeSlotCount() {
        int count = 0;
        for (Slot slot : this.slots) {
            if (!(slot instanceof AEASlot) || !((AEASlot)slot).isSlotEnabled()) continue;
            int n = count;
            count = n + 1;
        }
        return count;
    }

    @Override
    public void drawWidgetForeground(@NotNull MatrixStack matrixStack, double mouseX, double mouseY) {
        IWidget.DefaultImpls.drawWidgetForeground(this, matrixStack, mouseX, mouseY);
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return IWidget.DefaultImpls.isMouseOver(this, mouseX, mouseY);
    }

    @Override
    public void mouseClicked(int mouseButton, @NotNull ClickType clickType) {
        IWidget.DefaultImpls.mouseClicked(this, mouseButton, clickType);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lcom/the9grounds/aeadditions/client/gui/widget/UpgradePanel$Companion;", "", "()V", "MAX_ROWS", "", "PADDING", "SLOT_SIZE", "background", "Lcom/the9grounds/aeadditions/client/helpers/Blit;", "getBackground", "()Lcom/the9grounds/aeadditions/client/helpers/Blit;", "innerCorner", "getInnerCorner", "AEAdditions-1.16.5"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Blit getBackground() {
            return background;
        }

        @NotNull
        public final Blit getInnerCorner() {
            return innerCorner;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

