/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.the9grounds.aeadditions.client.gui.AEABaseScreen;
import com.the9grounds.aeadditions.client.gui.widget.IWidget;
import com.the9grounds.aeadditions.client.helpers.Blit;
import com.the9grounds.aeadditions.container.chemical.ChemicalInterfaceContainer;
import com.the9grounds.aeadditions.integration.mekanism.Mekanism;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import mekanism.api.chemical.Chemical;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002BC\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0002\u0010\rJ \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J6\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dR\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011\u00a8\u0006'"}, d2={"Lcom/the9grounds/aeadditions/client/gui/widget/WidgetChemicalTank;", "Lnet/minecraft/client/gui/AbstractGui;", "Lcom/the9grounds/aeadditions/client/gui/widget/IWidget;", "gui", "Lcom/the9grounds/aeadditions/client/gui/AEABaseScreen;", "tank", "Lcom/the9grounds/aeadditions/container/chemical/ChemicalInterfaceContainer$ChemicalTank;", "posX", "", "posY", "height", "width", "slot", "(Lcom/the9grounds/aeadditions/client/gui/AEABaseScreen;Lcom/the9grounds/aeadditions/container/chemical/ChemicalInterfaceContainer$ChemicalTank;IIIII)V", "getGui", "()Lcom/the9grounds/aeadditions/client/gui/AEABaseScreen;", "getHeight", "()I", "getPosX", "getPosY", "getSlot", "getTank", "()Lcom/the9grounds/aeadditions/container/chemical/ChemicalInterfaceContainer$ChemicalTank;", "getWidth", "drawWidgetForeground", "", "matrixStack", "Lcom/mojang/blaze3d/matrix/MatrixStack;", "mouseX", "", "mouseY", "getTooltip", "", "Lnet/minecraft/util/text/ITextComponent;", "isMouseOver", "", "isPointInRegion", "x", "y", "AEAdditions-1.16.5"})
public final class WidgetChemicalTank
extends AbstractGui
implements IWidget {
    @NotNull
    private final AEABaseScreen<?> gui;
    @Nullable
    private final ChemicalInterfaceContainer.ChemicalTank tank;
    private final int posX;
    private final int posY;
    private final int height;
    private final int width;
    private final int slot;

    public WidgetChemicalTank(@NotNull AEABaseScreen<?> gui, @Nullable ChemicalInterfaceContainer.ChemicalTank tank, int posX, int posY, int height, int width, int slot) {
        Intrinsics.checkNotNullParameter(gui, (String)"gui");
        this.gui = gui;
        this.tank = tank;
        this.posX = posX;
        this.posY = posY;
        this.height = height;
        this.width = width;
        this.slot = slot;
    }

    @NotNull
    public final AEABaseScreen<?> getGui() {
        return this.gui;
    }

    @Nullable
    public final ChemicalInterfaceContainer.ChemicalTank getTank() {
        return this.tank;
    }

    public final int getPosX() {
        return this.posX;
    }

    public final int getPosY() {
        return this.posY;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getSlot() {
        return this.slot;
    }

    @Override
    @NotNull
    public List<ITextComponent> getTooltip() {
        if (this.tank == null || this.tank.getChemical() == null) {
            return CollectionsKt.listOf((Object)new StringTextComponent(Intrinsics.stringPlus((String)"Side: ", (Object)Direction.func_82600_a((int)this.slot).name())));
        }
        Object[] objectArray = new ITextComponent[3];
        Chemical<?> chemical = this.tank.getChemical();
        Intrinsics.checkNotNull(chemical);
        objectArray[0] = chemical.getTextComponent();
        objectArray[1] = (ITextComponent)new StringTextComponent(this.tank.getAmount() + "mB");
        objectArray[2] = (ITextComponent)new StringTextComponent(Intrinsics.stringPlus((String)"Side: ", (Object)Direction.func_82600_a((int)this.slot).name()));
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.isPointInRegion(this.posX, this.posY, this.height, this.width, mouseX, mouseY);
    }

    public final boolean isPointInRegion(int x, int y, int height, int width, double mouseX, double mouseY) {
        int i = this.gui.getGuiLeft();
        int j = this.gui.getGuiTop();
        double newMouseX = mouseX - (double)i;
        double newMouseY = mouseY - (double)j;
        return newMouseX >= (double)(x - 1) && newMouseX < (double)(x + width + 1) && newMouseY >= (double)(y - 1) && newMouseY < (double)(y + height + 1);
    }

    @Override
    public void drawWidgetForeground(@NotNull MatrixStack matrixStack, double mouseX, double mouseY) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        if (this.tank != null && this.tank.getChemical() != null) {
            int n;
            int n2;
            Chemical<?> chemical = this.tank.getChemical();
            Intrinsics.checkNotNull(chemical);
            TextureAtlasSprite sprite = Mekanism.INSTANCE.getChemicalTexture(chemical);
            Chemical<?> chemical2 = this.tank.getChemical();
            Intrinsics.checkNotNull(chemical2);
            int tint = chemical2.getTint();
            int scaledHeight = (int)((float)this.height * ((float)this.tank.getAmount() / (float)this.tank.getCapacity()));
            int iconHeightRemainder = scaledHeight % 16;
            if (iconHeightRemainder > 0) {
                Intrinsics.checkNotNull((Object)sprite);
                Blit.colorRgb$default(new Blit(sprite), tint, false, 2, null).dest(this.posX, this.posY + this.height - iconHeightRemainder, 16, iconHeightRemainder).draw(matrixStack, 0.0f);
            }
            if ((n2 = 0) < (n = scaledHeight / 16)) {
                do {
                    int i = n2++;
                    Intrinsics.checkNotNull((Object)sprite);
                    Blit.colorRgb$default(new Blit(sprite), tint, false, 2, null).dest(this.posX, this.posY + this.height - iconHeightRemainder - (i + 1) * 16, 16, 16).draw(matrixStack, 0.0f);
                } while (n2 < n);
            }
        }
    }

    @Override
    public void drawWidgetBackground(@NotNull MatrixStack matrixStack, @NotNull FontRenderer font, double mouseX, double mouseY) {
        IWidget.DefaultImpls.drawWidgetBackground(this, matrixStack, font, mouseX, mouseY);
    }

    @Override
    public void mouseClicked(int mouseButton, @NotNull ClickType clickType) {
        IWidget.DefaultImpls.mouseClicked(this, mouseButton, clickType);
    }
}

