/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.client.helpers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.the9grounds.aeadditions.util.Colors;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 B2\u00020\u0001:\u0001BB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\u001f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000f\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0011J\u001e\u00103\u001a\u00020\u00002\u0006\u0010)\u001a\u0002042\u0006\u0010&\u001a\u0002042\u0006\u0010\u0017\u001a\u000204J&\u00103\u001a\u00020\u00002\u0006\u0010)\u001a\u0002042\u0006\u0010&\u001a\u0002042\u0006\u0010\u0017\u001a\u0002042\u0006\u0010\u0012\u001a\u000204J\u0018\u00105\u001a\u00020\u00002\u0006\u00103\u001a\u00020\f2\b\b\u0002\u00106\u001a\u00020\u001bJ\u0006\u00107\u001a\u00020\u0000J\u0016\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020\f2\u0006\u0010:\u001a\u00020\fJ&\u00108\u001a\u00020\u00002\u0006\u00109\u001a\u00020\f2\u0006\u0010:\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0016\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u000204J\u000e\u0010@\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u000204J&\u0010A\u001a\u00020\u00002\u0006\u00109\u001a\u00020\f2\u0006\u0010:\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fR\u001a\u0010\u0012\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0014\"\u0004\b(\u0010\u0016R\u001a\u0010)\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0014\"\u0004\b+\u0010\u0016R\u0011\u0010\u0010\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0014R\u0011\u0010\u000f\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0014R\u001c\u0010.\u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010#\"\u0004\b0\u0010%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102\u00a8\u0006C"}, d2={"Lcom/the9grounds/aeadditions/client/helpers/Blit;", "", "texture", "Lnet/minecraft/util/ResourceLocation;", "(Lnet/minecraft/util/ResourceLocation;)V", "sprite", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "(Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;)V", "resource", "", "(Ljava/lang/String;)V", "width", "", "height", "(Ljava/lang/String;II)V", "referenceWidth", "referenceHeight", "(Lnet/minecraft/util/ResourceLocation;II)V", "a", "getA", "()I", "setA", "(I)V", "b", "getB", "setB", "blending", "", "getBlending", "()Z", "setBlending", "(Z)V", "destRect", "Lnet/minecraft/client/renderer/Rectangle2d;", "getDestRect", "()Lnet/minecraft/client/renderer/Rectangle2d;", "setDestRect", "(Lnet/minecraft/client/renderer/Rectangle2d;)V", "g", "getG", "setG", "r", "getR", "setR", "getReferenceHeight", "getReferenceWidth", "srcRect", "getSrcRect", "setSrcRect", "getTexture", "()Lnet/minecraft/util/ResourceLocation;", "color", "", "colorRgb", "withAlpha", "copy", "dest", "x", "y", "draw", "", "matrixStack", "Lcom/mojang/blaze3d/matrix/MatrixStack;", "zIndex", "opacity", "src", "Companion", "AEAdditions-1.16.5"})
public final class Blit {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation texture;
    private final int referenceWidth;
    private final int referenceHeight;
    private int r;
    private int g;
    private int b;
    private int a;
    @Nullable
    private Rectangle2d srcRect;
    @NotNull
    private Rectangle2d destRect;
    private boolean blending;
    public static final int DEFAULT_WIDTH = 256;
    public static final int DEFAULT_HEIGHT = 256;

    public Blit(@NotNull ResourceLocation texture, int referenceWidth, int referenceHeight) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        this.texture = texture;
        this.referenceWidth = referenceWidth;
        this.referenceHeight = referenceHeight;
        this.r = 255;
        this.g = 255;
        this.b = 255;
        this.a = 255;
        this.destRect = new Rectangle2d(0, 0, 0, 0);
        this.blending = true;
    }

    @NotNull
    public final ResourceLocation getTexture() {
        return this.texture;
    }

    public final int getReferenceWidth() {
        return this.referenceWidth;
    }

    public final int getReferenceHeight() {
        return this.referenceHeight;
    }

    public final int getR() {
        return this.r;
    }

    public final void setR(int n) {
        this.r = n;
    }

    public final int getG() {
        return this.g;
    }

    public final void setG(int n) {
        this.g = n;
    }

    public final int getB() {
        return this.b;
    }

    public final void setB(int n) {
        this.b = n;
    }

    public final int getA() {
        return this.a;
    }

    public final void setA(int n) {
        this.a = n;
    }

    @Nullable
    public final Rectangle2d getSrcRect() {
        return this.srcRect;
    }

    public final void setSrcRect(@Nullable Rectangle2d rectangle2d) {
        this.srcRect = rectangle2d;
    }

    @NotNull
    public final Rectangle2d getDestRect() {
        return this.destRect;
    }

    public final void setDestRect(@NotNull Rectangle2d rectangle2d) {
        Intrinsics.checkNotNullParameter((Object)rectangle2d, (String)"<set-?>");
        this.destRect = rectangle2d;
    }

    public final boolean getBlending() {
        return this.blending;
    }

    public final void setBlending(boolean bl) {
        this.blending = bl;
    }

    public Blit(@NotNull ResourceLocation texture) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"texture");
        this(texture, 256, 256);
    }

    public Blit(@NotNull TextureAtlasSprite sprite) {
        Intrinsics.checkNotNullParameter((Object)sprite, (String)"sprite");
        ResourceLocation resourceLocation = sprite.func_229241_m_().func_229223_g_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"sprite.atlasTexture.textureLocation");
        this(resourceLocation, 256, 256);
        this.src((int)(sprite.func_94209_e() * (float)256), (int)(sprite.func_94206_g() * (float)256), (int)((sprite.func_94212_f() - sprite.func_94209_e()) * (float)256), (int)((sprite.func_94210_h() - sprite.func_94206_g()) * (float)256));
    }

    public Blit(@NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this(new ResourceLocation("aeadditions", Intrinsics.stringPlus((String)"textures/", (Object)resource)), 256, 256);
    }

    public Blit(@NotNull String resource, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this(new ResourceLocation("aeadditions", Intrinsics.stringPlus((String)"textures/", (Object)resource)), width, height);
    }

    @NotNull
    public final Blit src(int x, int y, int width, int height) {
        this.srcRect = new Rectangle2d(x, y, width, height);
        return this;
    }

    @NotNull
    public final Blit dest(int x, int y, int width, int height) {
        this.destRect = new Rectangle2d(x, y, width, height);
        return this;
    }

    @NotNull
    public final Blit dest(int x, int y) {
        return this.dest(x, y, 0, 0);
    }

    @NotNull
    public final Blit color(float r, float g, float b) {
        Blit blit = this;
        boolean bl = false;
        boolean bl2 = false;
        Blit $this$color_u24lambda_u2d0 = blit;
        boolean bl3 = false;
        $this$color_u24lambda_u2d0.setR((int)(RangesKt.coerceIn((float)r, (float)0.0f, (float)1.0f) * (float)255));
        $this$color_u24lambda_u2d0.setG((int)(RangesKt.coerceIn((float)g, (float)0.0f, (float)1.0f) * (float)255));
        $this$color_u24lambda_u2d0.setB((int)(RangesKt.coerceIn((float)b, (float)0.0f, (float)1.0f) * (float)255));
        return blit;
    }

    @NotNull
    public final Blit opacity(float a) {
        Blit blit = this;
        boolean bl = false;
        boolean bl2 = false;
        Blit $this$opacity_u24lambda_u2d1 = blit;
        boolean bl3 = false;
        $this$opacity_u24lambda_u2d1.setA((int)(RangesKt.coerceIn((float)a, (float)0.0f, (float)1.0f) * (float)255));
        return blit;
    }

    @NotNull
    public final Blit color(float r, float g, float b, float a) {
        return this.color(r, g, b).opacity(a);
    }

    @NotNull
    public final Blit colorRgb(int color, boolean withAlpha) {
        float r = Colors.INSTANCE.getRed(color);
        float g = Colors.INSTANCE.getGreen(color);
        float b = Colors.INSTANCE.getBlue(color);
        this.color(r, g, b);
        if (withAlpha) {
            float a = Colors.INSTANCE.getAlpha(color);
            this.opacity(a);
        }
        return this;
    }

    public static /* synthetic */ Blit colorRgb$default(Blit blit, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        return blit.colorRgb(n, bl);
    }

    @NotNull
    public final Blit copy() {
        Blit copy = new Blit(this.texture, this.referenceWidth, this.referenceHeight);
        Blit self = this;
        Blit blit = copy;
        boolean bl = false;
        boolean bl2 = false;
        Blit $this$copy_u24lambda_u2d2 = blit;
        boolean bl3 = false;
        $this$copy_u24lambda_u2d2.setSrcRect(self.getSrcRect());
        $this$copy_u24lambda_u2d2.setDestRect(self.getDestRect());
        $this$copy_u24lambda_u2d2.setBlending(self.getBlending());
        $this$copy_u24lambda_u2d2.setR(self.getR());
        $this$copy_u24lambda_u2d2.setG(self.getG());
        $this$copy_u24lambda_u2d2.setB(self.getB());
        $this$copy_u24lambda_u2d2.setA(self.getA());
        return blit;
    }

    public final void draw(@NotNull MatrixStack matrixStack, float zIndex) {
        Intrinsics.checkNotNullParameter((Object)matrixStack, (String)"matrixStack");
        Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
        float minU = 0.0f;
        float minV = 0.0f;
        float maxU = 0.0f;
        float maxV = 0.0f;
        if (this.srcRect == null) {
            minU = 0.0f;
            minV = 0.0f;
            maxU = 1.0f;
            maxV = 1.0f;
        } else {
            Rectangle2d rectangle2d = this.srcRect;
            Intrinsics.checkNotNull((Object)rectangle2d);
            minU = (float)rectangle2d.func_199318_a() / (float)this.referenceWidth;
            rectangle2d = this.srcRect;
            Intrinsics.checkNotNull((Object)rectangle2d);
            minV = (float)rectangle2d.func_199319_b() / (float)this.referenceHeight;
            rectangle2d = this.srcRect;
            Intrinsics.checkNotNull((Object)rectangle2d);
            int n = rectangle2d.func_199318_a();
            rectangle2d = this.srcRect;
            Intrinsics.checkNotNull((Object)rectangle2d);
            maxU = (float)(n + rectangle2d.func_199316_c()) / (float)this.referenceWidth;
            rectangle2d = this.srcRect;
            Intrinsics.checkNotNull((Object)rectangle2d);
            int n2 = rectangle2d.func_199319_b();
            rectangle2d = this.srcRect;
            Intrinsics.checkNotNull((Object)rectangle2d);
            maxV = (float)(n2 + rectangle2d.func_199317_d()) / (float)this.referenceHeight;
        }
        float x1 = this.destRect.func_199318_a();
        float y1 = this.destRect.func_199319_b();
        float x2 = x1;
        float y2 = y1;
        if (this.destRect.func_199316_c() != 0 && this.destRect.func_199317_d() != 0) {
            x2 += (float)this.destRect.func_199316_c();
            y2 += (float)this.destRect.func_199317_d();
        } else if (this.srcRect != null) {
            Rectangle2d rectangle2d = this.srcRect;
            Intrinsics.checkNotNull((Object)rectangle2d);
            x2 += (float)rectangle2d.func_199316_c();
            rectangle2d = this.srcRect;
            Intrinsics.checkNotNull((Object)rectangle2d);
            y2 += (float)rectangle2d.func_199317_d();
        }
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        bufferBuilder.func_227888_a_(matrix, x1, y2, zIndex).func_225586_a_(this.r, this.g, this.b, this.a).func_225583_a_(minU, maxV).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, x2, y2, zIndex).func_225586_a_(this.r, this.g, this.b, this.a).func_225583_a_(maxU, maxV).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, x2, y1, zIndex).func_225586_a_(this.r, this.g, this.b, this.a).func_225583_a_(maxU, minV).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, x1, y1, zIndex).func_225586_a_(this.r, this.g, this.b, this.a).func_225583_a_(minU, minV).func_181675_d();
        bufferBuilder.func_178977_d();
        if (this.blending) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
        } else {
            RenderSystem.disableBlend();
        }
        RenderSystem.enableTexture();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/the9grounds/aeadditions/client/helpers/Blit$Companion;", "", "()V", "DEFAULT_HEIGHT", "", "DEFAULT_WIDTH", "AEAdditions-1.16.5"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

