/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.container;

import appeng.api.parts.IPartHost;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import com.the9grounds.aeadditions.parts.AEABasePart;
import io.netty.handler.codec.DecoderException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0002 !B3\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fB5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0014\u001a\u00020\tJ\u0006\u0010\u0015\u001a\u00020\u000bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u0017J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lcom/the9grounds/aeadditions/container/Locator;", "", "type", "Lcom/the9grounds/aeadditions/container/Locator$Type;", "itemIndex", "", "world", "Lnet/minecraft/world/World;", "blockPos", "Lnet/minecraft/util/math/BlockPos;", "side", "Lappeng/api/util/AEPartLocation;", "(Lcom/the9grounds/aeadditions/container/Locator$Type;ILnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lappeng/api/util/AEPartLocation;)V", "worldId", "Lnet/minecraft/util/ResourceLocation;", "(Lcom/the9grounds/aeadditions/container/Locator$Type;ILnet/minecraft/util/ResourceLocation;Lnet/minecraft/util/math/BlockPos;Lappeng/api/util/AEPartLocation;)V", "getItemIndex", "()I", "getWorldId", "()Lnet/minecraft/util/ResourceLocation;", "getBlockPos", "getSide", "hasBlockPos", "", "hasItemIndex", "hasSide", "toString", "", "write", "", "packetBuffer", "Lnet/minecraft/network/PacketBuffer;", "Companion", "Type", "AEAdditions-1.16.5"})
public final class Locator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Type type;
    private final int itemIndex;
    @Nullable
    private final ResourceLocation worldId;
    @Nullable
    private final BlockPos blockPos;
    @Nullable
    private final AEPartLocation side;

    private Locator(Type type, int itemIndex, ResourceLocation worldId, BlockPos blockPos, AEPartLocation side) {
        this.type = type;
        this.itemIndex = itemIndex;
        this.worldId = worldId;
        this.blockPos = blockPos;
        this.side = side;
    }

    public final int getItemIndex() {
        return this.itemIndex;
    }

    @Nullable
    public final ResourceLocation getWorldId() {
        return this.worldId;
    }

    private Locator(Type type, int itemIndex, World world, BlockPos blockPos, AEPartLocation side) {
        this(type, itemIndex, world.func_234923_W_().func_240901_a_(), blockPos, side);
    }

    public final boolean hasBlockPos() {
        boolean bl;
        Type type = this.type;
        int n = WhenMappings.$EnumSwitchMapping$0[type.ordinal()];
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public final boolean hasSide() {
        boolean bl;
        Type type = this.type;
        int n = WhenMappings.$EnumSwitchMapping$0[type.ordinal()];
        switch (n) {
            case 2: 
            case 3: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public final boolean hasItemIndex() {
        boolean bl;
        Type type = this.type;
        int n = WhenMappings.$EnumSwitchMapping$0[type.ordinal()];
        switch (n) {
            case 3: 
            case 4: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final AEPartLocation getSide() {
        boolean bl = this.hasSide();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        AEPartLocation aEPartLocation = this.side;
        Intrinsics.checkNotNull((Object)aEPartLocation);
        return aEPartLocation;
    }

    @NotNull
    public final BlockPos getBlockPos() {
        boolean bl = this.hasBlockPos();
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        BlockPos blockPos = this.blockPos;
        Intrinsics.checkNotNull((Object)blockPos);
        return blockPos;
    }

    public final void write(@NotNull PacketBuffer packetBuffer) {
        Intrinsics.checkNotNullParameter((Object)packetBuffer, (String)"packetBuffer");
        Type type = this.type;
        int n = WhenMappings.$EnumSwitchMapping$0[type.ordinal()];
        switch (n) {
            case 4: {
                packetBuffer.writeByte(0);
                packetBuffer.writeInt(this.itemIndex);
                break;
            }
            case 3: {
                packetBuffer.writeByte(1);
                packetBuffer.writeInt(this.itemIndex);
                ResourceLocation resourceLocation = this.worldId;
                Intrinsics.checkNotNull((Object)resourceLocation);
                packetBuffer.func_192572_a(resourceLocation);
                resourceLocation = this.blockPos;
                Intrinsics.checkNotNull((Object)resourceLocation);
                packetBuffer.func_179255_a((BlockPos)resourceLocation);
                resourceLocation = this.side;
                Intrinsics.checkNotNull((Object)resourceLocation);
                packetBuffer.writeByte(resourceLocation.ordinal());
                break;
            }
            case 1: {
                packetBuffer.writeByte(2);
                ResourceLocation resourceLocation = this.worldId;
                Intrinsics.checkNotNull((Object)resourceLocation);
                packetBuffer.func_192572_a(resourceLocation);
                resourceLocation = this.blockPos;
                Intrinsics.checkNotNull((Object)resourceLocation);
                packetBuffer.func_179255_a((BlockPos)resourceLocation);
                break;
            }
            case 2: {
                packetBuffer.writeByte(3);
                ResourceLocation resourceLocation = this.worldId;
                Intrinsics.checkNotNull((Object)resourceLocation);
                packetBuffer.func_192572_a(resourceLocation);
                resourceLocation = this.blockPos;
                Intrinsics.checkNotNull((Object)resourceLocation);
                packetBuffer.func_179255_a((BlockPos)resourceLocation);
                resourceLocation = this.side;
                Intrinsics.checkNotNull((Object)resourceLocation);
                packetBuffer.writeByte(resourceLocation.ordinal());
                break;
            }
            default: {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Invalid Locator type ", (Object)((Object)this.type)));
            }
        }
    }

    @NotNull
    public String toString() {
        StringBuilder result = new StringBuilder(this.type.name());
        result.append("{");
        if (this.hasItemIndex()) {
            result.append("slot=").append(this.itemIndex).append(',');
        }
        if (this.hasBlockPos()) {
            result.append("dim=").append(this.worldId).append(',');
            result.append("pos=").append(this.blockPos).append(',');
        }
        if (this.hasSide()) {
            result.append("side=").append(this.side).append(',');
        }
        if (result.charAt(result.length() - 1) == ',') {
            result.setLength(result.length() - 1);
        }
        result.append('}');
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    public /* synthetic */ Locator(Type type, int itemIndex, World world, BlockPos blockPos, AEPartLocation side, DefaultConstructorMarker $constructor_marker) {
        this(type, itemIndex, world, blockPos, side);
    }

    public /* synthetic */ Locator(Type type, int itemIndex, ResourceLocation worldId, BlockPos blockPos, AEPartLocation side, DefaultConstructorMarker $constructor_marker) {
        this(type, itemIndex, worldId, blockPos, side);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/the9grounds/aeadditions/container/Locator$Type;", "", "(Ljava/lang/String;I)V", "PLAYER_INVENTORY", "PLAYER_INVENTORY_WITH_BLOCK_CONTEXT", "BLOCK", "PART", "AEAdditions-1.16.5"})
    private static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type PLAYER_INVENTORY = new Type();
        public static final /* enum */ Type PLAYER_INVENTORY_WITH_BLOCK_CONTEXT = new Type();
        public static final /* enum */ Type BLOCK = new Type();
        public static final /* enum */ Type PART = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            Type[] typeArray = $VALUES;
            return Arrays.copyOf(typeArray, typeArray.length);
        }

        public static Type valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.PLAYER_INVENTORY, Type.PLAYER_INVENTORY_WITH_BLOCK_CONTEXT, Type.BLOCK, Type.PART};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019\u00a8\u0006\u001a"}, d2={"Lcom/the9grounds/aeadditions/container/Locator$Companion;", "", "()V", "forHand", "Lcom/the9grounds/aeadditions/container/Locator;", "playerEntity", "Lnet/minecraft/entity/player/PlayerEntity;", "hand", "Lnet/minecraft/util/Hand;", "forItemUseContext", "context", "Lnet/minecraft/item/ItemUseContext;", "forPart", "part", "Lcom/the9grounds/aeadditions/parts/AEABasePart;", "forTileEntity", "tileEntity", "Lnet/minecraft/tileentity/TileEntity;", "forTileEntitySide", "side", "Lnet/minecraft/util/Direction;", "getPlayerInventorySlotFromHand", "", "read", "packetBuffer", "Lnet/minecraft/network/PacketBuffer;", "AEAdditions-1.16.5"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Locator forTileEntity(@NotNull TileEntity tileEntity) {
            Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
            if (tileEntity.func_145831_w() == null) {
                throw new IllegalArgumentException("Tile Entity does not have world");
            }
            World world = tileEntity.func_145831_w();
            Intrinsics.checkNotNull((Object)world);
            World world2 = world;
            return new Locator(Type.BLOCK, -1, world2, tileEntity.func_174877_v(), null, null);
        }

        @NotNull
        public final Locator forTileEntitySide(@NotNull TileEntity tileEntity, @NotNull Direction side) {
            Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
            Intrinsics.checkNotNullParameter((Object)side, (String)"side");
            if (tileEntity.func_145831_w() == null) {
                throw new IllegalArgumentException("Tile Entity does not have world");
            }
            World world = tileEntity.func_145831_w();
            Intrinsics.checkNotNull((Object)world);
            World world2 = world;
            return new Locator(Type.PART, -1, world2, tileEntity.func_174877_v(), AEPartLocation.fromFacing((Direction)side), null);
        }

        @NotNull
        public final Locator forItemUseContext(@NotNull ItemUseContext context) {
            PlayerEntity playerEntity;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            PlayerEntity playerEntity2 = context.func_195999_j();
            if (playerEntity2 == null) {
                throw new IllegalArgumentException("Cannot open container without player");
            }
            PlayerEntity player = playerEntity = playerEntity2;
            playerEntity2 = context.func_221531_n();
            Intrinsics.checkNotNullExpressionValue((Object)playerEntity2, (String)"context.hand");
            int slot = this.getPlayerInventorySlotFromHand(player, (Hand)playerEntity2);
            AEPartLocation side = AEPartLocation.fromFacing((Direction)context.func_196000_l());
            World world = player.field_70170_p;
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"player.world");
            return new Locator(Type.PLAYER_INVENTORY_WITH_BLOCK_CONTEXT, slot, world, context.func_195995_a(), side, null);
        }

        @NotNull
        public final Locator forHand(@NotNull PlayerEntity playerEntity, @NotNull Hand hand) {
            Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
            Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
            int slot = this.getPlayerInventorySlotFromHand(playerEntity, hand);
            World world = playerEntity.field_70170_p;
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"playerEntity.world");
            return new Locator(Type.PLAYER_INVENTORY, slot, world, null, null, null);
        }

        @NotNull
        public final Locator forPart(@NotNull AEABasePart part) {
            Intrinsics.checkNotNullParameter((Object)part, (String)"part");
            IPartHost host = part.getHost();
            Intrinsics.checkNotNull((Object)host);
            DimensionalCoord pos = host.getLocation();
            World world = pos.getWorld();
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"pos.world");
            return new Locator(Type.PART, -1, world, pos.getBlockPos(), part.getSide(), null);
        }

        private final int getPlayerInventorySlotFromHand(PlayerEntity playerEntity, Hand hand) {
            ItemStack itemStack = playerEntity.func_184586_b(hand);
            if (itemStack.func_190926_b()) {
                throw new IllegalArgumentException("Cannot open an item-inventory with empty hands");
            }
            int n = 0;
            int invSize = playerEntity.field_71071_by.func_70302_i_();
            if (n < invSize) {
                do {
                    int i;
                    if (!Intrinsics.areEqual((Object)playerEntity.field_71071_by.func_70301_a(i = n++), (Object)itemStack)) continue;
                    return i;
                } while (n < invSize);
            }
            throw new IllegalArgumentException("Could not find item held in hand " + hand + " in player inventory");
        }

        @NotNull
        public final Locator read(@NotNull PacketBuffer packetBuffer) {
            Locator locator;
            Intrinsics.checkNotNullParameter((Object)packetBuffer, (String)"packetBuffer");
            byte type = packetBuffer.readByte();
            switch (type) {
                case 0: {
                    Locator locator2;
                    Locator locator3 = locator2;
                    Locator locator4 = locator2;
                    Type type2 = Type.PLAYER_INVENTORY;
                    int n = packetBuffer.readInt();
                    Object var3_3 = null;
                    throw new NullPointerException("null cannot be cast to non-null type net.minecraft.util.ResourceLocation");
                }
                case 1: {
                    locator = new Locator(Type.PLAYER_INVENTORY_WITH_BLOCK_CONTEXT, packetBuffer.readInt(), packetBuffer.func_192575_l(), packetBuffer.func_179259_c(), AEPartLocation.fromOrdinal((int)packetBuffer.readByte()), null);
                    break;
                }
                case 2: {
                    locator = new Locator(Type.BLOCK, -1, packetBuffer.func_192575_l(), packetBuffer.func_179259_c(), null, null);
                    break;
                }
                case 3: {
                    locator = new Locator(Type.PART, -1, packetBuffer.func_192575_l(), packetBuffer.func_179259_c(), AEPartLocation.fromOrdinal((int)packetBuffer.readByte()), null);
                    break;
                }
                default: {
                    throw new DecoderException(Intrinsics.stringPlus((String)"Locator type out of range: ", (Object)type));
                }
            }
            return locator;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            nArray[Type.BLOCK.ordinal()] = 1;
            nArray[Type.PART.ordinal()] = 2;
            nArray[Type.PLAYER_INVENTORY_WITH_BLOCK_CONTEXT.ordinal()] = 3;
            nArray[Type.PLAYER_INVENTORY.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

