/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.container.chemical;

import appeng.api.config.Upgrades;
import com.the9grounds.aeadditions.api.IAEAChemicalConfig;
import com.the9grounds.aeadditions.api.IChemicalConfigContainer;
import com.the9grounds.aeadditions.api.IUpgradeableHost;
import com.the9grounds.aeadditions.api.container.IChemicalSyncContainer;
import com.the9grounds.aeadditions.container.AbstractUpgradableContainer;
import com.the9grounds.aeadditions.container.slot.DisabledSlot;
import com.the9grounds.aeadditions.integration.mekanism.Mekanism;
import com.the9grounds.aeadditions.network.NetworkManager;
import com.the9grounds.aeadditions.network.packets.ChemicalConfigPacket;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B+\u0012\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001cH\u0016J\b\u0010 \u001a\u00020!H&J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0007H\u0004J!\u0010%\u001a\u00020\u001c2\u0012\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u000f0\u000eH\u0016\u00a2\u0006\u0002\u0010\u0013J\b\u0010'\u001a\u00020\u001cH\u0002J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*H\u0002J\u001e\u0010+\u001a\u00020\u001c2\f\u0010,\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010$\u001a\u00020\u0007H\u0016J\u0018\u0010-\u001a\u00020.2\u0006\u0010)\u001a\u00020/2\u0006\u00100\u001a\u00020\u0007H\u0016R(\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u000f0\u000eX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u00061"}, d2={"Lcom/the9grounds/aeadditions/container/chemical/AbstractChemicalConfigurableContainer;", "T", "Lcom/the9grounds/aeadditions/container/AbstractUpgradableContainer;", "Lcom/the9grounds/aeadditions/api/container/IChemicalSyncContainer;", "type", "Lnet/minecraft/inventory/container/ContainerType;", "id", "", "playerInventory", "Lnet/minecraft/entity/player/PlayerInventory;", "host", "Lcom/the9grounds/aeadditions/api/IUpgradeableHost;", "(Lnet/minecraft/inventory/container/ContainerType;ILnet/minecraft/entity/player/PlayerInventory;Lcom/the9grounds/aeadditions/api/IUpgradeableHost;)V", "chemicalList", "", "Lmekanism/api/chemical/Chemical;", "getChemicalList", "()[Lmekanism/api/chemical/Chemical;", "setChemicalList", "([Lmekanism/api/chemical/Chemical;)V", "[Lmekanism/api/chemical/Chemical;", "gui", "Lcom/the9grounds/aeadditions/api/IChemicalConfigContainer;", "getGui", "()Lcom/the9grounds/aeadditions/api/IChemicalConfigContainer;", "setGui", "(Lcom/the9grounds/aeadditions/api/IChemicalConfigContainer;)V", "addListener", "", "listener", "Lnet/minecraft/inventory/container/IContainerListener;", "detectAndSendChanges", "getChemicalConfig", "Lcom/the9grounds/aeadditions/api/IAEAChemicalConfig;", "isValidForConfig", "", "slot", "receiveChemicals", "chemicals", "sendChemicalListToAllValidListeners", "sendChemicalListToPlayer", "player", "Lnet/minecraft/entity/player/ServerPlayerEntity;", "setChemicalForSlot", "chemical", "transferStackInSlot", "Lnet/minecraft/item/ItemStack;", "Lnet/minecraft/entity/player/PlayerEntity;", "idx", "AEAdditions-1.16.5"})
public abstract class AbstractChemicalConfigurableContainer<T>
extends AbstractUpgradableContainer<T>
implements IChemicalSyncContainer {
    @NotNull
    private Chemical<?>[] chemicalList;
    @Nullable
    private IChemicalConfigContainer gui;

    public AbstractChemicalConfigurableContainer(@Nullable ContainerType<?> type, int id, @NotNull PlayerInventory playerInventory, @NotNull IUpgradeableHost host) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        super(type, id, playerInventory, host);
        this.chemicalList = new Chemical[0];
    }

    @NotNull
    public final Chemical<?>[] getChemicalList() {
        return this.chemicalList;
    }

    public final void setChemicalList(@NotNull Chemical<?>[] chemicalArray) {
        Intrinsics.checkNotNullParameter(chemicalArray, (String)"<set-?>");
        this.chemicalList = chemicalArray;
    }

    @Nullable
    public final IChemicalConfigContainer getGui() {
        return this.gui;
    }

    public final void setGui(@Nullable IChemicalConfigContainer iChemicalConfigContainer) {
        this.gui = iChemicalConfigContainer;
    }

    @NotNull
    public abstract IAEAChemicalConfig getChemicalConfig();

    @Override
    public void receiveChemicals(@NotNull Chemical<?>[] chemicals) {
        Intrinsics.checkNotNullParameter(chemicals, (String)"chemicals");
        this.chemicalList = chemicals;
        if (this.gui != null) {
            IChemicalConfigContainer iChemicalConfigContainer = this.gui;
            Intrinsics.checkNotNull((Object)iChemicalConfigContainer);
            iChemicalConfigContainer.onChemicalConfigChange();
        }
    }

    @Override
    public void setChemicalForSlot(@Nullable Chemical<?> chemical, int slot) {
        this.getChemicalConfig().setChemicalInSlot(slot, chemical);
        this.sendChemicalListToAllValidListeners();
    }

    @Override
    @NotNull
    public ItemStack func_82846_b(@NotNull PlayerEntity player, int idx) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.isServer()) {
            ItemStack itemStack = ItemStack.field_190927_a;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        Slot clickSlot = (Slot)this.field_75151_b.get(idx);
        if (clickSlot instanceof DisabledSlot) {
            ItemStack itemStack = ItemStack.field_190927_a;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        if (clickSlot.func_75216_d()) {
            ItemStack tis = clickSlot.func_75211_c();
            if (tis.func_190926_b()) {
                ItemStack itemStack = ItemStack.field_190927_a;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
            Intrinsics.checkNotNullExpressionValue((Object)tis, (String)"tis");
            ChemicalStack<?> chemicalInStack = Mekanism.INSTANCE.getStoredChemicalStackFromStack(tis);
            if (chemicalInStack != null) {
                int n = 0;
                IAEAChemicalConfig config = this.getChemicalConfig();
                int n2 = config.getSize();
                if (n < n2) {
                    do {
                        int i;
                        if (!config.hasChemicalInSlot(i = n++) || !this.isValidForConfig(i)) continue;
                        config.setChemicalInSlot(i, chemicalInStack.getType());
                        this.sendChemicalListToAllValidListeners();
                        break;
                    } while (n < n2);
                }
                ItemStack itemStack = ItemStack.field_190927_a;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
        }
        this.func_75142_b();
        return super.func_82846_b(player, idx);
    }

    protected final boolean isValidForConfig(int slot) {
        if (this.getSupportCapacity()) {
            int upgrades = this.getUpgradable().getInstalledUpgrades(Upgrades.CAPACITY);
            if (slot > 0 && upgrades < 1) {
                return false;
            }
            if (slot > 4 && upgrades < 2) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void func_75142_b() {
        if (this.isServer()) {
            IAEAChemicalConfig config = this.getChemicalConfig();
            boolean shouldSendPacket = false;
            int n = 0;
            int n2 = config.getSize();
            if (n < n2) {
                do {
                    int i;
                    if (config.getChemicalInSlot(i = n++) == null || this.isValidForConfig(i)) continue;
                    config.setChemicalInSlot(i, null);
                    shouldSendPacket = true;
                } while (n < n2);
            }
            if (shouldSendPacket) {
                this.sendChemicalListToAllValidListeners();
            }
        }
        super.func_75142_b();
    }

    private final void sendChemicalListToAllValidListeners() {
        for (IContainerListener listener : this.field_75149_d) {
            if (!(listener instanceof ServerPlayerEntity)) continue;
            this.sendChemicalListToPlayer((ServerPlayerEntity)listener);
        }
    }

    @Override
    public void func_75132_a(@NotNull IContainerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        super.func_75132_a(listener);
        if (listener instanceof ServerPlayerEntity) {
            this.sendChemicalListToPlayer((ServerPlayerEntity)listener);
        }
    }

    private final void sendChemicalListToPlayer(ServerPlayerEntity player) {
        NetworkManager.INSTANCE.sendTo(new ChemicalConfigPacket(this.field_75152_c, this.getChemicalConfig().getConfig()), player);
    }
}

