/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.container.chemical;

import appeng.api.config.SecurityPermissions;
import com.the9grounds.aeadditions.api.IAEAChemicalConfig;
import com.the9grounds.aeadditions.api.IAEAHasChemicalConfig;
import com.the9grounds.aeadditions.api.ICombinedChemicalContainer;
import com.the9grounds.aeadditions.api.container.IChemicalSyncContainer;
import com.the9grounds.aeadditions.container.AbstractContainer;
import com.the9grounds.aeadditions.container.ContainerTypeBuilder;
import com.the9grounds.aeadditions.container.chemical.ChemicalInterfaceContainer;
import com.the9grounds.aeadditions.container.slot.DisabledSlot;
import com.the9grounds.aeadditions.integration.mekanism.Mekanism;
import com.the9grounds.aeadditions.network.NetworkManager;
import com.the9grounds.aeadditions.network.packets.ChemicalConfigPacket;
import com.the9grounds.aeadditions.network.packets.ChemicalInterfaceContentsChangedPacket;
import com.the9grounds.aeadditions.tile.ChemicalInterfaceTileEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 92\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0003789B+\u0012\f\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020!H\u0016J\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0006H\u0004J\u000e\u0010*\u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u0015J!\u0010+\u001a\u00020!2\u0012\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010-\u001a\u00020!H\u0002J\u0010\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u000200H\u0002J\u001e\u00101\u001a\u00020!2\f\u00102\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010)\u001a\u00020\u0006H\u0016J\u0018\u00103\u001a\u0002042\u0006\u0010/\u001a\u0002052\u0006\u00106\u001a\u00020\u0006H\u0016R(\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u000e0\rX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006:"}, d2={"Lcom/the9grounds/aeadditions/container/chemical/ChemicalInterfaceContainer;", "Lcom/the9grounds/aeadditions/container/AbstractContainer;", "Lcom/the9grounds/aeadditions/api/container/IChemicalSyncContainer;", "type", "Lnet/minecraft/inventory/container/ContainerType;", "id", "", "playerInventory", "Lnet/minecraft/entity/player/PlayerInventory;", "host", "", "(Lnet/minecraft/inventory/container/ContainerType;ILnet/minecraft/entity/player/PlayerInventory;Ljava/lang/Object;)V", "chemicalList", "", "Lmekanism/api/chemical/Chemical;", "getChemicalList", "()[Lmekanism/api/chemical/Chemical;", "setChemicalList", "([Lmekanism/api/chemical/Chemical;)V", "[Lmekanism/api/chemical/Chemical;", "chemicalTankList", "Lcom/the9grounds/aeadditions/container/chemical/ChemicalInterfaceContainer$ChemicalTankList;", "getChemicalTankList", "()Lcom/the9grounds/aeadditions/container/chemical/ChemicalInterfaceContainer$ChemicalTankList;", "setChemicalTankList", "(Lcom/the9grounds/aeadditions/container/chemical/ChemicalInterfaceContainer$ChemicalTankList;)V", "gui", "Lcom/the9grounds/aeadditions/api/ICombinedChemicalContainer;", "getGui", "()Lcom/the9grounds/aeadditions/api/ICombinedChemicalContainer;", "setGui", "(Lcom/the9grounds/aeadditions/api/ICombinedChemicalContainer;)V", "addListener", "", "listener", "Lnet/minecraft/inventory/container/IContainerListener;", "detectAndSendChanges", "getChemicalConfig", "Lcom/the9grounds/aeadditions/api/IAEAChemicalConfig;", "isValidForConfig", "", "slot", "onChemicalTankListChanged", "receiveChemicals", "chemicals", "sendChemicalListToAllValidListeners", "sendChemicalListToPlayer", "player", "Lnet/minecraft/entity/player/ServerPlayerEntity;", "setChemicalForSlot", "chemical", "transferStackInSlot", "Lnet/minecraft/item/ItemStack;", "Lnet/minecraft/entity/player/PlayerEntity;", "idx", "ChemicalTank", "ChemicalTankList", "Companion", "AEAdditions-1.16.5"})
public final class ChemicalInterfaceContainer
extends AbstractContainer<ChemicalInterfaceContainer>
implements IChemicalSyncContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ChemicalTankList chemicalTankList;
    @NotNull
    private Chemical<?>[] chemicalList;
    @Nullable
    private ICombinedChemicalContainer gui;
    @NotNull
    private static final ContainerType<ChemicalInterfaceContainer> CHEMICAL_INTERFACE;

    public ChemicalInterfaceContainer(@Nullable ContainerType<?> type, int id, @NotNull PlayerInventory playerInventory, @NotNull Object host) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        super(type, id, playerInventory, false, host);
        this.bindPlayerInventory(7, 148);
        this.chemicalTankList = new ChemicalTankList(6);
        this.chemicalList = new Chemical[0];
    }

    @NotNull
    public final ChemicalTankList getChemicalTankList() {
        return this.chemicalTankList;
    }

    public final void setChemicalTankList(@NotNull ChemicalTankList chemicalTankList) {
        Intrinsics.checkNotNullParameter((Object)chemicalTankList, (String)"<set-?>");
        this.chemicalTankList = chemicalTankList;
    }

    @NotNull
    public final Chemical<?>[] getChemicalList() {
        return this.chemicalList;
    }

    public final void setChemicalList(@NotNull Chemical<?>[] chemicalArray) {
        Intrinsics.checkNotNullParameter(chemicalArray, (String)"<set-?>");
        this.chemicalList = chemicalArray;
    }

    @Nullable
    public final ICombinedChemicalContainer getGui() {
        return this.gui;
    }

    public final void setGui(@Nullable ICombinedChemicalContainer iCombinedChemicalContainer) {
        this.gui = iCombinedChemicalContainer;
    }

    @NotNull
    public final IAEAChemicalConfig getChemicalConfig() {
        TileEntity tileEntity = this.getTileEntity();
        if (tileEntity == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.the9grounds.aeadditions.api.IAEAHasChemicalConfig");
        }
        return ((IAEAHasChemicalConfig)tileEntity).getChemicalConfig();
    }

    public final void onChemicalTankListChanged(@NotNull ChemicalTankList chemicalTankList) {
        Intrinsics.checkNotNullParameter((Object)chemicalTankList, (String)"chemicalTankList");
        this.chemicalTankList = chemicalTankList;
        ICombinedChemicalContainer iCombinedChemicalContainer = this.gui;
        Intrinsics.checkNotNull((Object)iCombinedChemicalContainer);
        iCombinedChemicalContainer.onChemicalListChange();
    }

    @Override
    public void receiveChemicals(@NotNull Chemical<?>[] chemicals) {
        Intrinsics.checkNotNullParameter(chemicals, (String)"chemicals");
        this.chemicalList = chemicals;
        if (this.gui != null) {
            ICombinedChemicalContainer iCombinedChemicalContainer = this.gui;
            Intrinsics.checkNotNull((Object)iCombinedChemicalContainer);
            iCombinedChemicalContainer.onChemicalConfigChange();
        }
    }

    @Override
    public void setChemicalForSlot(@Nullable Chemical<?> chemical, int slot) {
        this.getChemicalConfig().setChemicalInSlot(slot, chemical);
        this.sendChemicalListToAllValidListeners();
    }

    @Override
    @NotNull
    public ItemStack func_82846_b(@NotNull PlayerEntity player, int idx) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!this.isServer()) {
            ItemStack itemStack = ItemStack.field_190927_a;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        Slot clickSlot = (Slot)this.field_75151_b.get(idx);
        if (clickSlot instanceof DisabledSlot) {
            ItemStack itemStack = ItemStack.field_190927_a;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        if (clickSlot.func_75216_d()) {
            ItemStack tis = clickSlot.func_75211_c();
            if (tis.func_190926_b()) {
                ItemStack itemStack = ItemStack.field_190927_a;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
            Intrinsics.checkNotNullExpressionValue((Object)tis, (String)"tis");
            ChemicalStack<?> chemicalInStack = Mekanism.INSTANCE.getStoredChemicalStackFromStack(tis);
            if (chemicalInStack != null) {
                int n = 0;
                IAEAChemicalConfig config = this.getChemicalConfig();
                int n2 = config.getSize();
                if (n < n2) {
                    do {
                        int i;
                        if (!config.hasChemicalInSlot(i = n++) || !this.isValidForConfig(i)) continue;
                        config.setChemicalInSlot(i, chemicalInStack.getType());
                        this.sendChemicalListToAllValidListeners();
                        break;
                    } while (n < n2);
                }
                ItemStack itemStack = ItemStack.field_190927_a;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                return itemStack;
            }
        }
        this.func_75142_b();
        return super.func_82846_b(player, idx);
    }

    protected final boolean isValidForConfig(int slot) {
        return true;
    }

    @Override
    public void func_75142_b() {
        if (this.isServer()) {
            IAEAChemicalConfig config = this.getChemicalConfig();
            boolean shouldSendPacket = false;
            int n = 0;
            int n2 = config.getSize();
            if (n < n2) {
                do {
                    int i;
                    if (config.getChemicalInSlot(i = n++) == null || this.isValidForConfig(i)) continue;
                    config.setChemicalInSlot(i, null);
                    shouldSendPacket = true;
                } while (n < n2);
            }
            if (shouldSendPacket) {
                this.sendChemicalListToAllValidListeners();
            }
        }
        super.func_75142_b();
    }

    private final void sendChemicalListToAllValidListeners() {
        for (IContainerListener listener : this.field_75149_d) {
            if (!(listener instanceof ServerPlayerEntity)) continue;
            this.sendChemicalListToPlayer((ServerPlayerEntity)listener);
        }
    }

    @Override
    public void func_75132_a(@NotNull IContainerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        super.func_75132_a(listener);
        if (listener instanceof ServerPlayerEntity) {
            this.sendChemicalListToPlayer((ServerPlayerEntity)listener);
            TileEntity tileEntity = this.getTileEntity();
            Intrinsics.checkNotNull((Object)tileEntity);
            NetworkManager.INSTANCE.sendTo(new ChemicalInterfaceContentsChangedPacket(((ChemicalInterfaceTileEntity)tileEntity).getChemicalTankListToSend()), (ServerPlayerEntity)listener);
        }
    }

    private final void sendChemicalListToPlayer(ServerPlayerEntity player) {
        NetworkManager.INSTANCE.sendTo(new ChemicalConfigPacket(this.field_75152_c, this.getChemicalConfig().getConfig()), player);
    }

    static {
        ContainerTypeBuilder containerTypeBuilder = new ContainerTypeBuilder(Reflection.getOrCreateKotlinClass(ChemicalInterfaceTileEntity.class), Companion.CHEMICAL_INTERFACE.1.INSTANCE).requirePermission(SecurityPermissions.BUILD);
        boolean bl = false;
        boolean bl2 = false;
        ContainerTypeBuilder $this$CHEMICAL_INTERFACE_u24lambda_u2d0 = containerTypeBuilder;
        boolean bl3 = false;
        $this$CHEMICAL_INTERFACE_u24lambda_u2d0.setTitleComponent((ITextComponent)new StringTextComponent("Chemical Interface"));
        CHEMICAL_INTERFACE = containerTypeBuilder.build("chemical_interface");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/the9grounds/aeadditions/container/chemical/ChemicalInterfaceContainer$Companion;", "", "()V", "CHEMICAL_INTERFACE", "Lnet/minecraft/inventory/container/ContainerType;", "Lcom/the9grounds/aeadditions/container/chemical/ChemicalInterfaceContainer;", "getCHEMICAL_INTERFACE", "()Lnet/minecraft/inventory/container/ContainerType;", "AEAdditions-1.16.5"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ContainerType<ChemicalInterfaceContainer> getCHEMICAL_INTERFACE() {
            return CHEMICAL_INTERFACE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J,\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00032\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u001b\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/the9grounds/aeadditions/container/chemical/ChemicalInterfaceContainer$ChemicalTankList;", "", "size", "", "(I)V", "chemicalTanks", "", "Lcom/the9grounds/aeadditions/container/chemical/ChemicalInterfaceContainer$ChemicalTank;", "getChemicalTanks", "()[Lcom/the9grounds/aeadditions/container/chemical/ChemicalInterfaceContainer$ChemicalTank;", "[Lcom/the9grounds/aeadditions/container/chemical/ChemicalInterfaceContainer$ChemicalTank;", "getSize", "()I", "readFromNbt", "", "nbt", "Lnet/minecraft/nbt/CompoundNBT;", "setChemicalTank", "index", "chemical", "Lmekanism/api/chemical/Chemical;", "amount", "", "capacity", "writeToNbt", "AEAdditions-1.16.5"})
    public static final class ChemicalTankList {
        private final int size;
        @NotNull
        private final ChemicalTank[] chemicalTanks;

        public ChemicalTankList(int size) {
            this.size = size;
            this.chemicalTanks = new ChemicalTank[this.size];
        }

        public final int getSize() {
            return this.size;
        }

        @NotNull
        public final ChemicalTank[] getChemicalTanks() {
            return this.chemicalTanks;
        }

        public final void setChemicalTank(int index, @Nullable Chemical<?> chemical, long amount, long capacity) {
            ChemicalTank chemicalTank = new ChemicalTank();
            chemicalTank.setChemical(chemical);
            chemicalTank.setAmount(amount);
            chemicalTank.setCapacity(capacity);
            this.chemicalTanks[index] = chemicalTank;
        }

        public final void readFromNbt(@NotNull CompoundNBT nbt) {
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            int n = 0;
            int n2 = this.size;
            if (n < n2) {
                do {
                    int i = n++;
                    this.chemicalTanks[i] = new ChemicalTank();
                    if (!nbt.func_74764_b(Intrinsics.stringPlus((String)"tank#", (Object)i))) continue;
                    ChemicalTank chemicalTank = this.chemicalTanks[i];
                    Intrinsics.checkNotNull((Object)chemicalTank);
                    ChemicalTank chemicalTank2 = chemicalTank;
                    chemicalTank = nbt.func_74775_l(Intrinsics.stringPlus((String)"tank#", (Object)i));
                    Intrinsics.checkNotNullExpressionValue((Object)chemicalTank, (String)"nbt.getCompound(\"tank#${i}\")");
                    chemicalTank2.readFromNbt((CompoundNBT)chemicalTank);
                } while (n < n2);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void writeToNbt(@NotNull CompoundNBT nbt) {
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            nbt.func_74768_a("size", this.size);
            ChemicalTank[] $this$forEachIndexed$iv = this.chemicalTanks;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (ChemicalTank item$iv : $this$forEachIndexed$iv) {
                void chemicalTank;
                int n = index$iv++;
                ChemicalTank chemicalTank2 = item$iv;
                int index = n;
                boolean bl = false;
                if (chemicalTank == null || chemicalTank.getChemical() == null) continue;
                CompoundNBT chemicalTankCompound = new CompoundNBT();
                chemicalTank.writeToNbt(chemicalTankCompound);
                nbt.func_218657_a(Intrinsics.stringPlus((String)"tank#", (Object)index), (INBT)chemicalTankCompound);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR \u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lcom/the9grounds/aeadditions/container/chemical/ChemicalInterfaceContainer$ChemicalTank;", "", "()V", "amount", "", "getAmount", "()J", "setAmount", "(J)V", "capacity", "getCapacity", "setCapacity", "chemical", "Lmekanism/api/chemical/Chemical;", "getChemical", "()Lmekanism/api/chemical/Chemical;", "setChemical", "(Lmekanism/api/chemical/Chemical;)V", "readFromNbt", "", "nbt", "Lnet/minecraft/nbt/CompoundNBT;", "writeToNbt", "AEAdditions-1.16.5"})
    public static final class ChemicalTank {
        @Nullable
        private Chemical<?> chemical;
        private long amount;
        private long capacity;

        @Nullable
        public final Chemical<?> getChemical() {
            return this.chemical;
        }

        public final void setChemical(@Nullable Chemical<?> chemical) {
            this.chemical = chemical;
        }

        public final long getAmount() {
            return this.amount;
        }

        public final void setAmount(long l) {
            this.amount = l;
        }

        public final long getCapacity() {
            return this.capacity;
        }

        public final void setCapacity(long l) {
            this.capacity = l;
        }

        public final void readFromNbt(@NotNull CompoundNBT nbt) {
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            if (nbt.func_74764_b("chemicalType")) {
                this.chemical = Mekanism.INSTANCE.readChemicalFromNbt(nbt);
                this.amount = nbt.func_74763_f("amount");
                this.capacity = nbt.func_74763_f("capacity");
            }
        }

        public final void writeToNbt(@NotNull CompoundNBT nbt) {
            Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
            if (this.chemical == null) {
                return;
            }
            nbt.func_74772_a("amount", this.amount);
            nbt.func_74772_a("capacity", this.capacity);
            Chemical<?> chemical = this.chemical;
            Intrinsics.checkNotNull(chemical);
            nbt.func_74778_a("chemicalType", Mekanism.INSTANCE.getType(chemical));
            chemical = this.chemical;
            Intrinsics.checkNotNull(chemical);
            chemical.write(nbt);
        }
    }
}

