/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.container.chemical;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.helpers.InventoryAction;
import appeng.me.helpers.ChannelPowerSrc;
import com.the9grounds.aeadditions.api.IChemicalListContainer;
import com.the9grounds.aeadditions.api.chemical.IAEChemicalStack;
import com.the9grounds.aeadditions.container.AbstractContainer;
import com.the9grounds.aeadditions.container.ContainerTypeBuilder;
import com.the9grounds.aeadditions.container.chemical.ChemicalTerminalContainer;
import com.the9grounds.aeadditions.integration.mekanism.Mekanism;
import com.the9grounds.aeadditions.network.NetworkManager;
import com.the9grounds.aeadditions.network.packets.MEInteractionPacket;
import com.the9grounds.aeadditions.network.packets.MEInventoryUpdatePacket;
import com.the9grounds.aeadditions.sync.gui.GuiSync;
import com.the9grounds.aeadditions.util.StorageChannels;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001d\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 V2\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001VB\u001f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB)\u0012\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020;H\u0016J\u0016\u0010?\u001a\u00020;2\u0006\u0010@\u001a\u00020\u00052\u0006\u0010A\u001a\u00020BJ&\u0010C\u001a\u00020;2\b\u0010D\u001a\u0004\u0018\u00010E2\b\u0010F\u001a\u0004\u0018\u00010\u00032\b\u0010A\u001a\u0004\u0018\u00010BH\u0002J\u0012\u0010G\u001a\u00020\u000f2\b\u0010H\u001a\u0004\u0018\u00010IH\u0016J\u0010\u0010J\u001a\u00020;2\u0006\u0010D\u001a\u00020KH\u0016J\b\u0010L\u001a\u00020;H\u0016J2\u0010M\u001a\u00020;2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010N2\u000e\u0010O\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010P2\b\u0010Q\u001a\u0004\u0018\u00010RH\u0016J\u0010\u0010S\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J\u0018\u0010T\u001a\u00020;2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010NH\u0002J\b\u0010U\u001a\u00020;H\u0002R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\u0011\"\u0004\b\"\u0010#R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001c\u0010*\u001a\u0004\u0018\u00010+X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001c\u00100\u001a\u0004\u0018\u000101X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0019\u00106\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u000107\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109\u00a8\u0006W"}, d2={"Lcom/the9grounds/aeadditions/container/chemical/ChemicalTerminalContainer;", "Lcom/the9grounds/aeadditions/container/AbstractContainer;", "Lappeng/api/storage/IMEMonitorHandlerReceiver;", "Lcom/the9grounds/aeadditions/api/chemical/IAEChemicalStack;", "windowId", "", "playerInventory", "Lnet/minecraft/entity/player/PlayerInventory;", "host", "Lappeng/api/storage/ITerminalHost;", "(ILnet/minecraft/entity/player/PlayerInventory;Lappeng/api/storage/ITerminalHost;)V", "type", "Lnet/minecraft/inventory/container/ContainerType;", "(Lnet/minecraft/inventory/container/ContainerType;ILnet/minecraft/entity/player/PlayerInventory;Lappeng/api/storage/ITerminalHost;)V", "canInteractWithGrid", "", "getCanInteractWithGrid", "()Z", "chemicalList", "Lappeng/api/storage/data/IItemList;", "getChemicalList", "()Lappeng/api/storage/data/IItemList;", "setChemicalList", "(Lappeng/api/storage/data/IItemList;)V", "gui", "Lcom/the9grounds/aeadditions/api/IChemicalListContainer;", "getGui", "()Lcom/the9grounds/aeadditions/api/IChemicalListContainer;", "setGui", "(Lcom/the9grounds/aeadditions/api/IChemicalListContainer;)V", "hasPower", "getHasPower$annotations", "()V", "getHasPower", "setHasPower", "(Z)V", "monitor", "Lappeng/api/storage/IMEMonitor;", "getMonitor", "()Lappeng/api/storage/IMEMonitor;", "setMonitor", "(Lappeng/api/storage/IMEMonitor;)V", "networkNode", "Lappeng/api/networking/IGridNode;", "getNetworkNode", "()Lappeng/api/networking/IGridNode;", "setNetworkNode", "(Lappeng/api/networking/IGridNode;)V", "powerSource", "Lappeng/api/networking/energy/IEnergySource;", "getPowerSource", "()Lappeng/api/networking/energy/IEnergySource;", "setPowerSource", "(Lappeng/api/networking/energy/IEnergySource;)V", "storageChannel", "Lappeng/api/storage/IStorageChannel;", "getStorageChannel", "()Lappeng/api/storage/IStorageChannel;", "addListener", "", "listener", "Lnet/minecraft/inventory/container/IContainerListener;", "detectAndSendChanges", "handleInteraction", "slot", "action", "Lappeng/helpers/InventoryAction;", "handleNetworkInteraction", "player", "Lnet/minecraft/entity/player/ServerPlayerEntity;", "stack", "isValid", "verificationToken", "", "onContainerClosed", "Lnet/minecraft/entity/player/PlayerEntity;", "onListUpdate", "postChange", "Lappeng/api/networking/storage/IBaseMonitor;", "change", "", "actionSource", "Lappeng/api/networking/security/IActionSource;", "removeListener", "sendChemicalList", "updatePowerStatus", "Companion", "AEAdditions-1.16.5"})
public final class ChemicalTerminalContainer
extends AbstractContainer<ChemicalTerminalContainer>
implements IMEMonitorHandlerReceiver<IAEChemicalStack> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ITerminalHost host;
    @Nullable
    private IItemList<IAEChemicalStack> chemicalList;
    @Nullable
    private IChemicalListContainer gui;
    @Nullable
    private IGridNode networkNode;
    @Nullable
    private IEnergySource powerSource;
    private boolean hasPower;
    @Nullable
    private final IStorageChannel<IAEChemicalStack> storageChannel;
    @Nullable
    private IMEMonitor<IAEChemicalStack> monitor;
    @NotNull
    private static final ContainerType<ChemicalTerminalContainer> TYPE = new ContainerTypeBuilder(Reflection.getOrCreateKotlinClass(ITerminalHost.class), Companion.TYPE.1.INSTANCE).requirePermission(SecurityPermissions.EXTRACT).build("chemical_terminal");

    public ChemicalTerminalContainer(@NotNull ContainerType<?> type, int windowId, @NotNull PlayerInventory playerInventory, @NotNull ITerminalHost host) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        super(type, windowId, playerInventory, false, host);
        this.host = host;
        this.storageChannel = StorageChannels.INSTANCE.getCHEMICAL();
        this.setPosY(139);
        this.setPosX(8);
        this.bindPlayerInventory(this.getPosX(), this.getPosY());
        IEnergySource powerSource = null;
        if (this.isServer()) {
            this.monitor = this.host.getInventory(this.storageChannel);
            if (this.monitor != null) {
                IMEMonitor<IAEChemicalStack> iMEMonitor = this.monitor;
                Intrinsics.checkNotNull(iMEMonitor);
                iMEMonitor.addListener((IMEMonitorHandlerReceiver)this, null);
                if (this.host instanceof IGridHost || this.host instanceof IActionHost) {
                    IGridNode node;
                    ITerminalHost iTerminalHost = this.host;
                    IGridNode iGridNode = iTerminalHost instanceof IGridHost ? ((IGridHost)this.host).getGridNode(AEPartLocation.INTERNAL) : (node = iTerminalHost instanceof IActionHost ? ((IActionHost)this.host).getActionableNode() : null);
                    if (node != null) {
                        this.networkNode = node;
                        powerSource = (IEnergySource)new ChannelPowerSrc(this.networkNode, (IEnergySource)node.getGrid().getCache(IEnergyGrid.class));
                    }
                }
            } else {
                this.setValidContainer(false);
            }
        }
        this.powerSource = powerSource;
    }

    @Nullable
    public final IItemList<IAEChemicalStack> getChemicalList() {
        return this.chemicalList;
    }

    public final void setChemicalList(@Nullable IItemList<IAEChemicalStack> iItemList) {
        this.chemicalList = iItemList;
    }

    @Nullable
    public final IChemicalListContainer getGui() {
        return this.gui;
    }

    public final void setGui(@Nullable IChemicalListContainer iChemicalListContainer) {
        this.gui = iChemicalListContainer;
    }

    @Nullable
    public final IGridNode getNetworkNode() {
        return this.networkNode;
    }

    public final void setNetworkNode(@Nullable IGridNode iGridNode) {
        this.networkNode = iGridNode;
    }

    @Nullable
    public final IEnergySource getPowerSource() {
        return this.powerSource;
    }

    public final void setPowerSource(@Nullable IEnergySource iEnergySource) {
        this.powerSource = iEnergySource;
    }

    public final boolean getHasPower() {
        return this.hasPower;
    }

    public final void setHasPower(boolean bl) {
        this.hasPower = bl;
    }

    @GuiSync(key="hasPower")
    public static /* synthetic */ void getHasPower$annotations() {
    }

    @Nullable
    public final IStorageChannel<IAEChemicalStack> getStorageChannel() {
        return this.storageChannel;
    }

    @Nullable
    public final IMEMonitor<IAEChemicalStack> getMonitor() {
        return this.monitor;
    }

    public final void setMonitor(@Nullable IMEMonitor<IAEChemicalStack> iMEMonitor) {
        this.monitor = iMEMonitor;
    }

    public ChemicalTerminalContainer(int windowId, @NotNull PlayerInventory playerInventory, @NotNull ITerminalHost host) {
        Intrinsics.checkNotNullParameter((Object)playerInventory, (String)"playerInventory");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this(TYPE, windowId, playerInventory, host);
    }

    public void func_82847_b(@NotNull IContainerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        super.func_82847_b(listener);
        if (this.field_75149_d.isEmpty() && this.monitor != null) {
            IMEMonitor<IAEChemicalStack> iMEMonitor = this.monitor;
            Intrinsics.checkNotNull(iMEMonitor);
            iMEMonitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    public void func_75134_a(@NotNull PlayerEntity player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.func_75134_a(player);
        IMEMonitor<IAEChemicalStack> iMEMonitor = this.monitor;
        if (iMEMonitor != null) {
            iMEMonitor.removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    public boolean isValid(@Nullable Object verificationToken) {
        return true;
    }

    @Override
    public void func_75142_b() {
        if (this.isServer()) {
            if (!Intrinsics.areEqual(this.monitor, (Object)this.host.getInventory(this.storageChannel))) {
                this.setValidContainer(false);
                return;
            }
            this.updatePowerStatus();
            super.func_75142_b();
        }
    }

    @Override
    public void func_75132_a(@NotNull IContainerListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        super.func_75132_a(listener);
        if (listener instanceof ServerPlayerEntity) {
            this.sendChemicalList((IBaseMonitor<IAEChemicalStack>)((IBaseMonitor)this.monitor));
        }
    }

    private final void updatePowerStatus() {
        try {
            if (this.networkNode != null) {
                IGridNode iGridNode = this.networkNode;
                Intrinsics.checkNotNull((Object)iGridNode);
                this.hasPower = iGridNode.isActive();
            } else if (this.powerSource instanceof IEnergyGrid) {
                IEnergyGrid iEnergyGrid = (IEnergyGrid)this.powerSource;
                Intrinsics.checkNotNull((Object)iEnergyGrid);
                this.hasPower = iEnergyGrid.isNetworkPowered();
            } else {
                IEnergySource iEnergySource = this.powerSource;
                Intrinsics.checkNotNull((Object)iEnergySource);
                this.hasPower = iEnergySource.extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.8;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final boolean getCanInteractWithGrid() {
        return this.monitor != null && this.powerSource != null && this.hasPower;
    }

    public void postChange(@Nullable IBaseMonitor<IAEChemicalStack> monitor, @Nullable Iterable<? extends IAEChemicalStack> change, @Nullable IActionSource actionSource) {
        this.sendChemicalList(monitor);
    }

    private final void sendChemicalList(IBaseMonitor<IAEChemicalStack> monitor) {
        IItemList storageList;
        Intrinsics.checkNotNull(monitor);
        this.chemicalList = storageList = ((IMEMonitor)monitor).getStorageList();
        Intrinsics.checkNotNullExpressionValue((Object)storageList, (String)"storageList");
        this.sendPacketToClient(new MEInventoryUpdatePacket(this.field_75152_c, (IItemList<IAEChemicalStack>)storageList));
    }

    public void onListUpdate() {
        if (this.isServer()) {
            // empty if block
        }
    }

    public final void handleInteraction(int slot, @NotNull InventoryAction action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (this.isClient()) {
            NetworkManager.INSTANCE.sendToServer(new MEInteractionPacket(this.field_75152_c, slot, action));
            return;
        }
        if (!this.getCanInteractWithGrid()) {
            return;
        }
        PlayerEntity playerEntity = this.getPlayerInventory().field_70458_d;
        if (playerEntity == null) {
            throw new NullPointerException("null cannot be cast to non-null type net.minecraft.entity.player.ServerPlayerEntity");
        }
        ServerPlayerEntity player = (ServerPlayerEntity)playerEntity;
        if (slot == -1) {
            this.handleNetworkInteraction(player, null, action);
            return;
        }
        IItemList<IAEChemicalStack> iItemList = this.chemicalList;
        Intrinsics.checkNotNull(iItemList);
        IAEChemicalStack stack = (IAEChemicalStack)CollectionsKt.toList((Iterable)((Iterable)iItemList)).get(slot);
        this.handleNetworkInteraction(player, stack, action);
    }

    private final void handleNetworkInteraction(ServerPlayerEntity player, IAEChemicalStack stack, InventoryAction action) {
        IEnergySource iEnergySource;
        IEnergySource iEnergySource2;
        if (action != InventoryAction.FILL_ITEM && action != InventoryAction.EMPTY_ITEM) {
            return;
        }
        Intrinsics.checkNotNull((Object)player);
        ItemStack held = player.field_71071_by.func_70445_o();
        if (held.func_190916_E() != 1) {
            return;
        }
        if (stack != null) {
            Intrinsics.checkNotNullExpressionValue((Object)held, (String)"held");
            iEnergySource2 = Mekanism.INSTANCE.getCapabilityFromChemicalStorageItemForChemicalStack(held, stack.getChemicalStack());
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)held, (String)"held");
            iEnergySource2 = iEnergySource = Mekanism.INSTANCE.capabilityFromChemicalStorageItem(held);
        }
        if (iEnergySource == null) {
            return;
        }
        IEnergySource handler = iEnergySource;
        if (action == InventoryAction.FILL_ITEM && stack != null) {
            iEnergySource = this.monitor;
            Intrinsics.checkNotNull(iEnergySource);
            IEnergySource iEnergySource3 = iEnergySource;
            iEnergySource = this.powerSource;
            Intrinsics.checkNotNull((Object)iEnergySource);
            if (!Mekanism.INSTANCE.insertChemicalIntoContainer(stack, held, (IChemicalHandler<?, ?>)handler, (IMEMonitor<IAEChemicalStack>)iEnergySource3, iEnergySource, this.getMySrc())) {
                return;
            }
            player.func_71110_a((Container)this, this.func_75138_a());
        } else if (action == InventoryAction.EMPTY_ITEM) {
            iEnergySource = this.monitor;
            Intrinsics.checkNotNull(iEnergySource);
            IEnergySource iEnergySource4 = iEnergySource;
            iEnergySource = this.powerSource;
            Intrinsics.checkNotNull((Object)iEnergySource);
            if (!Mekanism.INSTANCE.extractChemicalFromContainer(held, (IMEMonitor<IAEChemicalStack>)iEnergySource4, iEnergySource, this.getMySrc())) {
                return;
            }
            player.func_71110_a((Container)this, this.func_75138_a());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/the9grounds/aeadditions/container/chemical/ChemicalTerminalContainer$Companion;", "", "()V", "TYPE", "Lnet/minecraft/inventory/container/ContainerType;", "Lcom/the9grounds/aeadditions/container/chemical/ChemicalTerminalContainer;", "getTYPE", "()Lnet/minecraft/inventory/container/ContainerType;", "AEAdditions-1.16.5"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ContainerType<ChemicalTerminalContainer> getTYPE() {
            return TYPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

