/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.container.slot;

import com.the9grounds.aeadditions.container.AbstractContainer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J\b\u0010\u001d\u001a\u00020\u0005H\u0016J\b\u0010\u001e\u001a\u00020\u0019H\u0016J\b\u0010\u001f\u001a\u00020\u0013H\u0017J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0019H\u0016J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u0001H\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0019H\u0016J\u0010\u0010'\u001a\u00020$2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016R\u001e\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0014\u00a8\u0006("}, d2={"Lcom/the9grounds/aeadditions/container/slot/AEASlot;", "Lnet/minecraft/inventory/container/Slot;", "inv", "Lnet/minecraftforge/items/IItemHandler;", "slot", "", "(Lnet/minecraftforge/items/IItemHandler;I)V", "x", "y", "(Lnet/minecraftforge/items/IItemHandler;III)V", "container", "Lcom/the9grounds/aeadditions/container/AbstractContainer;", "getContainer", "()Lcom/the9grounds/aeadditions/container/AbstractContainer;", "setContainer", "(Lcom/the9grounds/aeadditions/container/AbstractContainer;)V", "getInv", "()Lnet/minecraftforge/items/IItemHandler;", "isSlotEnabled", "", "()Z", "canTakeStack", "playerIn", "Lnet/minecraft/entity/player/PlayerEntity;", "decrStackSize", "Lnet/minecraft/item/ItemStack;", "amount", "getItemStackLimit", "stack", "getSlotStackLimit", "getStack", "isEnabled", "isItemValid", "isSameInventory", "other", "onSlotChange", "", "oldStackIn", "newStackIn", "putStack", "AEAdditions-1.16.5"})
public class AEASlot
extends Slot {
    @NotNull
    private final IItemHandler inv;
    public AbstractContainer<?> container;
    private final boolean isSlotEnabled;

    public AEASlot(@NotNull IItemHandler inv, int slot, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)inv, (String)"inv");
        super((IInventory)new Inventory(0), slot, x, y);
        this.inv = inv;
        this.isSlotEnabled = true;
    }

    @NotNull
    public final IItemHandler getInv() {
        return this.inv;
    }

    public AEASlot(@NotNull IItemHandler inv, int slot) {
        Intrinsics.checkNotNullParameter((Object)inv, (String)"inv");
        this(inv, slot, 0, 0);
    }

    public void func_75220_a(@NotNull ItemStack oldStackIn, @NotNull ItemStack newStackIn) {
        Intrinsics.checkNotNullParameter((Object)oldStackIn, (String)"oldStackIn");
        Intrinsics.checkNotNullParameter((Object)newStackIn, (String)"newStackIn");
        super.func_75220_a(oldStackIn, newStackIn);
    }

    @NotNull
    public final AbstractContainer<?> getContainer() {
        AbstractContainer<?> abstractContainer = this.container;
        if (abstractContainer != null) {
            return abstractContainer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"container");
        throw null;
    }

    public final void setContainer(@NotNull AbstractContainer<?> abstractContainer) {
        Intrinsics.checkNotNullParameter(abstractContainer, (String)"<set-?>");
        this.container = abstractContainer;
    }

    public boolean func_75214_a(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (this.isSlotEnabled) {
            return this.inv.isItemValid(this.getSlotIndex(), stack);
        }
        return false;
    }

    @NotNull
    public ItemStack func_75211_c() {
        if (!this.isSlotEnabled) {
            ItemStack itemStack = ItemStack.field_190927_a;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        if (this.inv.getSlots() < this.getSlotIndex()) {
            ItemStack itemStack = ItemStack.field_190927_a;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        ItemStack itemStack = this.inv.getStackInSlot(this.getSlotIndex());
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"inv.getStackInSlot(slotIndex)");
        return itemStack;
    }

    public final boolean isSlotEnabled() {
        return this.isSlotEnabled;
    }

    public void func_75215_d(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (this.inv instanceof IItemHandlerModifiable) {
            ((IItemHandlerModifiable)this.inv).setStackInSlot(this.getSlotIndex(), stack);
        } else {
            this.inv.extractItem(this.getSlotIndex(), Integer.MAX_VALUE, false);
            this.inv.insertItem(this.getSlotIndex(), stack, false);
        }
        this.func_75218_e();
    }

    public int func_75219_a() {
        return this.inv.getSlotLimit(this.getSlotIndex());
    }

    public int func_178170_b(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        int n = this.func_75219_a();
        int n2 = stack.func_77976_d();
        boolean bl = false;
        return Math.min(n, n2);
    }

    public boolean func_82869_a(@NotNull PlayerEntity playerIn) {
        Intrinsics.checkNotNullParameter((Object)playerIn, (String)"playerIn");
        if (this.isSlotEnabled) {
            return !this.inv.extractItem(this.getSlotIndex(), 1, true).func_190926_b();
        }
        return false;
    }

    @NotNull
    public ItemStack func_75209_a(int amount) {
        ItemStack itemStack = this.inv.extractItem(this.getSlotIndex(), amount, false);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"inv.extractItem(slotIndex, amount, false)");
        return itemStack;
    }

    public boolean isSameInventory(@NotNull Slot other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other instanceof AEASlot && ((AEASlot)other).inv == this.inv;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_111238_b() {
        return this.isSlotEnabled;
    }
}

