/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.core;

import com.the9grounds.aeadditions.api.IAEAChemicalConfig;
import com.the9grounds.aeadditions.integration.mekanism.Mekanism;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import mekanism.api.chemical.Chemical;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0019\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u0006H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0003H\u0016J\u0015\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u0012H\u0096\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u00032\f\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007H\u0016J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001c\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/the9grounds/aeadditions/core/AEAChemicalConfig;", "Lcom/the9grounds/aeadditions/api/IAEAChemicalConfig;", "size", "", "(I)V", "_config", "", "Lmekanism/api/chemical/Chemical;", "[Lmekanism/api/chemical/Chemical;", "getSize", "()I", "getChemicalInSlot", "slot", "getConfig", "()[Lmekanism/api/chemical/Chemical;", "hasChemicalInSlot", "", "iterator", "", "readFromNbt", "", "nbt", "Lnet/minecraft/nbt/CompoundNBT;", "name", "", "setChemicalInSlot", "chemical", "writeToNbt", "AEAdditions-1.16.5"})
public final class AEAChemicalConfig
implements IAEAChemicalConfig {
    private final int size;
    @NotNull
    private final Chemical<?>[] _config;

    public AEAChemicalConfig(int size) {
        this.size = size;
        this._config = new Chemical[this.getSize()];
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    @NotNull
    public Chemical<?>[] getConfig() {
        return this._config;
    }

    @Override
    public void setChemicalInSlot(int slot, @Nullable Chemical<?> chemical) {
        this._config[slot] = chemical;
    }

    @Override
    @Nullable
    public Chemical<?> getChemicalInSlot(int slot) {
        return this._config[slot];
    }

    @Override
    public boolean hasChemicalInSlot(int slot) {
        return this._config[slot] != null;
    }

    @Override
    public void readFromNbt(@NotNull CompoundNBT nbt, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (nbt.func_74764_b(name)) {
            CompoundNBT compound = nbt.func_74775_l(name);
            int n = 0;
            int n2 = this.getSize();
            if (n < n2) {
                do {
                    int i;
                    if (!compound.func_74764_b(Intrinsics.stringPlus((String)"config#", (Object)(i = n++)))) continue;
                    CompoundNBT chemicalNbt = compound.func_74775_l(Intrinsics.stringPlus((String)"config#", (Object)i));
                    Intrinsics.checkNotNullExpressionValue((Object)chemicalNbt, (String)"chemicalNbt");
                    Chemical<?> chemical = Mekanism.INSTANCE.readChemicalFromNbt(chemicalNbt);
                    this._config[i] = chemical;
                } while (n < n2);
            }
        }
    }

    @Override
    public void writeToNbt(@NotNull CompoundNBT nbt, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        CompoundNBT compound = new CompoundNBT();
        int n = 0;
        int n2 = this.getSize();
        if (n < n2) {
            do {
                int i;
                Chemical<?> chemical;
                if ((chemical = this.getChemicalInSlot(i = n++)) == null) continue;
                CompoundNBT chemicalNbt = new CompoundNBT();
                chemical.write(chemicalNbt);
                chemicalNbt.func_74778_a("chemicalType", Mekanism.INSTANCE.getType(chemical));
                compound.func_218657_a(Intrinsics.stringPlus((String)"config#", (Object)i), (INBT)chemicalNbt);
            } while (n < n2);
        }
        nbt.func_218657_a(name, (INBT)compound);
    }

    @Override
    @NotNull
    public Iterator<Chemical<?>> iterator() {
        return ArrayIteratorKt.iterator((Object[])this._config);
    }
}

