/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.core.inv;

import com.the9grounds.aeadditions.core.inv.IAEAInventory;
import com.the9grounds.aeadditions.core.inv.ItemFilter;
import com.the9grounds.aeadditions.core.inv.Operation;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0015\n\u0002\b\u0012\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002B!\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tB\u0019\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nB)\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ \u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u000fH\u0016J\u0006\u0010,\u001a\u00020\u0007J\u0010\u0010-\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0016J \u0010.\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u000fH\u0016J\u0018\u00100\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u0003H\u0016J\u0011\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000302H\u0096\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010)\u001a\u00020\u0007H\u0014J\u0018\u00105\u001a\u0002042\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J\u0016\u0010:\u001a\u0002042\u0006\u0010)\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0018\u0010;\u001a\u0002042\u0006\u0010)\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u0003H\u0016J\u0018\u0010<\u001a\u0002042\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0011\"\u0004\b\u001d\u0010\u0013R\u0011\u0010\u001e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0011R\u0011\u0010\b\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\"\u0010\"\u001a\n #*\u0004\u0018\u00010\u00030\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006="}, d2={"Lcom/the9grounds/aeadditions/core/inv/AEAInternalInventory;", "Lnet/minecraftforge/items/ItemStackHandler;", "", "Lnet/minecraft/item/ItemStack;", "host", "Lcom/the9grounds/aeadditions/core/inv/IAEAInventory;", "size", "", "maxStack", "(Lcom/the9grounds/aeadditions/core/inv/IAEAInventory;II)V", "(Lcom/the9grounds/aeadditions/core/inv/IAEAInventory;I)V", "filter", "Lcom/the9grounds/aeadditions/core/inv/ItemFilter;", "(Lcom/the9grounds/aeadditions/core/inv/IAEAInventory;IILcom/the9grounds/aeadditions/core/inv/ItemFilter;)V", "clientEventsEnabled", "", "getClientEventsEnabled", "()Z", "setClientEventsEnabled", "(Z)V", "getFilter", "()Lcom/the9grounds/aeadditions/core/inv/ItemFilter;", "setFilter", "(Lcom/the9grounds/aeadditions/core/inv/ItemFilter;)V", "getHost", "()Lcom/the9grounds/aeadditions/core/inv/IAEAInventory;", "setHost", "(Lcom/the9grounds/aeadditions/core/inv/IAEAInventory;)V", "isDirty", "setDirty", "isEventsEnabled", "", "getMaxStack", "()[I", "previousStack", "kotlin.jvm.PlatformType", "getPreviousStack", "()Lnet/minecraft/item/ItemStack;", "setPreviousStack", "(Lnet/minecraft/item/ItemStack;)V", "extractItem", "slot", "amount", "simulate", "fetchFirstEmptySlot", "getSlotLimit", "insertItem", "stack", "isItemValid", "iterator", "", "onContentsChanged", "", "readFromNBT", "data", "Lnet/minecraft/nbt/CompoundNBT;", "name", "", "setMaxStackSize", "setStackInSlot", "writeToNBT", "AEAdditions-1.16.5"})
public class AEAInternalInventory
extends ItemStackHandler
implements Iterable<ItemStack>,
KMappedMarker {
    @Nullable
    private IAEAInventory host;
    @Nullable
    private ItemFilter filter;
    @NotNull
    private final int[] maxStack;
    private ItemStack previousStack;
    private boolean isDirty;
    private boolean clientEventsEnabled;

    public AEAInternalInventory(@Nullable IAEAInventory host, int size, int maxStack, @Nullable ItemFilter filter) {
        super(size);
        this.host = host;
        this.filter = filter;
        this.maxStack = new int[size];
        this.previousStack = ItemStack.field_190927_a;
        ArraysKt.fill$default((int[])this.maxStack, (int)maxStack, (int)0, (int)0, (int)6, null);
    }

    @Nullable
    public final IAEAInventory getHost() {
        return this.host;
    }

    public final void setHost(@Nullable IAEAInventory iAEAInventory) {
        this.host = iAEAInventory;
    }

    @Nullable
    public final ItemFilter getFilter() {
        return this.filter;
    }

    public final void setFilter(@Nullable ItemFilter itemFilter) {
        this.filter = itemFilter;
    }

    @NotNull
    public final int[] getMaxStack() {
        return this.maxStack;
    }

    public final ItemStack getPreviousStack() {
        return this.previousStack;
    }

    public final void setPreviousStack(ItemStack itemStack) {
        this.previousStack = itemStack;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }

    public final void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    public final boolean getClientEventsEnabled() {
        return this.clientEventsEnabled;
    }

    public final void setClientEventsEnabled(boolean bl) {
        this.clientEventsEnabled = bl;
    }

    public AEAInternalInventory(@Nullable IAEAInventory host, int size, int maxStack) {
        this(host, size, maxStack, null);
    }

    public AEAInternalInventory(@Nullable IAEAInventory host, int size) {
        this(host, size, 64, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isEventsEnabled() {
        if (this.host != null) {
            IAEAInventory iAEAInventory = this.host;
            Intrinsics.checkNotNull((Object)iAEAInventory);
            if (!iAEAInventory.isRemote()) return true;
        }
        if (!this.clientEventsEnabled) return false;
        return true;
    }

    public final int fetchFirstEmptySlot() {
        int n = 0;
        int n2 = this.getSlots();
        if (n < n2) {
            do {
                int slot = n++;
                ItemStack itemStack = this.getStackInSlot(slot);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getStackInSlot(slot)");
                ItemStack stack = itemStack;
                if (!stack.func_190926_b()) continue;
                return slot;
            } while (n < n2);
        }
        return -1;
    }

    public int getSlotLimit(int slot) {
        return this.maxStack[slot];
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.previousStack = this.getStackInSlot(slot).func_77946_l();
        super.setStackInSlot(slot, stack);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemFilter itemFilter;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (this.filter != null) {
            itemFilter = this.filter;
            Intrinsics.checkNotNull((Object)itemFilter);
            if (!itemFilter.allowInsert((IItemHandler)this, slot, stack)) {
                return stack;
            }
        }
        if (!simulate) {
            this.previousStack = this.getStackInSlot(slot).func_77946_l();
        }
        itemFilter = super.insertItem(slot, stack, simulate);
        Intrinsics.checkNotNullExpressionValue((Object)itemFilter, (String)"super.insertItem(slot, stack, simulate)");
        return itemFilter;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemFilter itemFilter;
        if (this.filter != null) {
            itemFilter = this.filter;
            Intrinsics.checkNotNull((Object)itemFilter);
            if (!itemFilter.allowExtract((IItemHandler)this, slot, amount)) {
                itemFilter = ItemStack.field_190927_a;
                Intrinsics.checkNotNullExpressionValue((Object)itemFilter, (String)"EMPTY");
                return itemFilter;
            }
        }
        if (!simulate) {
            this.previousStack = this.getStackInSlot(slot).func_77946_l();
        }
        itemFilter = super.extractItem(slot, amount, simulate);
        Intrinsics.checkNotNullExpressionValue((Object)itemFilter, (String)"super.extractItem(slot, amount, simulate)");
        return itemFilter;
    }

    protected void onContentsChanged(int slot) {
        if (this.host != null && this.isEventsEnabled() && !this.isDirty) {
            IAEAInventory iAEAInventory;
            this.isDirty = true;
            ItemStack newStack = this.getStackInSlot(slot).func_77946_l();
            ItemStack oldStack = this.previousStack;
            Operation operation = Operation.SET;
            if (newStack.func_190926_b() || oldStack.func_190926_b() || ItemStack.func_77989_b((ItemStack)newStack, (ItemStack)oldStack)) {
                if (newStack.func_190916_E() > oldStack.func_190916_E()) {
                    newStack.func_190918_g(oldStack.func_190916_E());
                    oldStack = ItemStack.field_190927_a;
                    operation = Operation.INSERT;
                } else {
                    oldStack.func_190918_g(newStack.func_190916_E());
                    newStack = ItemStack.field_190927_a;
                    operation = Operation.EXTRACT;
                }
            }
            if ((iAEAInventory = this.host) != null) {
                IItemHandler iItemHandler = (IItemHandler)this;
                ItemStack itemStack = oldStack;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"oldStack");
                ItemStack itemStack2 = itemStack;
                itemStack = newStack;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"newStack");
                iAEAInventory.onInventoryChanged(iItemHandler, slot, operation, itemStack2, itemStack);
            }
            iAEAInventory = this.host;
            if (iAEAInventory != null) {
                iAEAInventory.saveChanges();
            }
            this.previousStack = ItemStack.field_190927_a;
            this.isDirty = false;
        }
        super.onContentsChanged(slot);
    }

    public final void setMaxStackSize(int slot, int maxStack) {
        this.maxStack[slot] = maxStack;
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (this.maxStack[slot] == 0) {
            return false;
        }
        if (this.filter != null) {
            ItemFilter itemFilter = this.filter;
            Intrinsics.checkNotNull((Object)itemFilter);
            return itemFilter.allowInsert((IItemHandler)this, slot, stack);
        }
        return true;
    }

    public void writeToNBT(@NotNull CompoundNBT data, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        data.func_218657_a(name, (INBT)this.serializeNBT());
    }

    public void readFromNBT(@NotNull CompoundNBT data, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.deserializeNBT(data.func_74775_l(name));
    }

    @Override
    @NotNull
    public Iterator<ItemStack> iterator() {
        NonNullList nonNullList = this.stacks;
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"stacks");
        return CollectionsKt.toList((Iterable)((Iterable)nonNullList)).iterator();
    }
}

