/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.integration.mekanism;

import appeng.api.IAppEngApi;
import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEStack;
import com.the9grounds.aeadditions.LoggerKt;
import com.the9grounds.aeadditions.api.chemical.IAEChemicalStack;
import com.the9grounds.aeadditions.integration.appeng.AppEng;
import com.the9grounds.aeadditions.integration.mekanism.chemical.AEChemicalStack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.util.StorageUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J,\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010JL\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b\"\u0010\b\u0000\u0010\u0012*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J,\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ0\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010 \u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0002J0\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\"\u001a\u00020\u001a2\u000e\u0010 \u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0002J8\u0010#\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0004\"\u0010\b\u0000\u0010\u0012*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0014J$\u0010$\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\bJ\u0018\u0010&\u001a\u00020\u000e2\u000e\u0010 \u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0004H\u0002J\u0014\u0010'\u001a\u0004\u0018\u00010(2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*J\u0012\u0010+\u001a\u0004\u0018\u00010(2\b\u0010,\u001a\u0004\u0018\u00010-J\u001e\u0010.\u001a\u0006\u0012\u0002\b\u00030\b2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010/\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u00100\u001a\u0002012\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*J(\u00102\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u000f\u001a\u00020\u0010Ju\u00103\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b\"\u0014\b\u0000\u0010\u0012*\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H50\u0004\"\u000e\b\u0001\u00104*\b\u0012\u0004\u0012\u0002H40*\"\u000e\b\u0002\u00105*\b\u0012\u0004\u0012\u0002H40\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00142\u0006\u0010%\u001a\u0002H52\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u00106Jm\u00103\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b\"\u0014\b\u0000\u0010\u0012*\u000e\u0012\u0004\u0012\u0002H4\u0012\u0004\u0012\u0002H50\u0004\"\u000e\b\u0001\u00104*\b\u0012\u0004\u0012\u0002H40*\"\u000e\b\u0002\u00105*\b\u0012\u0004\u0012\u0002H40\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00142\u0006\u0010%\u001a\u0002H52\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u00107J0\u00108\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010%\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u000f\u001a\u00020\u0010JD\u00109\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00062\u000e\u0010 \u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010:\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0006J\u0012\u0010;\u001a\u0006\u0012\u0002\b\u00030*2\u0006\u0010<\u001a\u00020=J\u0012\u0010>\u001a\u0006\u0012\u0002\b\u00030*2\u0006\u0010?\u001a\u00020@J\u0012\u0010A\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010<\u001a\u00020=J\u001a\u0010B\u001a\u00020C2\u0006\u0010<\u001a\u00020=2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*\u00a8\u0006D"}, d2={"Lcom/the9grounds/aeadditions/integration/mekanism/Mekanism;", "", "()V", "capabilityFromChemicalStorageItem", "Lmekanism/api/chemical/IChemicalHandler;", "itemStack", "Lnet/minecraft/item/ItemStack;", "extractChemical", "Lmekanism/api/chemical/ChemicalStack;", "tileEntity", "Lnet/minecraft/tileentity/TileEntity;", "side", "Lnet/minecraft/util/Direction;", "amount", "", "action", "Lmekanism/api/Action;", "extractChemicalForCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "extractChemicalFromContainer", "", "heldItem", "monitor", "Lappeng/api/storage/IMEMonitor;", "Lcom/the9grounds/aeadditions/api/chemical/IAEChemicalStack;", "powerSource", "Lappeng/api/networking/energy/IEnergySource;", "source", "Lappeng/api/networking/security/IActionSource;", "extractFromContainer", "handler", "fillContainer", "stack", "getCapabilityFromChemicalStorageItem", "getCapabilityFromChemicalStorageItemForChemicalStack", "chemicalStack", "getCapacity", "getChemicalTexture", "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;", "chemical", "Lmekanism/api/chemical/Chemical;", "getSprite", "spriteLocation", "Lnet/minecraft/util/ResourceLocation;", "getStackFromStack", "getStoredChemicalStackFromStack", "getType", "", "insertChemical", "insertChemicalForCapability", "CHEMICAL", "STACK", "(Lnet/minecraft/tileentity/TileEntity;Lnet/minecraft/util/Direction;Lnet/minecraftforge/common/capabilities/Capability;Lmekanism/api/chemical/ChemicalStack;Lmekanism/api/Action;)Lmekanism/api/chemical/ChemicalStack;", "(Lnet/minecraft/tileentity/TileEntity;Lnet/minecraftforge/common/capabilities/Capability;Lmekanism/api/chemical/ChemicalStack;Lmekanism/api/Action;)Lmekanism/api/chemical/ChemicalStack;", "insertChemicalForChemicalCapability", "insertChemicalIntoContainer", "isItemStackAChemicalContainer", "readChemicalFromNbt", "nbt", "Lnet/minecraft/nbt/CompoundNBT;", "readChemicalFromPacket", "packet", "Lnet/minecraft/network/PacketBuffer;", "readChemicalStackFromNbt", "writeChemicalWithTypeToNbt", "", "AEAdditions-1.16.5"})
public final class Mekanism {
    @NotNull
    public static final Mekanism INSTANCE = new Mekanism();

    private Mekanism() {
    }

    @NotNull
    public final String getType(@NotNull Chemical<?> chemical) {
        String string;
        Intrinsics.checkNotNullParameter(chemical, (String)"chemical");
        Chemical<?> chemical2 = chemical;
        if (chemical2 instanceof Gas) {
            string = "gas";
        } else if (chemical2 instanceof Pigment) {
            string = "pigment";
        } else if (chemical2 instanceof InfuseType) {
            string = "infusion";
        } else if (chemical2 instanceof Slurry) {
            string = "slurry";
        } else {
            throw new RuntimeException("Invalid chemical type");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final Chemical<?> readChemicalFromNbt(@NotNull CompoundNBT nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        String string = nbt.func_74779_i("chemicalType");
        if (string == null) throw new RuntimeException("Invalid chemical type");
        int n = -1;
        switch (string.hashCode()) {
            case 184404329: {
                if (string.equals("infusion")) {
                    n = 1;
                }
                break;
            }
            case 102105: {
                if (string.equals("gas")) {
                    n = 2;
                }
                break;
            }
            case -574271508: {
                if (string.equals("pigment")) {
                    n = 3;
                }
                break;
            }
            case -899275907: {
                if (string.equals("slurry")) {
                    n = 4;
                }
                break;
            }
        }
        switch (n) {
            case 2: {
                Gas gas = Gas.readFromNBT((CompoundNBT)nbt);
                Intrinsics.checkNotNullExpressionValue((Object)gas, (String)"readFromNBT(nbt)");
                Chemical chemical = (Chemical)gas;
                return chemical;
            }
            case 3: {
                Pigment pigment = Pigment.readFromNBT((CompoundNBT)nbt);
                Intrinsics.checkNotNullExpressionValue((Object)pigment, (String)"readFromNBT(nbt)");
                Chemical chemical = (Chemical)pigment;
                return chemical;
            }
            case 1: {
                InfuseType infuseType = InfuseType.readFromNBT((CompoundNBT)nbt);
                Intrinsics.checkNotNullExpressionValue((Object)infuseType, (String)"readFromNBT(nbt)");
                Chemical chemical = (Chemical)infuseType;
                return chemical;
            }
            case 4: {
                Slurry slurry = Slurry.readFromNBT((CompoundNBT)nbt);
                Intrinsics.checkNotNullExpressionValue((Object)slurry, (String)"readFromNBT(nbt)");
                Chemical chemical = (Chemical)slurry;
                return chemical;
            }
            default: {
                throw new RuntimeException("Invalid chemical type");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final ChemicalStack<?> readChemicalStackFromNbt(@NotNull CompoundNBT nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        String string = nbt.func_74779_i("chemicalType");
        if (string == null) throw new RuntimeException("Invalid chemical type");
        int n = -1;
        switch (string.hashCode()) {
            case 184404329: {
                if (string.equals("infusion")) {
                    n = 1;
                }
                break;
            }
            case 102105: {
                if (string.equals("gas")) {
                    n = 2;
                }
                break;
            }
            case -574271508: {
                if (string.equals("pigment")) {
                    n = 3;
                }
                break;
            }
            case -899275907: {
                if (string.equals("slurry")) {
                    n = 4;
                }
                break;
            }
        }
        switch (n) {
            case 2: {
                GasStack gasStack = GasStack.readFromNBT((CompoundNBT)nbt);
                Intrinsics.checkNotNullExpressionValue((Object)gasStack, (String)"readFromNBT(nbt)");
                ChemicalStack chemicalStack = (ChemicalStack)gasStack;
                return chemicalStack;
            }
            case 3: {
                PigmentStack pigmentStack = PigmentStack.readFromNBT((CompoundNBT)nbt);
                Intrinsics.checkNotNullExpressionValue((Object)pigmentStack, (String)"readFromNBT(nbt)");
                ChemicalStack chemicalStack = (ChemicalStack)pigmentStack;
                return chemicalStack;
            }
            case 1: {
                InfusionStack infusionStack = InfusionStack.readFromNBT((CompoundNBT)nbt);
                Intrinsics.checkNotNullExpressionValue((Object)infusionStack, (String)"readFromNBT(nbt)");
                ChemicalStack chemicalStack = (ChemicalStack)infusionStack;
                return chemicalStack;
            }
            case 4: {
                SlurryStack slurryStack = SlurryStack.readFromNBT((CompoundNBT)nbt);
                Intrinsics.checkNotNullExpressionValue((Object)slurryStack, (String)"readFromNBT(nbt)");
                ChemicalStack chemicalStack = (ChemicalStack)slurryStack;
                return chemicalStack;
            }
            default: {
                throw new RuntimeException("Invalid chemical type");
            }
        }
    }

    public final void writeChemicalWithTypeToNbt(@NotNull CompoundNBT nbt, @NotNull Chemical<?> chemical) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter(chemical, (String)"chemical");
        String chemicalType = this.getType(chemical);
        nbt.func_74778_a("chemicalType", chemicalType);
        chemical.write(nbt);
    }

    @Nullable
    public final IChemicalHandler<?, ?> capabilityFromChemicalStorageItem(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        ChemicalStack<?> chemicalStack = this.getStoredChemicalStackFromStack(itemStack);
        if (chemicalStack == null) {
            return null;
        }
        ChemicalStack<?> chemicalStack2 = chemicalStack;
        return this.getCapabilityFromChemicalStorageItemForChemicalStack(itemStack, chemicalStack2);
    }

    @Nullable
    public final IChemicalHandler<?, ?> getCapabilityFromChemicalStorageItemForChemicalStack(@NotNull ItemStack itemStack, @NotNull ChemicalStack<?> chemicalStack) {
        IChemicalHandler<?, ?> iChemicalHandler;
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter(chemicalStack, (String)"chemicalStack");
        ChemicalStack<?> chemicalStack2 = chemicalStack;
        if (chemicalStack2 instanceof GasStack) {
            Capability capability = Capabilities.GAS_HANDLER_CAPABILITY;
            Intrinsics.checkNotNullExpressionValue((Object)capability, (String)"GAS_HANDLER_CAPABILITY");
            iChemicalHandler = this.getCapabilityFromChemicalStorageItem(itemStack, capability);
        } else if (chemicalStack2 instanceof InfusionStack) {
            Capability capability = Capabilities.INFUSION_HANDLER_CAPABILITY;
            Intrinsics.checkNotNullExpressionValue((Object)capability, (String)"INFUSION_HANDLER_CAPABILITY");
            iChemicalHandler = this.getCapabilityFromChemicalStorageItem(itemStack, capability);
        } else if (chemicalStack2 instanceof PigmentStack) {
            Capability capability = Capabilities.PIGMENT_HANDLER_CAPABILITY;
            Intrinsics.checkNotNullExpressionValue((Object)capability, (String)"PIGMENT_HANDLER_CAPABILITY");
            iChemicalHandler = this.getCapabilityFromChemicalStorageItem(itemStack, capability);
        } else if (chemicalStack2 instanceof SlurryStack) {
            Capability capability = Capabilities.SLURRY_HANDLER_CAPABILITY;
            Intrinsics.checkNotNullExpressionValue((Object)capability, (String)"SLURRY_HANDLER_CAPABILITY");
            iChemicalHandler = this.getCapabilityFromChemicalStorageItem(itemStack, capability);
        } else {
            iChemicalHandler = null;
        }
        return iChemicalHandler;
    }

    public final boolean isItemStackAChemicalContainer(@NotNull ItemStack itemStack) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Capability capability = Capabilities.GAS_HANDLER_CAPABILITY;
        Intrinsics.checkNotNullExpressionValue((Object)capability, (String)"GAS_HANDLER_CAPABILITY");
        if (this.getCapabilityFromChemicalStorageItem(itemStack, capability) != null) {
            bl = true;
        } else {
            capability = Capabilities.INFUSION_HANDLER_CAPABILITY;
            Intrinsics.checkNotNullExpressionValue((Object)capability, (String)"INFUSION_HANDLER_CAPABILITY");
            if (this.getCapabilityFromChemicalStorageItem(itemStack, capability) != null) {
                bl = true;
            } else {
                capability = Capabilities.PIGMENT_HANDLER_CAPABILITY;
                Intrinsics.checkNotNullExpressionValue((Object)capability, (String)"PIGMENT_HANDLER_CAPABILITY");
                if (this.getCapabilityFromChemicalStorageItem(itemStack, capability) != null) {
                    bl = true;
                } else {
                    capability = Capabilities.SLURRY_HANDLER_CAPABILITY;
                    Intrinsics.checkNotNullExpressionValue((Object)capability, (String)"SLURRY_HANDLER_CAPABILITY");
                    bl = this.getCapabilityFromChemicalStorageItem(itemStack, capability) != null;
                }
            }
        }
        return bl;
    }

    @Nullable
    public final <T extends IChemicalHandler<?, ?>> IChemicalHandler<?, ?> getCapabilityFromChemicalStorageItem(@NotNull ItemStack itemStack, @NotNull Capability<T> capability) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter(capability, (String)"capability");
        return itemStack.getCapability(capability).resolve().orElse(null);
    }

    public final boolean insertChemicalIntoContainer(@NotNull IAEChemicalStack chemicalStack, @NotNull ItemStack heldItem, @NotNull IChemicalHandler<?, ?> handler, @NotNull IMEMonitor<IAEChemicalStack> monitor, @NotNull IEnergySource powerSource, @NotNull IActionSource source) {
        Intrinsics.checkNotNullParameter((Object)chemicalStack, (String)"chemicalStack");
        Intrinsics.checkNotNullParameter((Object)heldItem, (String)"heldItem");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Intrinsics.checkNotNullParameter(monitor, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)powerSource, (String)"powerSource");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        IAEChemicalStack stack = (IAEChemicalStack)chemicalStack.copy();
        stack.setStackSize(Integer.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)stack, (String)"stack");
        ChemicalStack chemicalStack2 = Mekanism.fillContainer$default(this, stack, handler, null, 4, null);
        if (chemicalStack2 == null) {
            return false;
        }
        ChemicalStack maxFill = chemicalStack2;
        stack.setStackSize(maxFill.getAmount());
        IAppEngApi iAppEngApi = AppEng.Companion.getAPI();
        Intrinsics.checkNotNull((Object)iAppEngApi);
        IAEChemicalStack canPull = (IAEChemicalStack)iAppEngApi.storage().poweredExtraction(powerSource, (IMEInventory)monitor, (IAEStack)stack, source, Actionable.SIMULATE);
        if (canPull == null || canPull.getStackSize() < 1L) {
            return false;
        }
        ChemicalStack chemicalStack3 = Mekanism.fillContainer$default(this, canPull, handler, null, 4, null);
        if (chemicalStack3 == null) {
            return false;
        }
        ChemicalStack cannotFill = chemicalStack3;
        if (cannotFill.getAmount() == 0L) {
            return false;
        }
        stack.setStackSize(canPull.getStackSize() - cannotFill.getAmount());
        IAppEngApi iAppEngApi2 = AppEng.Companion.getAPI();
        Intrinsics.checkNotNull((Object)iAppEngApi2);
        IAEChemicalStack pulled = (IAEChemicalStack)iAppEngApi2.storage().poweredExtraction(powerSource, (IMEInventory)monitor, (IAEStack)stack, source, Actionable.MODULATE);
        if (pulled == null || pulled.getStackSize() < 1L) {
            LoggerKt.getLogger().warn("Unable to pull chemical from ME system even though simulation said yes");
            return false;
        }
        ChemicalStack<?> notFilled = this.fillContainer(pulled, handler, Action.EXECUTE);
        if (notFilled == null || notFilled.getAmount() == pulled.getStackSize()) {
            LoggerKt.getLogger().warn("Unable to insert chemical into held tank, even though simulation worked, reinserting into ME system");
            monitor.injectItems((IAEStack)pulled, Actionable.MODULATE, source);
            return false;
        }
        if (notFilled.getAmount() != 0L) {
            monitor.injectItems((IAEStack)new AEChemicalStack(notFilled), Actionable.MODULATE, source);
        }
        if (notFilled.getAmount() != cannotFill.getAmount()) {
            LoggerKt.getLogger().warn("Filled is different than can fill for {}", (Object)heldItem.func_200301_q());
        }
        return true;
    }

    public final boolean extractChemicalFromContainer(@NotNull ItemStack heldItem, @NotNull IMEMonitor<IAEChemicalStack> monitor, @NotNull IEnergySource powerSource, @NotNull IActionSource source) {
        Intrinsics.checkNotNullParameter((Object)heldItem, (String)"heldItem");
        Intrinsics.checkNotNullParameter(monitor, (String)"monitor");
        Intrinsics.checkNotNullParameter((Object)powerSource, (String)"powerSource");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        IChemicalHandler<?, ?> iChemicalHandler = this.capabilityFromChemicalStorageItem(heldItem);
        if (iChemicalHandler == null) {
            return false;
        }
        IChemicalHandler<?, ?> handler = iChemicalHandler;
        ChemicalStack extracted = Mekanism.extractFromContainer$default(this, Integer.MAX_VALUE, handler, null, 4, null);
        if (extracted == null || extracted.isEmpty() || extracted.getAmount() < 1L) {
            return false;
        }
        IAppEngApi iAppEngApi = AppEng.Companion.getAPI();
        Intrinsics.checkNotNull((Object)iAppEngApi);
        IAEChemicalStack notStorable = (IAEChemicalStack)iAppEngApi.storage().poweredInsert(powerSource, (IMEInventory)monitor, (IAEStack)new AEChemicalStack(extracted), source, Actionable.SIMULATE);
        if (notStorable != null && notStorable.getStackSize() > 0L) {
            long toStore = extracted.getAmount() - notStorable.getStackSize();
            ChemicalStack storable = Mekanism.extractFromContainer$default(this, toStore, handler, null, 4, null);
            if (storable == null || storable.isEmpty() || storable.getAmount() < 1L) {
                return false;
            }
            extracted.setAmount(storable.getAmount());
        }
        ChemicalStack<?> drained = this.extractFromContainer(extracted.getAmount(), handler, Action.EXECUTE);
        Intrinsics.checkNotNull(drained);
        extracted.setAmount(drained.getAmount());
        IAppEngApi iAppEngApi2 = AppEng.Companion.getAPI();
        Intrinsics.checkNotNull((Object)iAppEngApi2);
        IAEChemicalStack notInserted = (IAEChemicalStack)iAppEngApi2.storage().poweredInsert(powerSource, (IMEInventory)monitor, (IAEStack)new AEChemicalStack(extracted), source, Actionable.MODULATE);
        if (notInserted != null && notInserted.getStackSize() > 0L) {
            LoggerKt.getLogger().warn("Chemical Item {} reported a different possible amount to drain than it actually provided.", (Object)heldItem.func_200301_q());
        }
        return true;
    }

    private final ChemicalStack<?> extractFromContainer(long amount, IChemicalHandler<?, ?> handler, Action action) {
        IChemicalHandler<?, ?> iChemicalHandler = handler;
        return iChemicalHandler instanceof IGasHandler ? ((IGasHandler)handler).extractChemical(amount, action) : (iChemicalHandler instanceof IInfusionHandler ? ((IInfusionHandler)handler).extractChemical(amount, action) : (iChemicalHandler instanceof IPigmentHandler ? ((IPigmentHandler)handler).extractChemical(amount, action) : (iChemicalHandler instanceof ISlurryHandler ? ((ISlurryHandler)handler).extractChemical(amount, action) : null)));
    }

    static /* synthetic */ ChemicalStack extractFromContainer$default(Mekanism mekanism, long l, IChemicalHandler iChemicalHandler, Action action, int n, Object object) {
        if ((n & 4) != 0) {
            action = Action.SIMULATE;
        }
        return mekanism.extractFromContainer(l, iChemicalHandler, action);
    }

    private final long getCapacity(IChemicalHandler<?, ?> handler) {
        IChemicalHandler<?, ?> iChemicalHandler = handler;
        return iChemicalHandler instanceof IGasHandler ? handler.getTankCapacity(0) : (iChemicalHandler instanceof IInfusionHandler ? handler.getTankCapacity(0) : (iChemicalHandler instanceof IPigmentHandler ? handler.getTankCapacity(0) : (iChemicalHandler instanceof ISlurryHandler ? handler.getTankCapacity(0) : 0L)));
    }

    private final ChemicalStack<?> fillContainer(IAEChemicalStack stack, IChemicalHandler<?, ?> handler, Action action) {
        IChemicalHandler<?, ?> iChemicalHandler = handler;
        return iChemicalHandler instanceof IGasHandler ? ((IGasHandler)handler).insertChemical((ChemicalStack)((GasStack)stack.getChemicalStack()), action) : (iChemicalHandler instanceof IInfusionHandler ? ((IInfusionHandler)handler).insertChemical((ChemicalStack)((InfusionStack)stack.getChemicalStack()), action) : (iChemicalHandler instanceof IPigmentHandler ? ((IPigmentHandler)handler).insertChemical((ChemicalStack)((PigmentStack)stack.getChemicalStack()), action) : (iChemicalHandler instanceof ISlurryHandler ? ((ISlurryHandler)handler).insertChemical((ChemicalStack)((SlurryStack)stack.getChemicalStack()), action) : null)));
    }

    static /* synthetic */ ChemicalStack fillContainer$default(Mekanism mekanism, IAEChemicalStack iAEChemicalStack, IChemicalHandler iChemicalHandler, Action action, int n, Object object) {
        if ((n & 4) != 0) {
            action = Action.SIMULATE;
        }
        return mekanism.fillContainer(iAEChemicalStack, iChemicalHandler, action);
    }

    @Nullable
    public final ChemicalStack<?> getStoredChemicalStackFromStack(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        GasStack gasStack = StorageUtils.getStoredGasFromNBT((ItemStack)itemStack);
        Intrinsics.checkNotNullExpressionValue((Object)gasStack, (String)"getStoredGasFromNBT(itemStack)");
        GasStack gasStack2 = gasStack;
        InfusionStack infusionStack = StorageUtils.getStoredInfusionFromNBT((ItemStack)itemStack);
        Intrinsics.checkNotNullExpressionValue((Object)infusionStack, (String)"getStoredInfusionFromNBT(itemStack)");
        InfusionStack infusionStack2 = infusionStack;
        PigmentStack pigmentStack = StorageUtils.getStoredPigmentFromNBT((ItemStack)itemStack);
        Intrinsics.checkNotNullExpressionValue((Object)pigmentStack, (String)"getStoredPigmentFromNBT(itemStack)");
        PigmentStack pigmentStack2 = pigmentStack;
        SlurryStack slurryStack = StorageUtils.getStoredSlurryFromNBT((ItemStack)itemStack);
        Intrinsics.checkNotNullExpressionValue((Object)slurryStack, (String)"getStoredSlurryFromNBT(itemStack)");
        SlurryStack slurryStack2 = slurryStack;
        return true == !gasStack2.isEmpty() ? (ChemicalStack)gasStack2 : (true == !infusionStack2.isEmpty() ? (ChemicalStack)infusionStack2 : (true == !pigmentStack2.isEmpty() ? (ChemicalStack)pigmentStack2 : (true == !slurryStack2.isEmpty() ? (ChemicalStack)slurryStack2 : null)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final Chemical<?> readChemicalFromPacket(@NotNull PacketBuffer packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        String chemicalType = packet.func_218666_n();
        String chemicalName = packet.func_218666_n();
        String string = chemicalType;
        if (string == null) throw new RuntimeException("Invalid chemical type");
        int n = -1;
        switch (string.hashCode()) {
            case 184404329: {
                if (string.equals("infusion")) {
                    n = 1;
                }
                break;
            }
            case 102105: {
                if (string.equals("gas")) {
                    n = 2;
                }
                break;
            }
            case -574271508: {
                if (string.equals("pigment")) {
                    n = 3;
                }
                break;
            }
            case -899275907: {
                if (string.equals("slurry")) {
                    n = 4;
                }
                break;
            }
        }
        switch (n) {
            case 2: {
                Gas gas = Gas.getFromRegistry((ResourceLocation)new ResourceLocation(chemicalName));
                Intrinsics.checkNotNullExpressionValue((Object)gas, (String)"getFromRegistry(ResourceLocation(chemicalName))");
                Chemical chemical = (Chemical)gas;
                return chemical;
            }
            case 3: {
                Pigment pigment = Pigment.getFromRegistry((ResourceLocation)new ResourceLocation(chemicalName));
                Intrinsics.checkNotNullExpressionValue((Object)pigment, (String)"getFromRegistry(ResourceLocation(chemicalName))");
                Chemical chemical = (Chemical)pigment;
                return chemical;
            }
            case 1: {
                InfuseType infuseType = InfuseType.getFromRegistry((ResourceLocation)new ResourceLocation(chemicalName));
                Intrinsics.checkNotNullExpressionValue((Object)infuseType, (String)"getFromRegistry(ResourceLocation(chemicalName))");
                Chemical chemical = (Chemical)infuseType;
                return chemical;
            }
            case 4: {
                Slurry slurry = Slurry.getFromRegistry((ResourceLocation)new ResourceLocation(chemicalName));
                Intrinsics.checkNotNullExpressionValue((Object)slurry, (String)"getFromRegistry(ResourceLocation(chemicalName))");
                Chemical chemical = (Chemical)slurry;
                return chemical;
            }
            default: {
                throw new RuntimeException("Invalid chemical type");
            }
        }
    }

    @Nullable
    public final TextureAtlasSprite getChemicalTexture(@NotNull Chemical<?> chemical) {
        Intrinsics.checkNotNullParameter(chemical, (String)"chemical");
        return this.getSprite(chemical.getIcon());
    }

    @Nullable
    public final TextureAtlasSprite getSprite(@Nullable ResourceLocation spriteLocation) {
        return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(spriteLocation);
    }

    @Nullable
    public final ChemicalStack<?> insertChemicalForChemicalCapability(@NotNull TileEntity tileEntity, @NotNull Direction side, @NotNull ChemicalStack<?> chemicalStack, @NotNull Action action) {
        ChemicalStack<?> chemicalStack2;
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(chemicalStack, (String)"chemicalStack");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Chemical chemical = chemicalStack.getType();
        if (chemical instanceof Gas) {
            Capability capability = Capabilities.GAS_HANDLER_CAPABILITY;
            Intrinsics.checkNotNullExpressionValue((Object)capability, (String)"GAS_HANDLER_CAPABILITY");
            chemicalStack2 = this.insertChemicalForCapability(tileEntity, side, capability, (ChemicalStack)((GasStack)chemicalStack), action);
        } else if (chemical instanceof Pigment) {
            Capability capability = Capabilities.PIGMENT_HANDLER_CAPABILITY;
            Intrinsics.checkNotNullExpressionValue((Object)capability, (String)"PIGMENT_HANDLER_CAPABILITY");
            chemicalStack2 = this.insertChemicalForCapability(tileEntity, side, capability, (ChemicalStack)((PigmentStack)chemicalStack), action);
        } else if (chemical instanceof Slurry) {
            Capability capability = Capabilities.SLURRY_HANDLER_CAPABILITY;
            Intrinsics.checkNotNullExpressionValue((Object)capability, (String)"SLURRY_HANDLER_CAPABILITY");
            chemicalStack2 = this.insertChemicalForCapability(tileEntity, side, capability, (ChemicalStack)((SlurryStack)chemicalStack), action);
        } else if (chemical instanceof InfuseType) {
            Capability capability = Capabilities.INFUSION_HANDLER_CAPABILITY;
            Intrinsics.checkNotNullExpressionValue((Object)capability, (String)"INFUSION_HANDLER_CAPABILITY");
            chemicalStack2 = this.insertChemicalForCapability(tileEntity, side, capability, (ChemicalStack)((InfusionStack)chemicalStack), action);
        } else {
            chemicalStack2 = null;
        }
        return chemicalStack2;
    }

    @Nullable
    public final ChemicalStack<?> insertChemical(@NotNull TileEntity tileEntity, @NotNull ChemicalStack<?> chemicalStack, @NotNull Action action) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        Intrinsics.checkNotNullParameter(chemicalStack, (String)"chemicalStack");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Capability capability = Capabilities.GAS_HANDLER_CAPABILITY;
        Intrinsics.checkNotNullExpressionValue((Object)capability, (String)"GAS_HANDLER_CAPABILITY");
        ChemicalStack<?> gasStack = this.insertChemicalForCapability(tileEntity, capability, (ChemicalStack)((GasStack)chemicalStack), action);
        if (gasStack == null || gasStack.getAmount() != chemicalStack.getAmount()) {
            return gasStack;
        }
        Capability capability2 = Capabilities.SLURRY_HANDLER_CAPABILITY;
        Intrinsics.checkNotNullExpressionValue((Object)capability2, (String)"SLURRY_HANDLER_CAPABILITY");
        ChemicalStack<?> slurryStack = this.insertChemicalForCapability(tileEntity, capability2, (ChemicalStack)((SlurryStack)chemicalStack), action);
        if (slurryStack == null || slurryStack.getAmount() != chemicalStack.getAmount()) {
            return slurryStack;
        }
        Capability capability3 = Capabilities.INFUSION_HANDLER_CAPABILITY;
        Intrinsics.checkNotNullExpressionValue((Object)capability3, (String)"INFUSION_HANDLER_CAPABILITY");
        ChemicalStack<?> infusionStack = this.insertChemicalForCapability(tileEntity, capability3, (ChemicalStack)((InfusionStack)chemicalStack), action);
        if (infusionStack == null || infusionStack.getAmount() != chemicalStack.getAmount()) {
            return infusionStack;
        }
        Capability capability4 = Capabilities.PIGMENT_HANDLER_CAPABILITY;
        Intrinsics.checkNotNullExpressionValue((Object)capability4, (String)"PIGMENT_HANDLER_CAPABILITY");
        ChemicalStack<?> pigmentStack = this.insertChemicalForCapability(tileEntity, capability4, (ChemicalStack)((PigmentStack)chemicalStack), action);
        if (pigmentStack == null || pigmentStack.getAmount() != chemicalStack.getAmount()) {
            return pigmentStack;
        }
        return null;
    }

    @Nullable
    public final <T extends IChemicalHandler<CHEMICAL, STACK>, CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> ChemicalStack<?> insertChemicalForCapability(@NotNull TileEntity tileEntity, @NotNull Capability<T> capability, @NotNull STACK chemicalStack, @NotNull Action action) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        Intrinsics.checkNotNullParameter(capability, (String)"capability");
        Intrinsics.checkNotNullParameter(chemicalStack, (String)"chemicalStack");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (!tileEntity.getCapability(capability).isPresent()) {
            return chemicalStack;
        }
        return ((IChemicalHandler)tileEntity.getCapability(capability).resolve().get()).insertChemical(chemicalStack, action);
    }

    @Nullable
    public final <T extends IChemicalHandler<CHEMICAL, STACK>, CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> ChemicalStack<?> insertChemicalForCapability(@NotNull TileEntity tileEntity, @NotNull Direction side, @NotNull Capability<T> capability, @NotNull STACK chemicalStack, @NotNull Action action) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(capability, (String)"capability");
        Intrinsics.checkNotNullParameter(chemicalStack, (String)"chemicalStack");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (!tileEntity.getCapability(capability, side).isPresent()) {
            return this.insertChemicalForCapability(tileEntity, capability, chemicalStack, action);
        }
        return ((IChemicalHandler)tileEntity.getCapability(capability, side).resolve().get()).insertChemical(chemicalStack, action);
    }

    @Nullable
    public final ChemicalStack<?> extractChemical(@NotNull TileEntity tileEntity, @NotNull Direction side, long amount, @NotNull Action action) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Capability capability = Capabilities.GAS_HANDLER_CAPABILITY;
        Intrinsics.checkNotNullExpressionValue((Object)capability, (String)"GAS_HANDLER_CAPABILITY");
        ChemicalStack<?> gasStack = this.extractChemicalForCapability(tileEntity, side, capability, amount, action);
        if (gasStack != null && !gasStack.isEmpty()) {
            return gasStack;
        }
        Capability capability2 = Capabilities.SLURRY_HANDLER_CAPABILITY;
        Intrinsics.checkNotNullExpressionValue((Object)capability2, (String)"SLURRY_HANDLER_CAPABILITY");
        ChemicalStack<?> slurryStack = this.extractChemicalForCapability(tileEntity, side, capability2, amount, action);
        if (slurryStack != null && !slurryStack.isEmpty()) {
            return slurryStack;
        }
        Capability capability3 = Capabilities.INFUSION_HANDLER_CAPABILITY;
        Intrinsics.checkNotNullExpressionValue((Object)capability3, (String)"INFUSION_HANDLER_CAPABILITY");
        ChemicalStack<?> infusionStack = this.extractChemicalForCapability(tileEntity, side, capability3, amount, action);
        if (infusionStack != null && !infusionStack.isEmpty()) {
            return infusionStack;
        }
        Capability capability4 = Capabilities.PIGMENT_HANDLER_CAPABILITY;
        Intrinsics.checkNotNullExpressionValue((Object)capability4, (String)"PIGMENT_HANDLER_CAPABILITY");
        ChemicalStack<?> pigmentStack = this.extractChemicalForCapability(tileEntity, side, capability4, amount, action);
        if (pigmentStack != null && !pigmentStack.isEmpty()) {
            return pigmentStack;
        }
        return null;
    }

    @Nullable
    public final <T extends IChemicalHandler<?, ?>> ChemicalStack<?> extractChemicalForCapability(@NotNull TileEntity tileEntity, @NotNull Direction side, @NotNull Capability<T> capability, long amount, @NotNull Action action) {
        Intrinsics.checkNotNullParameter((Object)tileEntity, (String)"tileEntity");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter(capability, (String)"capability");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (!tileEntity.getCapability(capability, side).resolve().isPresent()) {
            return null;
        }
        return ((IChemicalHandler)tileEntity.getCapability(capability, side).resolve().get()).extractChemical(amount, action);
    }

    @NotNull
    public final ChemicalStack<?> getStackFromStack(@NotNull ChemicalStack<?> stack, long amount) {
        ChemicalStack chemicalStack;
        Intrinsics.checkNotNullParameter(stack, (String)"stack");
        ChemicalStack<?> chemicalStack2 = stack;
        if (chemicalStack2 instanceof SlurryStack) {
            chemicalStack = (ChemicalStack)new SlurryStack((SlurryStack)stack, amount);
        } else if (chemicalStack2 instanceof GasStack) {
            chemicalStack = (ChemicalStack)new GasStack((GasStack)stack, amount);
        } else if (chemicalStack2 instanceof InfusionStack) {
            chemicalStack = (ChemicalStack)new InfusionStack((InfusionStack)stack, amount);
        } else if (chemicalStack2 instanceof PigmentStack) {
            chemicalStack = (ChemicalStack)new PigmentStack((PigmentStack)stack, amount);
        } else {
            throw new RuntimeException("Invalid chemical type");
        }
        return chemicalStack;
    }
}

