/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.integration.mekanism.chemical;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.IStorageChannel;
import com.the9grounds.aeadditions.api.chemical.IAEChemicalStack;
import com.the9grounds.aeadditions.integration.mekanism.Mekanism;
import com.the9grounds.aeadditions.item.ChemicalDummyItem;
import com.the9grounds.aeadditions.registries.Items;
import com.the9grounds.aeadditions.util.StorageChannels;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.providers.IGasProvider;
import mekanism.api.providers.IInfuseTypeProvider;
import mekanism.api.providers.IPigmentProvider;
import mekanism.api.providers.ISlurryProvider;
import mekanism.common.util.ChemicalUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 @2\u00020\u0001:\u0001@B\u0013\b\u0016\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\b\u0016\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0015\b\u0016\u0012\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\fB\u000f\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fB\u0005\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0011\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0001H\u0096\u0002J\b\u0010\u001e\u001a\u00020\u0001H\u0016J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0006H\u0016J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0006H\u0016J\b\u0010\"\u001a\u00020\u0001H\u0016J\u0013\u0010#\u001a\u00020\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010$H\u0096\u0002J\u001c\u0010%\u001a\u00020\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u00012\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\u0016\u0010(\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030*0)H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00010,H\u0016J\f\u0010-\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0016J\f\u0010.\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\b\u0010/\u001a\u00020\u0006H\u0016J\b\u00100\u001a\u00020\u0006H\u0016J\b\u00101\u001a\u00020\u001cH\u0016J\u0010\u00102\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0006H\u0016J\u0010\u00103\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0006H\u0016J\b\u00104\u001a\u00020\u0015H\u0016J\b\u00105\u001a\u00020\u0015H\u0016J\b\u00106\u001a\u00020\u0001H\u0016J\u0010\u00107\u001a\u00020\u00012\u0006\u00108\u001a\u00020\u0006H\u0016J\u0010\u00109\u001a\u00020\u00012\u0006\u00104\u001a\u00020\u0015H\u0016J\u0010\u0010:\u001a\u00020\u00012\u0006\u0010;\u001a\u00020\u0006H\u0016J\u0010\u0010<\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u000eH\u0016J\u0010\u0010=\u001a\u00020\u00172\u0006\u0010>\u001a\u00020?H\u0016R\u0014\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/the9grounds/aeadditions/integration/mekanism/chemical/AEChemicalStack;", "Lcom/the9grounds/aeadditions/api/chemical/IAEChemicalStack;", "chemical", "Lmekanism/api/chemical/Chemical;", "(Lmekanism/api/chemical/Chemical;)V", "amount", "", "(Lmekanism/api/chemical/Chemical;J)V", "chemicalStack", "Lmekanism/api/chemical/ChemicalStack;", "(Lmekanism/api/chemical/ChemicalStack;)V", "oldStack", "(Lcom/the9grounds/aeadditions/integration/mekanism/chemical/AEChemicalStack;)V", "nbt", "Lnet/minecraft/nbt/CompoundNBT;", "(Lnet/minecraft/nbt/CompoundNBT;)V", "()V", "_chemical", "_countRequestable", "_stackSize", "canCraft", "", "add", "", "itemStack", "asItemStackRepresentation", "Lnet/minecraft/item/ItemStack;", "compareTo", "", "other", "copy", "decCountRequestable", "i", "decStackSize", "empty", "equals", "", "fuzzyComparison", "mode", "Lappeng/api/config/FuzzyMode;", "getCapabilityForChemical", "Ljava/util/Optional;", "Lmekanism/api/chemical/IChemicalHandler;", "getChannel", "Lappeng/api/storage/IStorageChannel;", "getChemical", "getChemicalStack", "getCountRequestable", "getStackSize", "hashCode", "incCountRequestable", "incStackSize", "isCraftable", "isMeaningful", "reset", "setCountRequestable", "countRequestable", "setCraftable", "setStackSize", "stackSize", "writeToNBT", "writeToPacket", "data", "Lnet/minecraft/network/PacketBuffer;", "Companion", "AEAdditions-1.16.5"})
public final class AEChemicalStack
implements IAEChemicalStack {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long _stackSize;
    @Nullable
    private Chemical<?> _chemical;
    private boolean canCraft;
    private long _countRequestable;

    public AEChemicalStack() {
    }

    public AEChemicalStack(@NotNull Chemical<?> chemical) {
        Intrinsics.checkNotNullParameter(chemical, (String)"chemical");
        this();
        this._chemical = chemical;
    }

    public AEChemicalStack(@NotNull Chemical<?> chemical, long amount) {
        Intrinsics.checkNotNullParameter(chemical, (String)"chemical");
        this();
        this._chemical = chemical;
        this._stackSize = amount;
    }

    public AEChemicalStack(@Nullable ChemicalStack<?> chemicalStack) {
        this();
        if (chemicalStack == null || chemicalStack.getType() == null) {
            throw new IllegalArgumentException("Chemical is null");
        }
        this._chemical = chemicalStack.getType();
        this._stackSize = chemicalStack.getAmount();
        this.canCraft = false;
        this._countRequestable = 0L;
    }

    public AEChemicalStack(@NotNull AEChemicalStack oldStack) {
        Intrinsics.checkNotNullParameter((Object)oldStack, (String)"oldStack");
        this();
        this._chemical = oldStack.getChemical();
        this.canCraft = oldStack.isCraftable();
        this._stackSize = oldStack.getStackSize();
        this._countRequestable = oldStack.getCountRequestable();
    }

    public AEChemicalStack(@NotNull CompoundNBT nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        this();
        this._chemical = Mekanism.INSTANCE.readChemicalFromNbt(nbt);
        this.canCraft = nbt.func_74767_n("isCraftable");
        this._stackSize = nbt.func_74763_f("stackSize");
        this._countRequestable = nbt.func_74763_f("countRequestable");
    }

    @Override
    @NotNull
    public ChemicalStack<?> getChemicalStack() {
        ChemicalStack chemicalStack;
        Chemical<?> chemical = this._chemical;
        if (chemical instanceof Gas) {
            Chemical<?> chemical2 = this._chemical;
            if (chemical2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type mekanism.api.chemical.gas.Gas");
            }
            chemicalStack = (ChemicalStack)new GasStack((IGasProvider)((Gas)chemical2), this.getStackSize());
        } else if (chemical instanceof Slurry) {
            Chemical<?> chemical3 = this._chemical;
            if (chemical3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type mekanism.api.chemical.slurry.Slurry");
            }
            chemicalStack = (ChemicalStack)new SlurryStack((ISlurryProvider)((Slurry)chemical3), this.getStackSize());
        } else if (chemical instanceof InfuseType) {
            Chemical<?> chemical4 = this._chemical;
            if (chemical4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type mekanism.api.chemical.infuse.InfuseType");
            }
            chemicalStack = (ChemicalStack)new InfusionStack((IInfuseTypeProvider)((InfuseType)chemical4), this.getStackSize());
        } else if (chemical instanceof Pigment) {
            Chemical<?> chemical5 = this._chemical;
            if (chemical5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type mekanism.api.chemical.pigment.Pigment");
            }
            chemicalStack = (ChemicalStack)new PigmentStack((IPigmentProvider)((Pigment)chemical5), this.getStackSize());
        } else {
            throw new RuntimeException("Received invalid chemical");
        }
        return chemicalStack;
    }

    @Override
    @NotNull
    public Chemical<?> getChemical() {
        Chemical<?> chemical = this._chemical;
        Intrinsics.checkNotNull(chemical);
        return chemical;
    }

    public void add(@Nullable IAEChemicalStack itemStack) {
        if (itemStack == null) {
            return;
        }
        this.incStackSize(itemStack.getStackSize());
        AEChemicalStack aEChemicalStack = this;
        aEChemicalStack.setCountRequestable(aEChemicalStack.getCountRequestable() + itemStack.getCountRequestable());
        this.setCraftable(this.isCraftable() || itemStack.isCraftable());
    }

    public long getStackSize() {
        return this._stackSize;
    }

    @NotNull
    public IAEChemicalStack setStackSize(long stackSize) {
        this._stackSize = stackSize;
        return this;
    }

    public long getCountRequestable() {
        return this._countRequestable;
    }

    @NotNull
    public IAEChemicalStack setCountRequestable(long countRequestable) {
        this._countRequestable = countRequestable;
        return this;
    }

    public boolean isCraftable() {
        return this.canCraft;
    }

    @NotNull
    public IAEChemicalStack setCraftable(boolean isCraftable) {
        this.canCraft = isCraftable;
        return this;
    }

    @NotNull
    public IAEChemicalStack reset() {
        this.canCraft = false;
        this._stackSize = 0L;
        this._countRequestable = 0L;
        return this;
    }

    public boolean isMeaningful() {
        return this.getStackSize() != 0L || this.getCountRequestable() > 0L || this.isCraftable();
    }

    public void incStackSize(long i) {
        AEChemicalStack aEChemicalStack = this;
        aEChemicalStack._stackSize += i;
    }

    public void decStackSize(long i) {
        AEChemicalStack aEChemicalStack = this;
        aEChemicalStack._stackSize -= i;
    }

    public void incCountRequestable(long i) {
        AEChemicalStack aEChemicalStack = this;
        aEChemicalStack._countRequestable += i;
    }

    public void decCountRequestable(long i) {
        AEChemicalStack aEChemicalStack = this;
        aEChemicalStack._countRequestable -= i;
    }

    public void writeToNBT(@NotNull CompoundNBT i) {
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        Chemical<?> chemical = this._chemical;
        Intrinsics.checkNotNull(chemical);
        chemical.write(i);
        chemical = this._chemical;
        Intrinsics.checkNotNull(chemical);
        i.func_74778_a("chemicalType", Mekanism.INSTANCE.getType(chemical));
        i.func_74757_a("isCraftable", this.isCraftable());
        i.func_74772_a("stackSize", this._stackSize);
        i.func_74772_a("countRequestable", this._countRequestable);
    }

    public boolean fuzzyComparison(@Nullable IAEChemicalStack other, @Nullable FuzzyMode mode) {
        return other != null && Intrinsics.areEqual(this.getChemical(), other.getChemical());
    }

    public void writeToPacket(@NotNull PacketBuffer data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Chemical<?> chemical = this._chemical;
        Intrinsics.checkNotNull(chemical);
        data.func_180714_a(Mekanism.INSTANCE.getType(chemical));
        chemical = this._chemical;
        Intrinsics.checkNotNull(chemical);
        data.func_180714_a(String.valueOf(chemical.getRegistryName()));
        data.writeBoolean(this.isCraftable());
        data.writeLong(this.getStackSize());
        data.writeLong(this.getCountRequestable());
    }

    @NotNull
    public IAEChemicalStack copy() {
        return new AEChemicalStack(this);
    }

    @NotNull
    public IAEChemicalStack empty() {
        IAEChemicalStack copy = this.copy();
        copy.reset();
        return copy;
    }

    @NotNull
    public IStorageChannel<IAEChemicalStack> getChannel() {
        IStorageChannel<IAEChemicalStack> iStorageChannel = StorageChannels.INSTANCE.getCHEMICAL();
        Intrinsics.checkNotNull(iStorageChannel);
        return iStorageChannel;
    }

    @NotNull
    public ItemStack asItemStackRepresentation() {
        ItemStack itemStack = new ItemStack((IItemProvider)Items.INSTANCE.getDUMMY_CHEMICAL_ITEM());
        if (!itemStack.func_190926_b()) {
            Item item2 = itemStack.func_77973_b();
            if (item2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.the9grounds.aeadditions.item.ChemicalDummyItem");
            }
            ChemicalDummyItem item3 = (ChemicalDummyItem)item2;
            item3.setChemicalStack(itemStack, this.getChemicalStack());
            return itemStack;
        }
        ItemStack itemStack2 = ItemStack.field_190927_a;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
        return itemStack2;
    }

    @Override
    @NotNull
    public Optional<IChemicalHandler<?, ?>> getCapabilityForChemical() {
        Optional optional = this.asItemStackRepresentation().getCapability(ChemicalUtil.getCapabilityForChemical(this._chemical)).resolve();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"asItemStackRepresentation().getCapability(ChemicalUtil.getCapabilityForChemical(_chemical)).resolve()");
        return optional;
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
            return false;
        }
        if (other == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.the9grounds.aeadditions.integration.mekanism.chemical.AEChemicalStack");
        }
        AEChemicalStack cfr_ignored_0 = (AEChemicalStack)other;
        if (!Intrinsics.areEqual(this._chemical, ((AEChemicalStack)other)._chemical)) {
            return false;
        }
        if (this.canCraft != ((AEChemicalStack)other).canCraft) {
            return false;
        }
        return this._countRequestable == ((AEChemicalStack)other)._countRequestable;
    }

    public int hashCode() {
        int n;
        Chemical<?> chemical = this._chemical;
        return chemical == null ? 0 : (n = chemical.hashCode());
    }

    @Override
    public int compareTo(@NotNull IAEChemicalStack other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getStackSize() == other.getStackSize() ? 0 : (this.getStackSize() > other.getStackSize() ? -1 : 1);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/the9grounds/aeadditions/integration/mekanism/chemical/AEChemicalStack$Companion;", "", "()V", "fromPacket", "Lcom/the9grounds/aeadditions/api/chemical/IAEChemicalStack;", "packet", "Lnet/minecraft/network/PacketBuffer;", "AEAdditions-1.16.5"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IAEChemicalStack fromPacket(@NotNull PacketBuffer packet) {
            Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
            Chemical<?> chemical = Mekanism.INSTANCE.readChemicalFromPacket(packet);
            boolean isCraftable = packet.readBoolean();
            long stackSize = packet.readLong();
            long countRequestable = packet.readLong();
            AEChemicalStack chemicalStack = new AEChemicalStack(chemical);
            chemicalStack.setCraftable(isCraftable);
            chemicalStack.setStackSize(stackSize);
            chemicalStack.setCountRequestable(countRequestable);
            return chemicalStack;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

