/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.item.storage;

import appeng.api.IAppEngApi;
import appeng.api.client.IClientHelper;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.data.IAEStack;
import appeng.items.contents.CellConfig;
import appeng.items.contents.CellUpgrades;
import com.the9grounds.aeadditions.api.IAEAdditionsStorageCell;
import com.the9grounds.aeadditions.integration.appeng.AppEng;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0017J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010$\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0014H\u0016J\u0012\u0010%\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0014H\u0016J\u001d\u0010&\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u00142\u0006\u0010(\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010)J\u0012\u0010*\u001a\u00020'2\b\u0010 \u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020\u0014H\u0016J\u001c\u0010-\u001a\u00020\u00122\b\u0010#\u001a\u0004\u0018\u00010\u00142\b\u0010.\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010/\u001a\u00020'H\u0016R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/the9grounds/aeadditions/item/storage/AbstractStorageCell;", "T", "Lappeng/api/storage/data/IAEStack;", "Lnet/minecraft/item/Item;", "Lcom/the9grounds/aeadditions/api/IAEAdditionsStorageCell;", "props", "Lnet/minecraft/item/Item$Properties;", "component", "kiloBytes", "", "numberOfTypes", "(Lnet/minecraft/item/Item$Properties;Lnet/minecraft/item/Item;II)V", "getComponent", "()Lnet/minecraft/item/Item;", "getNumberOfTypes", "()I", "totalBytes", "addInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "worldIn", "Lnet/minecraft/world/World;", "tooltip", "", "Lnet/minecraft/util/text/ITextComponent;", "flagIn", "Lnet/minecraft/client/util/ITooltipFlag;", "getBytes", "cellItem", "getConfigInventory", "Lnet/minecraftforge/items/IItemHandler;", "is", "getFuzzyMode", "Lappeng/api/config/FuzzyMode;", "itemStack", "getTotalTypes", "getUpgradesInventory", "isBlackListed", "", "requestedAddition", "(Lnet/minecraft/item/ItemStack;Lappeng/api/storage/data/IAEStack;)Z", "isEditable", "isStorageCell", "i", "setFuzzyMode", "fzMode", "storableInStorageCell", "AEAdditions-1.16.5"})
public abstract class AbstractStorageCell<T extends IAEStack<T>>
extends Item
implements IAEAdditionsStorageCell<T> {
    @NotNull
    private final Item component;
    private final int numberOfTypes;
    private final int totalBytes;

    public AbstractStorageCell(@NotNull Item.Properties props, @NotNull Item component, int kiloBytes, int numberOfTypes) {
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        super(props);
        this.component = component;
        this.numberOfTypes = numberOfTypes;
        this.totalBytes = kiloBytes * 1024;
    }

    @NotNull
    public final Item getComponent() {
        return this.component;
    }

    public final int getNumberOfTypes() {
        return this.numberOfTypes;
    }

    public boolean isEditable(@Nullable ItemStack is) {
        return true;
    }

    @NotNull
    public IItemHandler getUpgradesInventory(@Nullable ItemStack is) {
        return (IItemHandler)new CellUpgrades(is, 2);
    }

    @NotNull
    public IItemHandler getConfigInventory(@Nullable ItemStack is) {
        return (IItemHandler)new CellConfig(is);
    }

    @NotNull
    public FuzzyMode getFuzzyMode(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return FuzzyMode.IGNORE_ALL;
        }
        String fuzzy = itemStack.func_196082_o().func_74779_i("FuzzyMode");
        Intrinsics.checkNotNullExpressionValue((Object)fuzzy, (String)"fuzzy");
        CharSequence charSequence = fuzzy;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return FuzzyMode.IGNORE_ALL;
        }
        try {
            charSequence = FuzzyMode.valueOf((String)fuzzy);
        }
        catch (Throwable e) {
            charSequence = FuzzyMode.IGNORE_ALL;
        }
        return charSequence;
    }

    public void setFuzzyMode(@Nullable ItemStack itemStack, @Nullable FuzzyMode fzMode) {
        CompoundNBT compoundNBT;
        ItemStack itemStack2 = itemStack;
        if (itemStack2 != null && (compoundNBT = itemStack2.func_196082_o()) != null) {
            Intrinsics.checkNotNull((Object)fzMode);
            compoundNBT.func_74778_a("FuzzyMode", fzMode.name());
        }
    }

    @Override
    public int getBytes(@NotNull ItemStack cellItem) {
        Intrinsics.checkNotNullParameter((Object)cellItem, (String)"cellItem");
        return this.totalBytes;
    }

    @Override
    public int getTotalTypes(@NotNull ItemStack cellItem) {
        Intrinsics.checkNotNullParameter((Object)cellItem, (String)"cellItem");
        return this.numberOfTypes;
    }

    @Override
    public boolean isBlackListed(@NotNull ItemStack cellItem, @NotNull T requestedAddition) {
        Intrinsics.checkNotNullParameter((Object)cellItem, (String)"cellItem");
        Intrinsics.checkNotNullParameter(requestedAddition, (String)"requestedAddition");
        return false;
    }

    @Override
    public boolean storableInStorageCell() {
        return false;
    }

    @Override
    public boolean isStorageCell(@NotNull ItemStack i) {
        Intrinsics.checkNotNullParameter((Object)i, (String)"i");
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World worldIn, @NotNull List<ITextComponent> tooltip, @NotNull ITooltipFlag flagIn) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)flagIn, (String)"flagIn");
        if (AppEng.Companion.getAPI() == null) {
            return;
        }
        IAppEngApi iAppEngApi = AppEng.Companion.getAPI();
        Intrinsics.checkNotNull((Object)iAppEngApi);
        IClientHelper iClientHelper = iAppEngApi.client();
        iAppEngApi = AppEng.Companion.getAPI();
        Intrinsics.checkNotNull((Object)iAppEngApi);
        iClientHelper.addCellInformation(iAppEngApi.registries().cell().getCellInventory(stack, null, this.getChannel()), tooltip);
    }
}

