/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.me.storage;

import appeng.api.config.Actionable;
import appeng.api.exceptions.AppEngException;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.cells.ICellInventory;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.core.AELog;
import com.the9grounds.aeadditions.LoggerKt;
import com.the9grounds.aeadditions.api.IAEAdditionsStorageCell;
import com.the9grounds.aeadditions.me.storage.AbstractAEAdditionsInventory;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000  *\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001 B%\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ'\u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0016J'\u0010\u0016\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0017\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u001a\u0010\u001b\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006!"}, d2={"Lcom/the9grounds/aeadditions/me/storage/AEAdditionsCellInventory;", "T", "Lappeng/api/storage/data/IAEStack;", "Lcom/the9grounds/aeadditions/me/storage/AbstractAEAdditionsInventory;", "cell", "Lcom/the9grounds/aeadditions/api/IAEAdditionsStorageCell;", "itemStack", "Lnet/minecraft/item/ItemStack;", "container", "Lappeng/api/storage/cells/ISaveProvider;", "(Lcom/the9grounds/aeadditions/api/IAEAdditionsStorageCell;Lnet/minecraft/item/ItemStack;Lappeng/api/storage/cells/ISaveProvider;)V", "getCell", "()Lcom/the9grounds/aeadditions/api/IAEAdditionsStorageCell;", "extractItems", "request", "mode", "Lappeng/api/config/Actionable;", "src", "Lappeng/api/networking/security/IActionSource;", "(Lappeng/api/storage/data/IAEStack;Lappeng/api/config/Actionable;Lappeng/api/networking/security/IActionSource;)Lappeng/api/storage/data/IAEStack;", "getChannel", "Lappeng/api/storage/IStorageChannel;", "injectItems", "input", "isStorageCell", "", "(Lappeng/api/storage/data/IAEStack;)Z", "loadCellItem", "compoundTag", "Lnet/minecraft/nbt/CompoundNBT;", "stackSize", "", "Companion", "AEAdditions-1.16.5"})
public final class AEAdditionsCellInventory<T extends IAEStack<T>>
extends AbstractAEAdditionsInventory<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IAEAdditionsStorageCell<T> cell;

    public AEAdditionsCellInventory(@NotNull IAEAdditionsStorageCell<T> cell, @NotNull ItemStack itemStack, @Nullable ISaveProvider container) {
        Intrinsics.checkNotNullParameter(cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        super(cell, itemStack, container);
        this.cell = cell;
    }

    @NotNull
    public final IAEAdditionsStorageCell<T> getCell() {
        return this.cell;
    }

    @Override
    protected boolean loadCellItem(@Nullable CompoundNBT compoundTag, long stackSize) {
        IAEStack t = null;
        IStorageChannel<T> iStorageChannel = this.getChannel();
        Intrinsics.checkNotNull((Object)compoundTag);
        t = iStorageChannel.createFromNBT(compoundTag);
        if (t == null) {
            LoggerKt.getLogger().warn("Removing item " + compoundTag + " from storage cell because the associated item type couldn't be found.");
            return false;
        }
        t.setStackSize(stackSize);
        if (stackSize > 0L) {
            IItemList iItemList = this.getCellItems();
            Intrinsics.checkNotNull(iItemList);
            iItemList.add(t);
        }
        return true;
    }

    @Nullable
    public T injectItems(@NotNull T input, @NotNull Actionable mode, @NotNull IActionSource src) {
        long remainingItemCount;
        IItemList iItemList;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (input.getStackSize() == 0L) {
            return null;
        }
        IAEAdditionsStorageCell<T> iAEAdditionsStorageCell = this.getCellType();
        Intrinsics.checkNotNull(iAEAdditionsStorageCell);
        if (iAEAdditionsStorageCell.isBlackListed(this.getItemStack(), input)) {
            return input;
        }
        if (this.isStorageCell(input)) {
            ItemStack itemStack = ((IAEItemStack)input).createItemStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"input as IAEItemStack).createItemStack()");
            iItemList = Companion.createInventory(itemStack, null);
            Intrinsics.checkNotNull(iItemList);
            IItemList meInventory = iItemList;
            if (!AEAdditionsCellInventory.Companion.isCellEmpty(meInventory)) {
                return input;
            }
        }
        iItemList = this.getCellItems();
        Intrinsics.checkNotNull(iItemList);
        IAEStack l = iItemList.findPrecise(input);
        if (l != null) {
            IAEStack iAEStack;
            long remainingItemCount2 = this.getRemainingItemCount();
            if (remainingItemCount2 <= 0L) {
                return input;
            }
            if (input.getStackSize() > remainingItemCount2) {
                IAEStack r = input.copy();
                r.setStackSize(r.getStackSize() - remainingItemCount2);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() + remainingItemCount2);
                    this.saveChanges();
                }
                iAEStack = r;
            } else {
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() + input.getStackSize());
                    this.saveChanges();
                }
                iAEStack = null;
            }
            return (T)iAEStack;
        }
        if (this.canHoldNewItem() && (remainingItemCount = this.getRemainingItemCount() - (long)(this.getBytesPerType() * this.getItemsPerByte())) > 0L) {
            if (input.getStackSize() > remainingItemCount) {
                IAEStack toReturn = input.copy();
                toReturn.setStackSize(input.getStackSize() - remainingItemCount);
                if (mode == Actionable.MODULATE) {
                    IAEStack toWrite = input.copy();
                    toWrite.setStackSize(remainingItemCount);
                    IItemList iItemList2 = this.getCellItems();
                    Intrinsics.checkNotNull(iItemList2);
                    iItemList2.add(toWrite);
                    this.saveChanges();
                }
                return (T)toReturn;
            }
            if (mode == Actionable.MODULATE) {
                IItemList iItemList3 = this.getCellItems();
                Intrinsics.checkNotNull(iItemList3);
                iItemList3.add(input);
                this.saveChanges();
            }
            return null;
        }
        return input;
    }

    @Nullable
    public T extractItems(@NotNull T request, @NotNull Actionable mode, @NotNull IActionSource src) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        long size = Math.min(Integer.MAX_VALUE, request.getStackSize());
        IAEStack results = null;
        IItemList iItemList = this.getCellItems();
        Intrinsics.checkNotNull(iItemList);
        IAEStack l = iItemList.findPrecise(request);
        if (l != null) {
            results = l.copy();
            if (l.getStackSize() <= size) {
                results.setStackSize(l.getStackSize());
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(0L);
                    this.saveChanges();
                }
            } else {
                results.setStackSize(size);
                if (mode == Actionable.MODULATE) {
                    l.setStackSize(l.getStackSize() - size);
                    this.saveChanges();
                }
            }
        }
        return (T)results;
    }

    @NotNull
    public IStorageChannel<T> getChannel() {
        return this.cell.getChannel();
    }

    private final boolean isStorageCell(T input) {
        if (input instanceof IAEItemStack) {
            IAEItemStack stack = (IAEItemStack)input;
            IAEAdditionsStorageCell type = AEAdditionsCellInventory.Companion.getStorageCell(stack.getDefinition());
            return type != null && !type.storableInStorageCell();
        }
        return false;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\u0004\"\u000e\b\u0001\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0018\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\r\u001a\u0004\u0018\u00010\bJ(\u0010\u0010\u001a\u00020\u000f\"\u000e\b\u0001\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u00062\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\u0004H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/the9grounds/aeadditions/me/storage/AEAdditionsCellInventory$Companion;", "", "()V", "createInventory", "Lappeng/api/storage/cells/ICellInventory;", "T", "Lappeng/api/storage/data/IAEStack;", "itemStack", "Lnet/minecraft/item/ItemStack;", "container", "Lappeng/api/storage/cells/ISaveProvider;", "getStorageCell", "Lcom/the9grounds/aeadditions/api/IAEAdditionsStorageCell;", "input", "isCell", "", "isCellEmpty", "inv", "AEAdditions-1.16.5"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isCell(@Nullable ItemStack input) {
            return this.getStorageCell(input) != null;
        }

        private final IAEAdditionsStorageCell<?> getStorageCell(ItemStack input) {
            Item type;
            if (input != null && (type = input.func_77973_b()) instanceof IAEAdditionsStorageCell) {
                return (IAEAdditionsStorageCell)type;
            }
            return null;
        }

        private final <T extends IAEStack<T>> boolean isCellEmpty(ICellInventory<T> inv) {
            boolean bl;
            ICellInventory<T> iCellInventory = inv;
            IItemList iItemList = iCellInventory == null ? null : iCellInventory.getAvailableItems(inv.getChannel().createList());
            return iItemList == null ? true : (bl = iItemList.isEmpty());
        }

        @Nullable
        public final <T extends IAEStack<T>> ICellInventory<T> createInventory(@NotNull ItemStack itemStack, @Nullable ISaveProvider container) {
            ICellInventory iCellInventory;
            Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
            try {
                Item item2 = itemStack.func_77973_b();
                Intrinsics.checkNotNullExpressionValue((Object)item2, (String)"itemStack.getItem()");
                Item type = item2;
                IAEAdditionsStorageCell cellType = null;
                if (!(type instanceof IAEAdditionsStorageCell)) {
                    throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
                }
                cellType = (IAEAdditionsStorageCell)type;
                if (!cellType.isStorageCell(itemStack)) {
                    throw new AppEngException("ItemStack was used as a cell, but was not a cell!");
                }
                iCellInventory = new AEAdditionsCellInventory(cellType, itemStack, container);
            }
            catch (AppEngException e) {
                AELog.error((Throwable)e);
                iCellInventory = null;
            }
            return iCellInventory;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

