/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.me.storage;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ICellInventory;
import appeng.api.storage.cells.ISaveProvider;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.the9grounds.aeadditions.api.IAEAdditionsStorageCell;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 D*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001DB'\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\b\u0010&\u001a\u00020\u0016H\u0016J\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016J\b\u0010)\u001a\u00020\u001aH\u0016J\n\u0010*\u001a\u0004\u0018\u00010+H\u0016J\b\u0010,\u001a\u00020!H\u0016J\n\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020\u0007H\u0016J\b\u00102\u001a\u00020!H\u0016J\b\u00103\u001a\u00020!H\u0016J\n\u00104\u001a\u0004\u0018\u000105H\u0016J\b\u00106\u001a\u00020!H\u0016J\b\u00107\u001a\u00020!H\u0016J\b\u00108\u001a\u00020!H\u0016J\b\u00109\u001a\u00020!H\u0016J\b\u0010:\u001a\u00020\u001aH\u0016J\n\u0010;\u001a\u0004\u0018\u00010+H\u0016J\b\u0010<\u001a\u00020!H\u0016J\u001a\u0010=\u001a\u00020\u00162\b\u0010>\u001a\u0004\u0018\u00010%2\u0006\u0010?\u001a\u00020!H$J\b\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020AH\u0016J\b\u0010C\u001a\u00020AH\u0014R$\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\f8DX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lcom/the9grounds/aeadditions/me/storage/AbstractAEAdditionsInventory;", "T", "Lappeng/api/storage/data/IAEStack;", "Lappeng/api/storage/cells/ICellInventory;", "cellType", "Lcom/the9grounds/aeadditions/api/IAEAdditionsStorageCell;", "itemStackLocal", "Lnet/minecraft/item/ItemStack;", "container", "Lappeng/api/storage/cells/ISaveProvider;", "(Lcom/the9grounds/aeadditions/api/IAEAdditionsStorageCell;Lnet/minecraft/item/ItemStack;Lappeng/api/storage/cells/ISaveProvider;)V", "cellItems", "Lappeng/api/storage/data/IItemList;", "getCellItems", "()Lappeng/api/storage/data/IItemList;", "setCellItems", "(Lappeng/api/storage/data/IItemList;)V", "getCellType", "()Lcom/the9grounds/aeadditions/api/IAEAdditionsStorageCell;", "getContainer", "()Lappeng/api/storage/cells/ISaveProvider;", "isPersisted", "", "getItemStackLocal", "()Lnet/minecraft/item/ItemStack;", "itemsPerByte", "", "getItemsPerByte", "()I", "setItemsPerByte", "(I)V", "maxItemTypes", "storedItemCount", "", "storedItems", "", "tagCompound", "Lnet/minecraft/nbt/CompoundNBT;", "canHoldNewItem", "getAvailableItems", "out", "getBytesPerType", "getConfigInventory", "Lnet/minecraftforge/items/IItemHandler;", "getFreeBytes", "getFuzzyMode", "Lappeng/api/config/FuzzyMode;", "getIdleDrain", "", "getItemStack", "getRemainingItemCount", "getRemainingItemTypes", "getStatusForCell", "Lappeng/api/storage/cells/CellState;", "getStoredItemCount", "getStoredItemTypes", "getTotalBytes", "getTotalItemTypes", "getUnusedItemCount", "getUpgradesInventory", "getUsedBytes", "loadCellItem", "compoundTag", "stackSize", "loadCellItems", "", "persist", "saveChanges", "Companion", "AEAdditions-1.16.5"})
public abstract class AbstractAEAdditionsInventory<T extends IAEStack<T>>
implements ICellInventory<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final IAEAdditionsStorageCell<T> cellType;
    @NotNull
    private final ItemStack itemStackLocal;
    @Nullable
    private final ISaveProvider container;
    @Nullable
    private CompoundNBT tagCompound;
    private int maxItemTypes;
    private short storedItems;
    private long storedItemCount;
    @Nullable
    private IItemList<T> cellItems;
    private int itemsPerByte;
    private boolean isPersisted;
    private static final int MAX_ITEM_TYPES = 63;
    @NotNull
    private static final String ITEM_TYPE_TAG = "it";
    @NotNull
    private static final String ITEM_COUNT_TAG = "ic";
    @NotNull
    private static final String ITEM_SLOT = "#";
    @NotNull
    private static final String ITEM_SLOT_COUNT = "@";
    @NotNull
    private static final String ITEM_PRE_FORMATTED_COUNT = "PF";
    @NotNull
    private static final String ITEM_PRE_FORMATTED_SLOT = "PF#";
    @NotNull
    private static final String ITEM_PRE_FORMATTED_NAME = "PN";
    @NotNull
    private static final String ITEM_PRE_FORMATTED_FUZZY = "FP";
    @NotNull
    private static final String[] ITEM_SLOT_KEYS = new String[MAX_ITEM_TYPES];
    @NotNull
    private static final String[] ITEM_SLOT_COUNT_KEYS = new String[MAX_ITEM_TYPES];

    public AbstractAEAdditionsInventory(@Nullable IAEAdditionsStorageCell<T> cellType, @NotNull ItemStack itemStackLocal, @Nullable ISaveProvider container) {
        Intrinsics.checkNotNullParameter((Object)itemStackLocal, (String)"itemStackLocal");
        this.cellType = cellType;
        this.itemStackLocal = itemStackLocal;
        this.container = container;
        this.maxItemTypes = MAX_ITEM_TYPES;
        this.isPersisted = true;
        CompoundNBT compoundNBT = this.cellType;
        Intrinsics.checkNotNull(compoundNBT);
        this.itemsPerByte = compoundNBT.getChannel().getUnitsPerByte();
        compoundNBT = this.cellType;
        Intrinsics.checkNotNull(compoundNBT);
        this.maxItemTypes = compoundNBT.getTotalTypes(this.itemStackLocal);
        if (this.maxItemTypes > MAX_ITEM_TYPES) {
            this.maxItemTypes = MAX_ITEM_TYPES;
        }
        if (this.maxItemTypes < 1) {
            this.maxItemTypes = 1;
        }
        compoundNBT = this.tagCompound = this.getItemStack().func_196082_o();
        Intrinsics.checkNotNull((Object)compoundNBT);
        this.storedItems = compoundNBT.func_74765_d(ITEM_TYPE_TAG);
        compoundNBT = this.tagCompound;
        Intrinsics.checkNotNull((Object)compoundNBT);
        this.storedItemCount = compoundNBT.func_74763_f(ITEM_COUNT_TAG);
        this.cellItems = null;
    }

    @Nullable
    public final IAEAdditionsStorageCell<T> getCellType() {
        return this.cellType;
    }

    @NotNull
    public final ItemStack getItemStackLocal() {
        return this.itemStackLocal;
    }

    @Nullable
    public final ISaveProvider getContainer() {
        return this.container;
    }

    @Nullable
    protected final IItemList<T> getCellItems() {
        if (this.cellItems == null) {
            this.cellItems = this.getChannel().createList();
            this.loadCellItems();
        }
        return this.cellItems;
    }

    protected final void setCellItems(@Nullable IItemList<T> iItemList) {
        this.cellItems = iItemList;
    }

    protected final int getItemsPerByte() {
        return this.itemsPerByte;
    }

    protected final void setItemsPerByte(int n) {
        this.itemsPerByte = n;
    }

    public void persist() {
        if (this.isPersisted) {
            return;
        }
        long itemCount = 0L;
        int x = 0;
        CompoundNBT compoundNBT = this.getCellItems();
        Intrinsics.checkNotNull(compoundNBT);
        for (IAEStack v : compoundNBT) {
            itemCount += v.getStackSize();
            CompoundNBT g = new CompoundNBT();
            v.writeToNBT(g);
            CompoundNBT compoundNBT2 = this.tagCompound;
            Intrinsics.checkNotNull((Object)compoundNBT2);
            compoundNBT2.func_218657_a(ITEM_SLOT_KEYS[x], (INBT)g);
            compoundNBT2 = this.tagCompound;
            Intrinsics.checkNotNull((Object)compoundNBT2);
            compoundNBT2.func_74772_a(ITEM_SLOT_COUNT_KEYS[x], v.getStackSize());
            int n = x;
            x = n + 1;
        }
        int oldStoredItems = this.storedItems;
        compoundNBT = this.getCellItems();
        Intrinsics.checkNotNull(compoundNBT);
        this.storedItems = (short)compoundNBT.size();
        compoundNBT = this.getCellItems();
        Intrinsics.checkNotNull(compoundNBT);
        if (compoundNBT.isEmpty()) {
            compoundNBT = this.tagCompound;
            Intrinsics.checkNotNull((Object)compoundNBT);
            compoundNBT.func_82580_o(ITEM_TYPE_TAG);
        } else {
            compoundNBT = this.tagCompound;
            Intrinsics.checkNotNull((Object)compoundNBT);
            compoundNBT.func_74777_a(ITEM_TYPE_TAG, this.storedItems);
        }
        this.storedItemCount = itemCount;
        if (itemCount == 0L) {
            compoundNBT = this.tagCompound;
            Intrinsics.checkNotNull((Object)compoundNBT);
            compoundNBT.func_82580_o(ITEM_COUNT_TAG);
        } else {
            compoundNBT = this.tagCompound;
            Intrinsics.checkNotNull((Object)compoundNBT);
            compoundNBT.func_74772_a(ITEM_COUNT_TAG, itemCount);
        }
        while (x < oldStoredItems && x < this.maxItemTypes) {
            compoundNBT = this.tagCompound;
            Intrinsics.checkNotNull((Object)compoundNBT);
            compoundNBT.func_82580_o(ITEM_SLOT_KEYS[x]);
            compoundNBT = this.tagCompound;
            Intrinsics.checkNotNull((Object)compoundNBT);
            compoundNBT.func_82580_o(ITEM_SLOT_COUNT_KEYS[x]);
            int n = x;
            x = n + 1;
        }
        this.isPersisted = true;
    }

    protected void saveChanges() {
        Object object = this.getCellItems();
        Intrinsics.checkNotNull(object);
        this.storedItems = (short)object.size();
        this.storedItemCount = 0L;
        IItemList<T> iItemList = this.getCellItems();
        Intrinsics.checkNotNull(iItemList);
        for (IAEStack v : iItemList) {
            AbstractAEAdditionsInventory abstractAEAdditionsInventory = this;
            abstractAEAdditionsInventory.storedItemCount += (long)((int)v.getStackSize());
        }
        this.isPersisted = false;
        if (this.container != null) {
            object = this.container;
            Intrinsics.checkNotNull((Object)object);
            object.saveChanges((ICellInventory)this);
        } else {
            this.persist();
        }
    }

    public void loadCellItems() {
        if (this.getCellItems() == null) {
            this.cellItems = this.getChannel().createList();
        }
        IItemList<T> iItemList = this.getCellItems();
        Intrinsics.checkNotNull(iItemList);
        iItemList.resetStatus();
        int types = (int)this.getStoredItemTypes();
        boolean needsUpdate = false;
        int n = 0;
        if (n < types) {
            do {
                int slot = n++;
                CompoundNBT compoundNBT = this.tagCompound;
                Intrinsics.checkNotNull((Object)compoundNBT);
                CompoundNBT compoundTag = compoundNBT.func_74775_l(ITEM_SLOT_KEYS[slot]);
                CompoundNBT compoundNBT2 = this.tagCompound;
                Intrinsics.checkNotNull((Object)compoundNBT2);
                long stackSize = compoundNBT2.func_74763_f(ITEM_SLOT_COUNT_KEYS[slot]);
                needsUpdate |= !this.loadCellItem(compoundTag, stackSize);
            } while (n < types);
        }
        if (needsUpdate) {
            this.saveChanges();
        }
    }

    protected abstract boolean loadCellItem(@Nullable CompoundNBT var1, long var2);

    @NotNull
    public IItemList<T> getAvailableItems(@NotNull IItemList<T> out) {
        Intrinsics.checkNotNullParameter(out, (String)"out");
        IItemList<T> iItemList = this.getCellItems();
        Intrinsics.checkNotNull(iItemList);
        for (IAEStack item2 : iItemList) {
            out.add(item2);
        }
        return out;
    }

    @NotNull
    public ItemStack getItemStack() {
        return this.itemStackLocal;
    }

    public double getIdleDrain() {
        IAEAdditionsStorageCell<T> iAEAdditionsStorageCell = this.cellType;
        Intrinsics.checkNotNull(iAEAdditionsStorageCell);
        return iAEAdditionsStorageCell.getIdleDrain();
    }

    @Nullable
    public FuzzyMode getFuzzyMode() {
        IAEAdditionsStorageCell<T> iAEAdditionsStorageCell = this.cellType;
        Intrinsics.checkNotNull(iAEAdditionsStorageCell);
        return iAEAdditionsStorageCell.getFuzzyMode(this.itemStackLocal);
    }

    @Nullable
    public IItemHandler getConfigInventory() {
        IAEAdditionsStorageCell<T> iAEAdditionsStorageCell = this.cellType;
        Intrinsics.checkNotNull(iAEAdditionsStorageCell);
        return iAEAdditionsStorageCell.getConfigInventory(this.itemStackLocal);
    }

    @Nullable
    public IItemHandler getUpgradesInventory() {
        IAEAdditionsStorageCell<T> iAEAdditionsStorageCell = this.cellType;
        Intrinsics.checkNotNull(iAEAdditionsStorageCell);
        return iAEAdditionsStorageCell.getUpgradesInventory(this.itemStackLocal);
    }

    public int getBytesPerType() {
        IAEAdditionsStorageCell<T> iAEAdditionsStorageCell = this.cellType;
        Intrinsics.checkNotNull(iAEAdditionsStorageCell);
        return iAEAdditionsStorageCell.getBytesPerType(this.itemStackLocal);
    }

    public boolean canHoldNewItem() {
        long bytesFree = this.getFreeBytes();
        return (bytesFree > (long)this.getBytesPerType() || bytesFree == (long)this.getBytesPerType() && this.getUnusedItemCount() > 0) && this.getRemainingItemTypes() > 0L;
    }

    public long getTotalBytes() {
        IAEAdditionsStorageCell<T> iAEAdditionsStorageCell = this.cellType;
        Intrinsics.checkNotNull(iAEAdditionsStorageCell);
        return iAEAdditionsStorageCell.getBytes(this.itemStackLocal);
    }

    public long getFreeBytes() {
        return this.getTotalBytes() - this.getUsedBytes();
    }

    public long getTotalItemTypes() {
        return this.maxItemTypes;
    }

    public long getStoredItemCount() {
        return this.storedItemCount;
    }

    public long getStoredItemTypes() {
        return this.storedItems;
    }

    public long getRemainingItemTypes() {
        long baseOnTotal;
        long basedOnStorage = this.getFreeBytes() / (long)this.getBytesPerType();
        return basedOnStorage > (baseOnTotal = this.getTotalItemTypes() - this.getStoredItemTypes()) ? baseOnTotal : basedOnStorage;
    }

    public long getUsedBytes() {
        long bytesForItemCount = (this.getStoredItemCount() + (long)this.getUnusedItemCount()) / (long)this.itemsPerByte;
        return this.getStoredItemTypes() * (long)this.getBytesPerType() + bytesForItemCount;
    }

    public long getRemainingItemCount() {
        long remaining = this.getFreeBytes() * (long)this.itemsPerByte + (long)this.getUnusedItemCount();
        return remaining > 0L ? remaining : 0L;
    }

    public int getUnusedItemCount() {
        int div = (int)(this.getStoredItemCount() % (long)8);
        return div == 0 ? 0 : this.itemsPerByte - div;
    }

    @Nullable
    public CellState getStatusForCell() {
        if (this.getStoredItemTypes() == 0L) {
            return CellState.EMPTY;
        }
        if (this.canHoldNewItem()) {
            return CellState.NOT_EMPTY;
        }
        return this.getRemainingItemCount() > 0L ? CellState.TYPES_FULL : CellState.FULL;
    }

    static {
        int n = 0;
        int n2 = MAX_ITEM_TYPES;
        if (n < n2) {
            do {
                int x = n++;
                AbstractAEAdditionsInventory.ITEM_SLOT_KEYS[x] = Intrinsics.stringPlus((String)ITEM_SLOT, (Object)x);
                AbstractAEAdditionsInventory.ITEM_SLOT_COUNT_KEYS[x] = Intrinsics.stringPlus((String)ITEM_SLOT_COUNT, (Object)x);
            } while (n < n2);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0018\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/the9grounds/aeadditions/me/storage/AbstractAEAdditionsInventory$Companion;", "", "()V", "ITEM_COUNT_TAG", "", "ITEM_PRE_FORMATTED_COUNT", "getITEM_PRE_FORMATTED_COUNT", "()Ljava/lang/String;", "ITEM_PRE_FORMATTED_FUZZY", "getITEM_PRE_FORMATTED_FUZZY", "ITEM_PRE_FORMATTED_NAME", "getITEM_PRE_FORMATTED_NAME", "ITEM_PRE_FORMATTED_SLOT", "getITEM_PRE_FORMATTED_SLOT", "ITEM_SLOT", "ITEM_SLOT_COUNT", "ITEM_SLOT_COUNT_KEYS", "", "[Ljava/lang/String;", "ITEM_SLOT_KEYS", "ITEM_TYPE_TAG", "MAX_ITEM_TYPES", "", "AEAdditions-1.16.5"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final String getITEM_PRE_FORMATTED_COUNT() {
            return ITEM_PRE_FORMATTED_COUNT;
        }

        @NotNull
        protected final String getITEM_PRE_FORMATTED_SLOT() {
            return ITEM_PRE_FORMATTED_SLOT;
        }

        @NotNull
        protected final String getITEM_PRE_FORMATTED_NAME() {
            return ITEM_PRE_FORMATTED_NAME;
        }

        @NotNull
        protected final String getITEM_PRE_FORMATTED_FUZZY() {
            return ITEM_PRE_FORMATTED_FUZZY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

