/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.network;

import appeng.core.sync.network.TargetPoint;
import com.the9grounds.aeadditions.LoggerKt;
import com.the9grounds.aeadditions.network.AEAPacketBuffer;
import com.the9grounds.aeadditions.network.handler.ClientPacketHandler;
import com.the9grounds.aeadditions.network.handler.IPacketHandler;
import com.the9grounds.aeadditions.network.handler.ServerPacketHandler;
import com.the9grounds.aeadditions.network.packets.BasePacket;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.ThreadQuickExitException;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.event.EventNetworkChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u000eJ\u0016\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001fH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006 "}, d2={"Lcom/the9grounds/aeadditions/network/NetworkManager;", "", "()V", "channel", "Lnet/minecraft/util/ResourceLocation;", "getChannel", "()Lnet/minecraft/util/ResourceLocation;", "clientPacketHandler", "Lcom/the9grounds/aeadditions/network/handler/IPacketHandler;", "getClientPacketHandler", "()Lcom/the9grounds/aeadditions/network/handler/IPacketHandler;", "serverPacketHandler", "getServerPacketHandler", "clientPacket", "", "event", "Lnet/minecraftforge/fml/network/NetworkEvent$ServerCustomPayloadEvent;", "getServer", "Lnet/minecraft/server/MinecraftServer;", "init", "sendTo", "message", "Lcom/the9grounds/aeadditions/network/packets/BasePacket;", "player", "Lnet/minecraft/entity/player/ServerPlayerEntity;", "sendToAll", "sendToAllAround", "point", "Lappeng/core/sync/network/TargetPoint;", "sendToServer", "serverPacket", "Lnet/minecraftforge/fml/network/NetworkEvent$ClientCustomPayloadEvent;", "AEAdditions-1.16.5"})
public final class NetworkManager {
    @NotNull
    public static final NetworkManager INSTANCE;
    @NotNull
    private static final ResourceLocation channel;
    @Nullable
    private static final IPacketHandler clientPacketHandler;
    @Nullable
    private static final IPacketHandler serverPacketHandler;

    private NetworkManager() {
    }

    @NotNull
    public final ResourceLocation getChannel() {
        return channel;
    }

    @Nullable
    public final IPacketHandler getClientPacketHandler() {
        return clientPacketHandler;
    }

    @Nullable
    public final IPacketHandler getServerPacketHandler() {
        return serverPacketHandler;
    }

    public final void init() {
    }

    @SubscribeEvent
    public final void serverPacket(@NotNull NetworkEvent.ClientCustomPayloadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (serverPacketHandler != null) {
            try {
                NetworkEvent.Context ctx = (NetworkEvent.Context)event.getSource().get();
                INetHandler iNetHandler = ctx.getNetworkManager().func_150729_e();
                if (iNetHandler == null) {
                    throw new NullPointerException("null cannot be cast to non-null type net.minecraft.network.play.ServerPlayNetHandler");
                }
                ServerPlayNetHandler netHandler = (ServerPlayNetHandler)iNetHandler;
                ctx.setPacketHandled(true);
                ByteBuf byteBuf = event.getPayload().copy();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"event.payload.copy()");
                AEAPacketBuffer packet = new AEAPacketBuffer(byteBuf);
                ctx.enqueueWork(() -> NetworkManager.serverPacket$lambda-7(this, netHandler, packet));
            }
            catch (ThreadQuickExitException threadQuickExitException) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public final void clientPacket(@NotNull NetworkEvent.ServerCustomPayloadEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof NetworkEvent.ServerCustomPayloadLoginEvent) {
            return;
        }
        if (clientPacketHandler != null) {
            try {
                NetworkEvent.Context ctx = (NetworkEvent.Context)event.getSource().get();
                INetHandler netHandler = ctx.getNetworkManager().func_150729_e();
                ctx.setPacketHandled(true);
                ByteBuf byteBuf = event.getPayload().copy();
                Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"event.payload.copy()");
                AEAPacketBuffer packet = new AEAPacketBuffer(byteBuf);
                ctx.enqueueWork(() -> NetworkManager.clientPacket$lambda-8(this, netHandler, packet));
            }
            catch (ThreadQuickExitException e) {
                LoggerKt.getLogger().warn((Object)e);
            }
        }
    }

    public final void sendToAll(@NotNull BasePacket message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        MinecraftServer minecraftServer = this.getServer();
        Intrinsics.checkNotNull((Object)minecraftServer);
        minecraftServer.func_184103_al().func_148540_a(message.toPacket(NetworkDirection.PLAY_TO_CLIENT));
    }

    public final void sendTo(@NotNull BasePacket message, @NotNull ServerPlayerEntity player) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        player.field_71135_a.func_147359_a(message.toPacket(NetworkDirection.PLAY_TO_CLIENT));
    }

    public final void sendToAllAround(@NotNull BasePacket message, @NotNull TargetPoint point) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        IPacket<?> pkt = message.toPacket(NetworkDirection.PLAY_TO_CLIENT);
        MinecraftServer minecraftServer = this.getServer();
        Intrinsics.checkNotNull((Object)minecraftServer);
        minecraftServer.func_184103_al().func_148543_a((PlayerEntity)point.excluded, point.x, point.y, point.z, point.r2, point.world.func_234923_W_(), pkt);
    }

    public final void sendToServer(@NotNull BasePacket message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ClientPlayNetHandler clientPlayNetHandler = Minecraft.func_71410_x().func_147114_u();
        Intrinsics.checkNotNull((Object)clientPlayNetHandler);
        clientPlayNetHandler.func_147297_a(message.toPacket(NetworkDirection.PLAY_TO_SERVER));
    }

    private final MinecraftServer getServer() {
        return (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
    }

    private static final boolean _init_$lambda-0(String it) {
        return true;
    }

    private static final boolean _init_$lambda-1(String it) {
        return true;
    }

    private static final String _init_$lambda-2() {
        return "1.0";
    }

    private static final ClientPacketHandler lambda-4$lambda-3() {
        return new ClientPacketHandler();
    }

    private static final Supplier _init_$lambda-4() {
        return NetworkManager::lambda-4$lambda-3;
    }

    private static final ClientPacketHandler lambda-6$lambda-5() {
        return null;
    }

    private static final Supplier _init_$lambda-6() {
        return NetworkManager::lambda-6$lambda-5;
    }

    private static final void serverPacket$lambda-7(NetworkManager this$0, ServerPlayNetHandler $netHandler, AEAPacketBuffer $packet) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$netHandler, (String)"$netHandler");
        Intrinsics.checkNotNullParameter((Object)((Object)$packet), (String)"$packet");
        this$0.getServerPacketHandler().onPacketData((INetHandler)$netHandler, $packet, (PlayerEntity)$netHandler.field_147369_b);
    }

    private static final void clientPacket$lambda-8(NetworkManager this$0, INetHandler $netHandler, AEAPacketBuffer $packet) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$packet), (String)"$packet");
        IPacketHandler iPacketHandler = this$0.getClientPacketHandler();
        Intrinsics.checkNotNullExpressionValue((Object)$netHandler, (String)"netHandler");
        iPacketHandler.onPacketData($netHandler, $packet, null);
    }

    static {
        IPacketHandler iPacketHandler;
        INSTANCE = new NetworkManager();
        channel = new ResourceLocation("aeadditions", "main");
        EventNetworkChannel ec = NetworkRegistry.ChannelBuilder.named((ResourceLocation)channel).clientAcceptedVersions(NetworkManager::_init_$lambda-0).serverAcceptedVersions(NetworkManager::_init_$lambda-1).networkProtocolVersion(NetworkManager::_init_$lambda-2).eventNetworkChannel();
        ec.registerObject((Object)INSTANCE);
        clientPacketHandler = (IPacketHandler)DistExecutor.unsafeRunForDist(NetworkManager::_init_$lambda-4, NetworkManager::_init_$lambda-6);
        try {
            iPacketHandler = new ServerPacketHandler();
        }
        catch (Throwable e) {
            iPacketHandler = null;
        }
        serverPacketHandler = iPacketHandler;
    }
}

