/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.network.packets;

import com.the9grounds.aeadditions.container.AbstractContainer;
import com.the9grounds.aeadditions.network.AEAPacketBuffer;
import com.the9grounds.aeadditions.network.packets.BasePacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/the9grounds/aeadditions/network/packets/GuiDataSyncPacket;", "Lcom/the9grounds/aeadditions/network/packets/BasePacket;", "windowId", "", "writer", "Ljava/util/function/Consumer;", "Lcom/the9grounds/aeadditions/network/AEAPacketBuffer;", "(ILjava/util/function/Consumer;)V", "data", "(Lcom/the9grounds/aeadditions/network/AEAPacketBuffer;)V", "getData", "()Lcom/the9grounds/aeadditions/network/AEAPacketBuffer;", "setData", "getWindowId", "()I", "setWindowId", "(I)V", "clientPacketData", "", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "serverPacketData", "AEAdditions-1.16.5"})
public final class GuiDataSyncPacket
extends BasePacket {
    private int windowId;
    @Nullable
    private AEAPacketBuffer data;

    public final int getWindowId() {
        return this.windowId;
    }

    public final void setWindowId(int n) {
        this.windowId = n;
    }

    @Nullable
    public final AEAPacketBuffer getData() {
        return this.data;
    }

    public final void setData(@Nullable AEAPacketBuffer aEAPacketBuffer) {
        this.data = aEAPacketBuffer;
    }

    public GuiDataSyncPacket(int windowId, @NotNull Consumer<AEAPacketBuffer> writer) {
        Intrinsics.checkNotNullParameter(writer, (String)"writer");
        this.windowId = 0;
        ByteBuf byteBuf = Unpooled.buffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"buffer()");
        AEAPacketBuffer data = new AEAPacketBuffer(byteBuf);
        data.writeInt(this.getPacketId());
        data.func_150787_b(windowId);
        writer.accept(data);
        this.configureWrite(data);
    }

    public GuiDataSyncPacket(@NotNull AEAPacketBuffer data) {
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        this.windowId = data.func_150792_a();
        ByteBuf byteBuf = data.copy();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"data.copy()");
        this.data = new AEAPacketBuffer(byteBuf);
    }

    @Override
    public void clientPacketData(@Nullable PlayerEntity player) {
        Intrinsics.checkNotNull((Object)player);
        Container openContainer = player.field_71070_bA;
        if (openContainer instanceof AbstractContainer && this.windowId == openContainer.field_75152_c) {
            ((AbstractContainer)openContainer).receiveServerDataSync(this);
        }
    }

    @Override
    public void serverPacketData(@Nullable PlayerEntity player) {
        Intrinsics.checkNotNull((Object)player);
        Container openContainer = player.field_71070_bA;
        if (openContainer instanceof AbstractContainer && this.windowId == openContainer.field_75152_c) {
            ((AbstractContainer)openContainer).receiveServerDataSync(this);
        }
    }
}

