/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.parts;

import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.IPartHost;
import appeng.me.GridAccessException;
import com.the9grounds.aeadditions.parts.AEABasePart;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0007J\u0012\u0010\u0011\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\n\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/the9grounds/aeadditions/parts/AbstractBasicStatePart;", "Lcom/the9grounds/aeadditions/parts/AEABasePart;", "itemStack", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/item/ItemStack;)V", "clientFlags", "", "isActive", "", "()Z", "isPowered", "channelRender", "", "event", "Lappeng/api/networking/events/MENetworkChannelsChanged;", "powerRender", "Lappeng/api/networking/events/MENetworkPowerStatusChange;", "readFromStream", "data", "Lnet/minecraft/network/PacketBuffer;", "writeToStream", "Companion", "AEAdditions-1.16.5"})
public abstract class AbstractBasicStatePart
extends AEABasePart {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int clientFlags;
    private static final int POWERED_FLAG = 1;
    private static final int CHANNEL_FLAG = 2;

    public AbstractBasicStatePart(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        super(itemStack);
        GridFlags[] gridFlagsArray = new GridFlags[]{GridFlags.REQUIRE_CHANNEL};
        this.getProxy().setFlags(gridFlagsArray);
    }

    @MENetworkEventSubscribe
    public final void channelRender(@NotNull MENetworkChannelsChanged event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        IPartHost iPartHost = this.getHost();
        Intrinsics.checkNotNull((Object)iPartHost);
        iPartHost.markForUpdate();
    }

    @MENetworkEventSubscribe
    public final void powerRender(@NotNull MENetworkPowerStatusChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        IPartHost iPartHost = this.getHost();
        Intrinsics.checkNotNull((Object)iPartHost);
        iPartHost.markForUpdate();
    }

    @Override
    public void writeToStream(@Nullable PacketBuffer data) {
        super.writeToStream(data);
        this.clientFlags = 0;
        try {
            if (this.getProxy().getEnergy().isNetworkPowered()) {
                this.clientFlags |= POWERED_FLAG;
            }
            if (this.getProxy().getNode().meetsChannelRequirements()) {
                this.clientFlags |= CHANNEL_FLAG;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        Intrinsics.checkNotNull((Object)data);
        data.writeByte(this.clientFlags);
    }

    @Override
    public boolean readFromStream(@Nullable PacketBuffer data) {
        boolean eh = super.readFromStream(data);
        int old = this.clientFlags;
        Intrinsics.checkNotNull((Object)data);
        this.clientFlags = data.readByte();
        return eh || old != this.clientFlags;
    }

    public final boolean isPowered() {
        return (this.clientFlags & POWERED_FLAG) == POWERED_FLAG;
    }

    public final boolean isActive() {
        return (this.clientFlags & CHANNEL_FLAG) == CHANNEL_FLAG;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/the9grounds/aeadditions/parts/AbstractBasicStatePart$Companion;", "", "()V", "CHANNEL_FLAG", "", "getCHANNEL_FLAG", "()I", "POWERED_FLAG", "getPOWERED_FLAG", "AEAdditions-1.16.5"})
    public static final class Companion {
        private Companion() {
        }

        protected final int getPOWERED_FLAG() {
            return POWERED_FLAG;
        }

        protected final int getCHANNEL_FLAG() {
            return CHANNEL_FLAG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

