/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.parts;

import appeng.api.storage.data.IAEStack;
import appeng.api.util.DimensionalCoord;
import com.the9grounds.aeadditions.parts.AbstractMonitorPart;
import com.the9grounds.aeadditions.util.Utils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\bH$J\u001c\u0010\u000e\u001a\u00020\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH$J\u001c\u0010\u0010\u001a\u00020\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH$J&\u0010\u0011\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J&\u0010\u0014\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/the9grounds/aeadditions/parts/AbstractConversionMonitorPart;", "T", "Lappeng/api/storage/data/IAEStack;", "Lcom/the9grounds/aeadditions/parts/AbstractMonitorPart;", "itemStack", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/item/ItemStack;)V", "canExtractOrInsertFromHeldItem", "", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "hand", "Lnet/minecraft/util/Hand;", "extract", "extractStack", "", "insertStack", "onClicked", "pos", "Lnet/minecraft/util/math/vector/Vector3d;", "onPartActivate", "AEAdditions-1.16.5"})
public abstract class AbstractConversionMonitorPart<T extends IAEStack<T>>
extends AbstractMonitorPart<T> {
    public AbstractConversionMonitorPart(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        super(itemStack);
    }

    @Override
    public boolean onPartActivate(@Nullable PlayerEntity player, @Nullable Hand hand, @Nullable Vector3d pos) {
        if (this.isRemote()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        DimensionalCoord dimensionalCoord = this.getLocation();
        Intrinsics.checkNotNull((Object)player);
        if (!Utils.INSTANCE.hasPermissions(dimensionalCoord, player)) {
            return false;
        }
        Object stack = this.getStackFromHeldItem(player, hand);
        if (!this.canExtractOrInsertFromHeldItem(player, hand, false)) {
            return super.onPartActivate(player, hand, pos);
        }
        if (this.getLocked()) {
            this.insertStack(player, hand);
        } else if (Intrinsics.areEqual(stack, this.getWatchedItem()) || stack == null) {
            this.insertStack(player, hand);
        } else {
            return super.onPartActivate(player, hand, pos);
        }
        return true;
    }

    public boolean onClicked(@Nullable PlayerEntity player, @Nullable Hand hand, @Nullable Vector3d pos) {
        if (this.isRemote()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        DimensionalCoord dimensionalCoord = this.getLocation();
        Intrinsics.checkNotNull((Object)player);
        if (!Utils.INSTANCE.hasPermissions(dimensionalCoord, player)) {
            return false;
        }
        if (this.getWatchedItem() == null) {
            return super.onClicked(player, hand, pos);
        }
        if (!this.canExtractOrInsertFromHeldItem(player, hand, true)) {
            return super.onClicked(player, hand, pos);
        }
        this.extractStack(player, hand);
        return true;
    }

    protected abstract boolean canExtractOrInsertFromHeldItem(@Nullable PlayerEntity var1, @Nullable Hand var2, boolean var3);

    protected abstract void insertStack(@Nullable PlayerEntity var1, @Nullable Hand var2);

    protected abstract void extractStack(@Nullable PlayerEntity var1, @Nullable Hand var2);
}

