/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.parts;

import appeng.api.implementations.parts.IStorageMonitorPart;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.fluids.util.AEFluidStack;
import appeng.me.GridAccessException;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.the9grounds.aeadditions.api.chemical.IAEChemicalStack;
import com.the9grounds.aeadditions.core.PlayerMessages;
import com.the9grounds.aeadditions.integration.mekanism.chemical.AEChemicalStack;
import com.the9grounds.aeadditions.parts.AbstractDisplayPart;
import com.the9grounds.aeadditions.parts.AbstractReportingPart;
import com.the9grounds.aeadditions.util.Utils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u00032\u00020\u00042\u00020\u0005B\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010!\u001a\u00020\"H\u0002J\u000f\u0010#\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ#\u0010$\u001a\u0004\u0018\u00018\u00002\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010(H&\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+H&J\b\u0010,\u001a\u00020\nH\u0002J\b\u0010-\u001a\u00020\nH&J\b\u0010.\u001a\u00020\u0010H\u0016J&\u0010/\u001a\u00020\u00102\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010(2\b\u00100\u001a\u0004\u0018\u000101H\u0016J&\u00102\u001a\u00020\u00102\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010(2\b\u00100\u001a\u0004\u0018\u000101H\u0016J&\u00103\u001a\u00020\u00102\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010(2\b\u00100\u001a\u0004\u0018\u000101H\u0016JJ\u00104\u001a\u00020\"2\f\u00105\u001a\b\u0012\u0002\b\u0003\u0018\u0001062\f\u00107\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\f\u00108\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\b\u00109\u001a\u0004\u0018\u00010:2\f\u0010;\u001a\b\u0012\u0002\b\u0003\u0018\u00010+H\u0016J\u0012\u0010<\u001a\u00020\"2\b\u0010=\u001a\u0004\u0018\u00010>H\u0016J\u0012\u0010?\u001a\u00020\u00102\b\u0010=\u001a\u0004\u0018\u00010@H\u0016J4\u0010A\u001a\u00020\"2\u0006\u0010B\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010E2\b\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020IH\u0016J\b\u0010K\u001a\u00020\u0010H\u0016J6\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020M2\u0006\u0010O\u001a\u00020M2\u0006\u0010P\u001a\u00020M2\u0006\u0010Q\u001a\u00020M2\u0006\u0010R\u001a\u00020M2\u0006\u0010S\u001a\u00020MJ\u0012\u0010T\u001a\u00020\u00102\b\u0010U\u001a\u0004\u0018\u00010VH\u0016J\u0012\u0010W\u001a\u00020\"2\b\u0010X\u001a\u0004\u0018\u00010\u0016H\u0016J\u0012\u0010Y\u001a\u00020\"2\b\u0010=\u001a\u0004\u0018\u00010>H\u0016J\u0012\u0010Z\u001a\u00020\"2\b\u0010=\u001a\u0004\u0018\u00010@H\u0016R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u0004\u0018\u00018\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010 \u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006["}, d2={"Lcom/the9grounds/aeadditions/parts/AbstractMonitorPart;", "T", "Lappeng/api/storage/data/IAEStack;", "Lcom/the9grounds/aeadditions/parts/AbstractDisplayPart;", "Lappeng/api/networking/storage/IStackWatcherHost;", "Lappeng/api/implementations/parts/IStorageMonitorPart;", "itemStack", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/item/ItemStack;)V", "lastText", "", "getLastText", "()Ljava/lang/String;", "setLastText", "(Ljava/lang/String;)V", "locked", "", "getLocked", "()Z", "setLocked", "(Z)V", "myWatcher", "Lappeng/api/networking/storage/IStackWatcher;", "getMyWatcher", "()Lappeng/api/networking/storage/IStackWatcher;", "setMyWatcher", "(Lappeng/api/networking/storage/IStackWatcher;)V", "watchedItem", "getWatchedItem", "()Lappeng/api/storage/data/IAEStack;", "setWatchedItem", "(Lappeng/api/storage/data/IAEStack;)V", "Lappeng/api/storage/data/IAEStack;", "configureWatcher", "", "getDisplayed", "getStackFromHeldItem", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "hand", "Lnet/minecraft/util/Hand;", "(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/Hand;)Lappeng/api/storage/data/IAEStack;", "getStorageChannel", "Lappeng/api/storage/IStorageChannel;", "getTypeForWatchedItem", "getWatchedItemName", "isLocked", "onPartActivate", "pos", "Lnet/minecraft/util/math/vector/Vector3d;", "onPartShiftActivate", "onShiftClicked", "onStackChange", "o", "Lappeng/api/storage/data/IItemList;", "fullStack", "diffStack", "src", "Lappeng/api/networking/security/IActionSource;", "chan", "readFromNBT", "data", "Lnet/minecraft/nbt/CompoundNBT;", "readFromStream", "Lnet/minecraft/network/PacketBuffer;", "renderDynamic", "partialTicks", "", "matrixStack", "Lcom/mojang/blaze3d/matrix/MatrixStack;", "buffers", "Lnet/minecraft/client/renderer/IRenderTypeBuffer;", "combinedLightIn", "", "combinedOverlayIn", "requireDynamicRender", "selectModel", "Lappeng/api/parts/IPartModel;", "on", "off", "hasChannel", "lockedOn", "lockedOff", "lockedHasChannel", "showNetworkInfo", "where", "Lnet/minecraft/util/math/RayTraceResult;", "updateWatcher", "newWatcher", "writeToNBT", "writeToStream", "AEAdditions-1.16.5"})
public abstract class AbstractMonitorPart<T extends IAEStack<T>>
extends AbstractDisplayPart
implements IStackWatcherHost,
IStorageMonitorPart {
    private boolean locked;
    @Nullable
    private T watchedItem;
    @Nullable
    private String lastText;
    @Nullable
    private IStackWatcher myWatcher;

    public AbstractMonitorPart(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        super(itemStack);
    }

    public final boolean getLocked() {
        return this.locked;
    }

    public final void setLocked(boolean bl) {
        this.locked = bl;
    }

    @Nullable
    public final T getWatchedItem() {
        return this.watchedItem;
    }

    public final void setWatchedItem(@Nullable T t) {
        this.watchedItem = t;
    }

    @Nullable
    public final String getLastText() {
        return this.lastText;
    }

    public final void setLastText(@Nullable String string) {
        this.lastText = string;
    }

    @Nullable
    public final IStackWatcher getMyWatcher() {
        return this.myWatcher;
    }

    public final void setMyWatcher(@Nullable IStackWatcher iStackWatcher) {
        this.myWatcher = iStackWatcher;
    }

    @Override
    public void readFromNBT(@Nullable CompoundNBT data) {
        Object object;
        super.readFromNBT(data);
        Intrinsics.checkNotNull((Object)data);
        this.locked = data.func_74767_n("locked");
        String type = data.func_74779_i("itemType");
        CompoundNBT compound = data.func_74775_l("watchedItem");
        String string = type;
        if (Intrinsics.areEqual((Object)string, (Object)"fluid")) {
            IAEFluidStack iAEFluidStack = AEFluidStack.fromNBT((CompoundNBT)compound);
            object = iAEFluidStack instanceof IAEStack ? (IAEStack)iAEFluidStack : null;
        } else if (Intrinsics.areEqual((Object)string, (Object)"chemical")) {
            Intrinsics.checkNotNullExpressionValue((Object)compound, (String)"compound");
            AEChemicalStack aEChemicalStack = new AEChemicalStack(compound);
            object = aEChemicalStack instanceof IAEStack ? (IAEStack)aEChemicalStack : null;
        } else {
            throw new RuntimeException("Invalid type for storage/conversion monitor");
        }
        this.watchedItem = object;
    }

    @Override
    public void writeToNBT(@Nullable CompoundNBT data) {
        super.writeToNBT(data);
        Intrinsics.checkNotNull((Object)data);
        data.func_74757_a("locked", this.locked);
        CompoundNBT watchedItemCompound = new CompoundNBT();
        if (this.watchedItem != null) {
            String type = this.getTypeForWatchedItem();
            data.func_74778_a("itemType", type);
            T t = this.watchedItem;
            Intrinsics.checkNotNull(t);
            t.writeToNBT(watchedItemCompound);
        }
        data.func_218657_a("watchedItem", (INBT)watchedItemCompound);
    }

    private final String getTypeForWatchedItem() {
        String string;
        T t = this.watchedItem;
        if (t instanceof IAEFluidStack) {
            string = "fluid";
        } else if (t instanceof IAEChemicalStack) {
            string = "chemical";
        } else if (t == null) {
            string = "";
        } else {
            throw new RuntimeException("Invalid type for storage/conversion monitor");
        }
        String type = string;
        return type;
    }

    @Override
    public void writeToStream(@Nullable PacketBuffer data) {
        super.writeToStream(data);
        Intrinsics.checkNotNull((Object)data);
        data.writeBoolean(this.locked);
        String type = this.getTypeForWatchedItem();
        data.func_180714_a(type);
        if (this.watchedItem != null) {
            T t = this.watchedItem;
            Intrinsics.checkNotNull(t);
            t.writeToPacket(data);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean readFromStream(@Nullable PacketBuffer data) {
        IAEStack iAEStack;
        String type;
        super.readFromStream(data);
        Intrinsics.checkNotNull((Object)data);
        boolean isLocked = data.readBoolean();
        boolean needRedraw = isLocked != this.locked;
        this.locked = isLocked;
        String string = type = data.func_218666_n();
        if (string == null) throw new RuntimeException("Invalid type for storage/conversion monitor");
        int n = -1;
        switch (string.hashCode()) {
            case 0: {
                if (string.equals("")) {
                    n = 1;
                }
                break;
            }
            case 1546067986: {
                if (string.equals("chemical")) {
                    n = 2;
                }
                break;
            }
            case 97532362: {
                if (string.equals("fluid")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                iAEStack = null;
                break;
            }
            case 3: {
                IAEFluidStack iAEFluidStack = AEFluidStack.fromPacket((PacketBuffer)data);
                if (iAEFluidStack instanceof IAEStack) {
                    iAEStack = (IAEStack)iAEFluidStack;
                    break;
                }
                iAEStack = null;
                break;
            }
            case 2: {
                IAEChemicalStack iAEChemicalStack = AEChemicalStack.Companion.fromPacket(data);
                if (iAEChemicalStack instanceof IAEStack) {
                    iAEStack = iAEChemicalStack;
                    break;
                }
                iAEStack = null;
                break;
            }
            default: {
                throw new RuntimeException("Invalid type for storage/conversion monitor");
            }
        }
        this.watchedItem = iAEStack;
        return needRedraw;
    }

    @Override
    public boolean onPartActivate(@Nullable PlayerEntity player, @Nullable Hand hand, @Nullable Vector3d pos) {
        if (this.isRemote()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        DimensionalCoord dimensionalCoord = this.getLocation();
        Intrinsics.checkNotNull((Object)player);
        if (!Utils.INSTANCE.hasPermissions(dimensionalCoord, player)) {
            return false;
        }
        if (!this.locked) {
            T stack = this.getStackFromHeldItem(player, hand);
            if (stack == null) {
                return false;
            }
            this.watchedItem = stack;
            this.configureWatcher();
            IPartHost iPartHost = this.getHost();
            if (iPartHost != null) {
                iPartHost.markForSave();
            }
            iPartHost = this.getHost();
            if (iPartHost != null) {
                iPartHost.markForUpdate();
            }
        } else {
            return super.onPartActivate(player, hand, pos);
        }
        return true;
    }

    public boolean onShiftClicked(@Nullable PlayerEntity player, @Nullable Hand hand, @Nullable Vector3d pos) {
        IStackWatcher iStackWatcher;
        if (this.isRemote()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        DimensionalCoord dimensionalCoord = this.getLocation();
        Intrinsics.checkNotNull((Object)player);
        if (!Utils.INSTANCE.hasPermissions(dimensionalCoord, player)) {
            return false;
        }
        if (this.locked || this.watchedItem == null) {
            return false;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b()) {
            player.func_145747_a(PlayerMessages.handMustBeEmpty.get(), Util.field_240973_b_);
            return false;
        }
        if (this.myWatcher != null) {
            iStackWatcher = this.myWatcher;
            Intrinsics.checkNotNull((Object)iStackWatcher);
            iStackWatcher.remove(this.watchedItem);
        }
        this.watchedItem = null;
        iStackWatcher = this.getHost();
        if (iStackWatcher != null) {
            iStackWatcher.markForSave();
        }
        iStackWatcher = this.getHost();
        if (iStackWatcher != null) {
            iStackWatcher.markForUpdate();
        }
        return true;
    }

    @Override
    public boolean onPartShiftActivate(@Nullable PlayerEntity player, @Nullable Hand hand, @Nullable Vector3d pos) {
        if (this.isRemote()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        DimensionalCoord dimensionalCoord = this.getLocation();
        Intrinsics.checkNotNull((Object)player);
        if (!Utils.INSTANCE.hasPermissions(dimensionalCoord, player)) {
            return false;
        }
        if (player.func_184586_b(hand).func_190926_b()) {
            this.locked = !this.locked;
            PlayerMessages message = this.locked ? PlayerMessages.isNowLocked : PlayerMessages.isNowUnlocked;
            player.func_145747_a(message.get(), Util.field_240973_b_);
            IPartHost iPartHost = this.getHost();
            if (iPartHost != null) {
                iPartHost.markForSave();
            }
            iPartHost = this.getHost();
            if (iPartHost != null) {
                iPartHost.markForUpdate();
            }
        }
        return true;
    }

    public void renderDynamic(float partialTicks, @Nullable MatrixStack matrixStack, @Nullable IRenderTypeBuffer buffers, int combinedLightIn, int combinedOverlayIn) {
        if ((this.getClientFlags() & (AbstractReportingPart.getPOWERED_FLAG() | AbstractReportingPart.getCHANNEL_FLAG())) != (AbstractReportingPart.getPOWERED_FLAG() | AbstractReportingPart.getCHANNEL_FLAG())) {
            return;
        }
        if (this.watchedItem == null) {
            return;
        }
        Intrinsics.checkNotNull((Object)matrixStack);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        AEPartLocation aEPartLocation = this.getSide();
        Intrinsics.checkNotNull((Object)aEPartLocation);
        Object object = aEPartLocation.getFacing();
        Intrinsics.checkNotNull((Object)object);
        Utils.INSTANCE.rotateToFace(matrixStack, (Direction)object, this.getRotation());
        matrixStack.func_227861_a_(0.0, 0.05, 0.5);
        object = this.watchedItem;
        Intrinsics.checkNotNull((Object)object);
        Utils.INSTANCE.renderStack2dWithAmount(matrixStack, buffers, object, this.getWatchedItemName(), 0.4f, -0.23f, 0xF000F0, combinedOverlayIn);
        matrixStack.func_227865_b_();
    }

    @NotNull
    public abstract String getWatchedItemName();

    @Override
    public boolean requireDynamicRender() {
        return true;
    }

    @Nullable
    public abstract T getStackFromHeldItem(@Nullable PlayerEntity var1, @Nullable Hand var2);

    @NotNull
    public final IPartModel selectModel(@NotNull IPartModel on, @NotNull IPartModel off, @NotNull IPartModel hasChannel, @NotNull IPartModel lockedOn, @NotNull IPartModel lockedOff, @NotNull IPartModel lockedHasChannel) {
        Intrinsics.checkNotNullParameter((Object)on, (String)"on");
        Intrinsics.checkNotNullParameter((Object)off, (String)"off");
        Intrinsics.checkNotNullParameter((Object)hasChannel, (String)"hasChannel");
        Intrinsics.checkNotNullParameter((Object)lockedOn, (String)"lockedOn");
        Intrinsics.checkNotNullParameter((Object)lockedOff, (String)"lockedOff");
        Intrinsics.checkNotNullParameter((Object)lockedHasChannel, (String)"lockedHasChannel");
        return this.isActive() ? (this.locked ? lockedHasChannel : hasChannel) : (this.isPowered() ? (this.locked ? lockedOn : on) : (this.locked ? lockedOff : off));
    }

    public void updateWatcher(@Nullable IStackWatcher newWatcher) {
        this.myWatcher = newWatcher;
        this.configureWatcher();
    }

    private final void configureWatcher() {
        IStackWatcher iStackWatcher;
        if (this.myWatcher != null) {
            iStackWatcher = this.myWatcher;
            Intrinsics.checkNotNull((Object)iStackWatcher);
            iStackWatcher.reset();
        }
        try {
            if (this.watchedItem != null) {
                IAEStack stack;
                if (this.myWatcher != null) {
                    iStackWatcher = this.myWatcher;
                    Intrinsics.checkNotNull((Object)iStackWatcher);
                    iStackWatcher.add(this.watchedItem);
                }
                if ((stack = this.getProxy().getStorage().getInventory(this.getStorageChannel()).getStorageList().findPrecise(this.watchedItem)) == null) {
                    T t = this.watchedItem;
                    Intrinsics.checkNotNull(t);
                    t.setStackSize(0L);
                } else {
                    T t = this.watchedItem;
                    Intrinsics.checkNotNull(t);
                    t.setStackSize(stack.getStackSize());
                }
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public void onStackChange(@Nullable IItemList<?> o, @Nullable IAEStack<?> fullStack, @Nullable IAEStack<?> diffStack, @Nullable IActionSource src, @Nullable IStorageChannel<?> chan) {
        if (this.watchedItem != null && fullStack != null) {
            T t = this.watchedItem;
            Intrinsics.checkNotNull(t);
            t.setStackSize(fullStack.getStackSize());
            Object object = this.watchedItem;
            Intrinsics.checkNotNull(object);
            String text = Utils.INSTANCE.getAmountTextForStack(object);
            if (!Intrinsics.areEqual((Object)text, (Object)this.lastText)) {
                this.lastText = text;
                object = this.getHost();
                Intrinsics.checkNotNull(object);
                object.markForUpdate();
            }
        }
    }

    @NotNull
    public abstract IStorageChannel<T> getStorageChannel();

    public boolean showNetworkInfo(@Nullable RayTraceResult where) {
        return false;
    }

    @Nullable
    public T getDisplayed() {
        return this.watchedItem;
    }

    public boolean isLocked() {
        return this.locked;
    }
}

