/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.parts;

import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.parts.IMonitorPart;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkBootingStatusChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.util.AEPartLocation;
import appeng.me.GridAccessException;
import appeng.parts.reporting.ReportingModelData;
import com.the9grounds.aeadditions.parts.AEABasePart;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0005\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 F2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001FB\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0012\u0010\u001f\u001a\u00020\u001c2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\b\u0010\"\u001a\u00020\u000bH\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\bH\u0016J\b\u0010&\u001a\u00020\bH&J\b\u0010'\u001a\u00020\bH\u0016J&\u0010(\u001a\u00020\u001c2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010-\u001a\u0004\u0018\u00010,H\u0016J&\u0010.\u001a\u00020\b2\b\u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u0001022\b\u0010+\u001a\u0004\u0018\u000103H\u0016J0\u00104\u001a\u00020\u001c2\b\u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u0001022\b\u00105\u001a\u0004\u0018\u00010\u00052\b\u00106\u001a\u0004\u0018\u000107H\u0016J\u0010\u00108\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u000209H\u0007J\u0012\u0010:\u001a\u00020\u001c2\b\u0010;\u001a\u0004\u0018\u00010<H\u0016J\u0012\u0010=\u001a\u00020\b2\b\u0010;\u001a\u0004\u0018\u00010>H\u0016J \u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020@2\u0006\u0010B\u001a\u00020@2\u0006\u0010C\u001a\u00020@H\u0004J\u0012\u0010D\u001a\u00020\u001c2\b\u0010;\u001a\u0004\u0018\u00010<H\u0016J\u0012\u0010E\u001a\u00020\u001c2\b\u0010;\u001a\u0004\u0018\u00010>H\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006G"}, d2={"Lcom/the9grounds/aeadditions/parts/AbstractReportingPart;", "Lcom/the9grounds/aeadditions/parts/AEABasePart;", "Lappeng/api/implementations/parts/IMonitorPart;", "Lappeng/api/implementations/IPowerChannelState;", "itemStack", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/item/ItemStack;)V", "requireChannel", "", "(Lnet/minecraft/item/ItemStack;Z)V", "clientFlags", "", "getClientFlags", "()I", "setClientFlags", "(I)V", "opacity", "getOpacity", "setOpacity", "rotation", "", "getRotation", "()B", "setRotation", "(B)V", "blockLight", "emit", "bootingRender", "", "event", "Lappeng/api/networking/events/MENetworkBootingStatusChange;", "getBoxes", "bch", "Lappeng/api/parts/IPartCollisionHelper;", "getLightLevel", "getModelData", "Lnet/minecraftforge/client/model/data/IModelData;", "isActive", "isLightSource", "isPowered", "onNeighborChanged", "w", "Lnet/minecraft/world/IBlockReader;", "pos", "Lnet/minecraft/util/math/BlockPos;", "neighbor", "onPartActivate", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "hand", "Lnet/minecraft/util/Hand;", "Lnet/minecraft/util/math/vector/Vector3d;", "onPlacement", "held", "side", "Lappeng/api/util/AEPartLocation;", "powerRender", "Lappeng/api/networking/events/MENetworkPowerStatusChange;", "readFromNBT", "data", "Lnet/minecraft/nbt/CompoundNBT;", "readFromStream", "Lnet/minecraft/network/PacketBuffer;", "selectModel", "Lappeng/api/parts/IPartModel;", "offModels", "onModels", "hasChannelModels", "writeToNBT", "writeToStream", "Companion", "AEAdditions-1.16.5"})
public abstract class AbstractReportingPart
extends AEABasePart
implements IMonitorPart,
IPowerChannelState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private byte rotation;
    private int clientFlags;
    private int opacity;
    private static final int POWERED_FLAG = 4;
    private static final int CHANNEL_FLAG = 16;
    private static final int BOOTING_FLAG = 8;

    public AbstractReportingPart(@NotNull ItemStack itemStack, boolean requireChannel) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        super(itemStack);
        if (requireChannel) {
            GridFlags[] gridFlagsArray = new GridFlags[]{GridFlags.REQUIRE_CHANNEL};
            this.getProxy().setFlags(gridFlagsArray);
            this.getProxy().setIdlePowerUsage(0.5);
        } else {
            this.getProxy().setIdlePowerUsage(0.0625);
        }
    }

    public final byte getRotation() {
        return this.rotation;
    }

    public final void setRotation(byte by) {
        this.rotation = by;
    }

    public final int getClientFlags() {
        return this.clientFlags;
    }

    public final void setClientFlags(int n) {
        this.clientFlags = n;
    }

    public final int getOpacity() {
        return this.opacity;
    }

    public final void setOpacity(int n) {
        this.opacity = n;
    }

    public AbstractReportingPart(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        this(itemStack, false);
    }

    @MENetworkEventSubscribe
    public final void bootingRender(@NotNull MENetworkBootingStatusChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isLightSource()) {
            IPartHost iPartHost = this.getHost();
            Intrinsics.checkNotNull((Object)iPartHost);
            iPartHost.markForUpdate();
        }
    }

    @MENetworkEventSubscribe
    public final void powerRender(@NotNull MENetworkPowerStatusChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        IPartHost iPartHost = this.getHost();
        Intrinsics.checkNotNull((Object)iPartHost);
        iPartHost.markForUpdate();
    }

    @Override
    public void getBoxes(@Nullable IPartCollisionHelper bch) {
        Intrinsics.checkNotNull((Object)bch);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
    }

    @Override
    public void onNeighborChanged(@Nullable IBlockReader w, @Nullable BlockPos pos, @Nullable BlockPos neighbor) {
        if (pos == null || neighbor == null) {
            return;
        }
        AEPartLocation aEPartLocation = this.getSide();
        Intrinsics.checkNotNull((Object)aEPartLocation);
        if (pos.func_177972_a(aEPartLocation.getFacing()).equals((Object)neighbor)) {
            this.opacity = -1;
            aEPartLocation = this.getHost();
            Intrinsics.checkNotNull((Object)aEPartLocation);
            aEPartLocation.markForUpdate();
        }
    }

    @Override
    public void readFromNBT(@Nullable CompoundNBT data) {
        super.readFromNBT(data);
        Intrinsics.checkNotNull((Object)data);
        this.rotation = data.func_74771_c("rotation");
    }

    @Override
    public void writeToNBT(@Nullable CompoundNBT data) {
        super.writeToNBT(data);
        Intrinsics.checkNotNull((Object)data);
        data.func_74774_a("rotation", this.rotation);
    }

    @Override
    public void writeToStream(@Nullable PacketBuffer data) {
        super.writeToStream(data);
        byte by = this.rotation;
        int n = 3;
        boolean bl = false;
        this.clientFlags = (byte)(by & n);
        try {
            if (this.getProxy().getEnergy().isNetworkPowered()) {
                this.clientFlags |= POWERED_FLAG;
            }
            if (this.getProxy().getPath().isNetworkBooting()) {
                this.clientFlags |= BOOTING_FLAG;
            }
            if (this.getProxy().getNode().meetsChannelRequirements()) {
                this.clientFlags |= CHANNEL_FLAG;
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        Intrinsics.checkNotNull((Object)data);
        data.writeByte(this.clientFlags);
        data.writeInt(this.opacity);
    }

    @Override
    public boolean readFromStream(@Nullable PacketBuffer data) {
        super.readFromStream(data);
        int oldFlags = this.clientFlags;
        int oldOpacity = this.opacity;
        Intrinsics.checkNotNull((Object)data);
        this.clientFlags = data.readByte();
        this.opacity = data.readInt();
        byte by = (byte)this.clientFlags;
        int n = 3;
        boolean bl = false;
        this.rotation = (byte)(by & n);
        return this.clientFlags != oldFlags || this.opacity != oldOpacity;
    }

    @Override
    public int getLightLevel() {
        return this.blockLight(this.isPowered() ? (this.isLightSource() ? 15 : 9) : 0);
    }

    @Override
    public boolean onPartActivate(@Nullable PlayerEntity player, @Nullable Hand hand, @Nullable Vector3d pos) {
        return super.onPartActivate(player, hand, pos);
    }

    @Override
    public void onPlacement(@Nullable PlayerEntity player, @Nullable Hand hand, @Nullable ItemStack held, @Nullable AEPartLocation side) {
        super.onPlacement(player, hand, held, side);
        Intrinsics.checkNotNull((Object)player);
        byte by = (byte)MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 2.5));
        int n = 3;
        boolean bl = false;
        byte rotation = (byte)(by & n);
        if (side == AEPartLocation.UP || side == AEPartLocation.DOWN) {
            this.rotation = rotation;
        }
    }

    public boolean isActive() {
        return this.isLightSource() ? (this.clientFlags & (CHANNEL_FLAG | POWERED_FLAG)) == (CHANNEL_FLAG | POWERED_FLAG) : this.isPowered();
    }

    public boolean isPowered() {
        boolean bl;
        try {
            bl = !this.isRemote() ? this.getProxy().getEnergy().isNetworkPowered() : (this.clientFlags & POWERED_FLAG) == POWERED_FLAG;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    protected final IPartModel selectModel(@NotNull IPartModel offModels, @NotNull IPartModel onModels, @NotNull IPartModel hasChannelModels) {
        Intrinsics.checkNotNullParameter((Object)offModels, (String)"offModels");
        Intrinsics.checkNotNullParameter((Object)onModels, (String)"onModels");
        Intrinsics.checkNotNullParameter((Object)hasChannelModels, (String)"hasChannelModels");
        return this.isActive() ? hasChannelModels : (this.isPowered() ? onModels : offModels);
    }

    @NotNull
    public IModelData getModelData() {
        return (IModelData)new ReportingModelData(this.rotation);
    }

    public abstract boolean isLightSource();

    private final int blockLight(int emit) {
        if (this.opacity < 0) {
            TileEntity tileEntity = this.getTile();
            Intrinsics.checkNotNull((Object)tileEntity);
            World world = tileEntity.func_145831_w();
            BlockPos blockPos = tileEntity.func_174877_v();
            AEPartLocation aEPartLocation = this.getSide();
            Intrinsics.checkNotNull((Object)aEPartLocation);
            BlockPos pos = blockPos.func_177972_a(aEPartLocation.getFacing());
            Intrinsics.checkNotNull((Object)world);
            this.opacity = 255 - world.func_180495_p(pos).func_200016_a((IBlockReader)world, pos);
        }
        return (int)((float)emit * ((float)this.opacity / 255.0f));
    }

    protected static final int getPOWERED_FLAG() {
        return Companion.getPOWERED_FLAG();
    }

    protected static final int getCHANNEL_FLAG() {
        return Companion.getCHANNEL_FLAG();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u00048\u0004X\u0085D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u00020\u00048\u0004X\u0085D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lcom/the9grounds/aeadditions/parts/AbstractReportingPart$Companion;", "", "()V", "BOOTING_FLAG", "", "CHANNEL_FLAG", "getCHANNEL_FLAG$annotations", "getCHANNEL_FLAG", "()I", "POWERED_FLAG", "getPOWERED_FLAG$annotations", "getPOWERED_FLAG", "AEAdditions-1.16.5"})
    public static final class Companion {
        private Companion() {
        }

        protected final int getPOWERED_FLAG() {
            return POWERED_FLAG;
        }

        @JvmStatic
        protected static /* synthetic */ void getPOWERED_FLAG$annotations() {
        }

        protected final int getCHANNEL_FLAG() {
            return CHANNEL_FLAG;
        }

        @JvmStatic
        protected static /* synthetic */ void getCHANNEL_FLAG$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

