/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.parts;

import appeng.api.IAppEngApi;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Upgrades;
import appeng.api.parts.IPartHost;
import appeng.core.sync.network.TargetPoint;
import com.the9grounds.aeadditions.core.inv.AbstractUpgradeInventory;
import com.the9grounds.aeadditions.core.inv.IAEAInventory;
import com.the9grounds.aeadditions.core.inv.Operation;
import com.the9grounds.aeadditions.core.inv.StackUpgradeInventory;
import com.the9grounds.aeadditions.integration.appeng.AppEng;
import com.the9grounds.aeadditions.network.NetworkManager;
import com.the9grounds.aeadditions.network.packets.UpgradesUpdatedPacket;
import com.the9grounds.aeadditions.parts.AbstractBasicStatePart;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0007H\u0016J \u0010\u0019\u001a\u00020\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0016J0\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0004H\u0016J&\u0010,\u001a\u00020\u00072\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u000102H\u0016J\b\u00103\u001a\u00020\u001aH\u0016J\u0012\u00104\u001a\u00020\u001a2\b\u00105\u001a\u0004\u0018\u000106H\u0016J\b\u00107\u001a\u00020\u001aH\u0016J\u0012\u00108\u001a\u00020\u001a2\b\u00105\u001a\u0004\u0018\u000106H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0011\u0010\t\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\bR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00069"}, d2={"Lcom/the9grounds/aeadditions/parts/AbstractUpgradablePart;", "Lcom/the9grounds/aeadditions/parts/AbstractBasicStatePart;", "Lcom/the9grounds/aeadditions/core/inv/IAEAInventory;", "itemStack", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/item/ItemStack;)V", "isRemote", "", "()Z", "isSleeping", "rsMode", "Lappeng/api/config/RedstoneMode;", "getRsMode", "()Lappeng/api/config/RedstoneMode;", "upgradeSlots", "", "getUpgradeSlots", "()I", "setUpgradeSlots", "(I)V", "upgrades", "Lcom/the9grounds/aeadditions/core/inv/AbstractUpgradeInventory;", "getUpgrades", "()Lcom/the9grounds/aeadditions/core/inv/AbstractUpgradeInventory;", "canConnectRedstone", "getDrops", "", "drops", "", "wrenched", "getInstalledUpgrades", "upgrade", "Lappeng/api/config/Upgrades;", "getInventoryByName", "Lnet/minecraftforge/items/IItemHandler;", "name", "", "onInventoryChanged", "inv", "slot", "operation", "Lcom/the9grounds/aeadditions/core/inv/Operation;", "removedStack", "newStack", "onPartShiftActivate", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "hand", "Lnet/minecraft/util/Hand;", "pos", "Lnet/minecraft/util/math/vector/Vector3d;", "onUpgradesChanged", "readFromNBT", "data", "Lnet/minecraft/nbt/CompoundNBT;", "sendUpgradesToClient", "writeToNBT", "AEAdditions-1.16.5"})
public abstract class AbstractUpgradablePart
extends AbstractBasicStatePart
implements IAEAInventory {
    private int upgradeSlots;
    @NotNull
    private final AbstractUpgradeInventory upgrades;
    @Nullable
    private final RedstoneMode rsMode;

    public AbstractUpgradablePart(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        super(itemStack);
        this.upgradeSlots = 4;
        this.upgrades = new StackUpgradeInventory(itemStack, this, this.getUpgradeSlots());
    }

    public int getUpgradeSlots() {
        return this.upgradeSlots;
    }

    public void setUpgradeSlots(int n) {
        this.upgradeSlots = n;
    }

    @NotNull
    public final AbstractUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    @Nullable
    public RedstoneMode getRsMode() {
        return this.rsMode;
    }

    public final boolean isSleeping() {
        if (this.getInstalledUpgrades(Upgrades.REDSTONE) > 0) {
            RedstoneMode redstoneMode = this.getRsMode();
            int n = redstoneMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[redstoneMode.ordinal()];
            switch (n) {
                case 1: {
                    return false;
                }
                case 2: {
                    IPartHost iPartHost = this.getHost();
                    Intrinsics.checkNotNull((Object)iPartHost);
                    if (!iPartHost.hasRedstone(this.getSide())) break;
                    return false;
                }
                case 3: {
                    IPartHost iPartHost = this.getHost();
                    Intrinsics.checkNotNull((Object)iPartHost);
                    if (iPartHost.hasRedstone(this.getSide())) break;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isRemote() {
        return this.getLocation().getWorld().field_72995_K;
    }

    @Override
    public int getInstalledUpgrades(@NotNull Upgrades upgrade) {
        Intrinsics.checkNotNullParameter((Object)upgrade, (String)"upgrade");
        return this.upgrades.getInstalledUpgrades(upgrade);
    }

    @Override
    public void readFromNBT(@Nullable CompoundNBT data) {
        super.readFromNBT(data);
        Intrinsics.checkNotNull((Object)data);
        this.upgrades.readFromNBT(data, "upgrades");
    }

    @Override
    public void writeToNBT(@Nullable CompoundNBT data) {
        super.writeToNBT(data);
        Intrinsics.checkNotNull((Object)data);
        this.upgrades.writeToNBT(data, "upgrades");
    }

    @Override
    public void getDrops(@Nullable List<ItemStack> drops, boolean wrenched) {
        boolean bl = drops != null;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        for (ItemStack upgrade : this.upgrades) {
            Intrinsics.checkNotNull((Object)upgrade);
            if (upgrade.func_190926_b()) continue;
            drops.add(upgrade);
        }
    }

    @Override
    @Nullable
    public IItemHandler getInventoryByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (Intrinsics.areEqual((Object)name, (Object)"upgrades")) {
            return (IItemHandler)this.upgrades;
        }
        return null;
    }

    @Override
    public boolean canConnectRedstone() {
        return this.getInstalledUpgrades(Upgrades.REDSTONE) > 0;
    }

    @Override
    public void onInventoryChanged(@NotNull IItemHandler inv, int slot, @NotNull Operation operation, @NotNull ItemStack removedStack, @NotNull ItemStack newStack) {
        Intrinsics.checkNotNullParameter((Object)inv, (String)"inv");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        Intrinsics.checkNotNullParameter((Object)removedStack, (String)"removedStack");
        Intrinsics.checkNotNullParameter((Object)newStack, (String)"newStack");
        if (Intrinsics.areEqual((Object)inv, (Object)this.upgrades)) {
            this.onUpgradesChanged();
            this.sendUpgradesToClient();
        }
    }

    @Override
    public void sendUpgradesToClient() {
        NetworkManager.INSTANCE.sendToAllAround(new UpgradesUpdatedPacket(this.upgrades.getUpgradeMap()), new TargetPoint((double)this.getLocation().x, (double)this.getLocation().y, (double)this.getLocation().z, 32.0, this.getLocation().getWorld()));
    }

    @Override
    public boolean onPartShiftActivate(@Nullable PlayerEntity player, @Nullable Hand hand, @Nullable Vector3d pos) {
        ItemStack itemStack;
        if (player != null && !(itemStack = player.func_184586_b(hand)).func_190926_b()) {
            int slot;
            Item item2 = itemStack.func_77973_b();
            IAppEngApi iAppEngApi = AppEng.Companion.getAPI();
            Intrinsics.checkNotNull((Object)iAppEngApi);
            if (item2 == iAppEngApi.definitions().materials().cardSpeed().item() && (slot = this.upgrades.fetchFirstEmptySlot()) != -1) {
                ItemStack itemStack2 = itemStack.func_77946_l();
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"itemStack.copy()");
                ItemStack returnStack = this.upgrades.insertItem(slot, itemStack2, false);
                player.func_184611_a(hand, returnStack);
                return true;
            }
        }
        return super.onPartShiftActivate(player, hand, pos);
    }

    public void onUpgradesChanged() {
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RedstoneMode.values().length];
            nArray[RedstoneMode.IGNORE.ordinal()] = 1;
            nArray[RedstoneMode.HIGH_SIGNAL.ordinal()] = 2;
            nArray[RedstoneMode.LOW_SIGNAL.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

