/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.parts;

import appeng.api.config.RedstoneMode;
import appeng.api.config.Upgrades;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.parts.IPartHost;
import appeng.api.storage.IStorageChannel;
import appeng.me.GridAccessException;
import com.the9grounds.aeadditions.api.IAEAChemicalConfig;
import com.the9grounds.aeadditions.api.IAEAHasChemicalConfig;
import com.the9grounds.aeadditions.api.chemical.IAEChemicalStack;
import com.the9grounds.aeadditions.core.AEAChemicalConfig;
import com.the9grounds.aeadditions.parts.AbstractUpgradablePart;
import com.the9grounds.aeadditions.util.StorageChannels;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mekanism.api.chemical.Chemical;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0011H\u0004J\b\u0010\u0012\u001a\u00020\u000bH\u0004J\b\u0010\u0013\u001a\u00020\u0014H&J\b\u0010\u0015\u001a\u00020\u000bH\u0004J\b\u0010\u0016\u001a\u00020\u0007H\u0016J\u0014\u0010\u0017\u001a\u00020\u000b2\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019H\u0004J&\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010!\u001a\u00020\u001bH\u0016J\u0012\u0010\"\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\b\u0010%\u001a\u00020\u001bH\u0004J\u0012\u0010&\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006'"}, d2={"Lcom/the9grounds/aeadditions/parts/SharedIOBus;", "Lcom/the9grounds/aeadditions/parts/AbstractUpgradablePart;", "Lcom/the9grounds/aeadditions/api/IAEAHasChemicalConfig;", "itemStack", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/item/ItemStack;)V", "_chemicalConfig", "Lcom/the9grounds/aeadditions/api/IAEAChemicalConfig;", "get_chemicalConfig", "()Lcom/the9grounds/aeadditions/api/IAEAChemicalConfig;", "lastRedstone", "", "getLastRedstone", "()Z", "setLastRedstone", "(Z)V", "calculateThroughput", "", "canDoBusWork", "doWork", "Lappeng/api/networking/ticking/TickRateModulation;", "filterEnabled", "getChemicalConfig", "isInFilter", "chemical", "Lmekanism/api/chemical/Chemical;", "onNeighborChanged", "", "w", "Lnet/minecraft/world/IBlockReader;", "pos", "Lnet/minecraft/util/math/BlockPos;", "neighbor", "onUpgradesChanged", "readFromNBT", "data", "Lnet/minecraft/nbt/CompoundNBT;", "updateState", "writeToNBT", "AEAdditions-1.16.5"})
public abstract class SharedIOBus
extends AbstractUpgradablePart
implements IAEAHasChemicalConfig {
    @NotNull
    private final IAEAChemicalConfig _chemicalConfig;
    private boolean lastRedstone;

    public SharedIOBus(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        super(itemStack);
        this._chemicalConfig = new AEAChemicalConfig(9);
    }

    @NotNull
    public final IAEAChemicalConfig get_chemicalConfig() {
        return this._chemicalConfig;
    }

    @Override
    @NotNull
    public IAEAChemicalConfig getChemicalConfig() {
        return this._chemicalConfig;
    }

    public final boolean getLastRedstone() {
        return this.lastRedstone;
    }

    public final void setLastRedstone(boolean bl) {
        this.lastRedstone = bl;
    }

    @Override
    public void readFromNBT(@Nullable CompoundNBT data) {
        super.readFromNBT(data);
        Intrinsics.checkNotNull((Object)data);
        this._chemicalConfig.readFromNbt(data, "config");
    }

    @Override
    public void writeToNBT(@Nullable CompoundNBT data) {
        super.writeToNBT(data);
        Intrinsics.checkNotNull((Object)data);
        this._chemicalConfig.writeToNbt(data, "config");
    }

    @NotNull
    public abstract TickRateModulation doWork();

    @Override
    public void onUpgradesChanged() {
        this.updateState();
    }

    @Override
    public void onNeighborChanged(@Nullable IBlockReader w, @Nullable BlockPos pos, @Nullable BlockPos neighbor) {
        this.updateState();
        IPartHost iPartHost = this.getHost();
        Intrinsics.checkNotNull((Object)iPartHost);
        if (this.lastRedstone != iPartHost.hasRedstone(this.getSide())) {
            boolean bl = this.lastRedstone = !this.lastRedstone;
            if (this.lastRedstone && this.getRsMode() == RedstoneMode.SIGNAL_PULSE) {
                this.doWork();
            }
        }
        super.onNeighborChanged(w, pos, neighbor);
    }

    protected final void updateState() {
        try {
            if (this.isSleeping()) {
                this.getProxy().getTick().sleepDevice(this.getProxy().getNode());
            } else {
                this.getProxy().getTick().wakeDevice(this.getProxy().getNode());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    protected final boolean canDoBusWork() {
        IPartHost iPartHost = this.getHost();
        Intrinsics.checkNotNull((Object)iPartHost);
        TileEntity tileEntity = iPartHost.getTile();
        Intrinsics.checkNotNullExpressionValue((Object)tileEntity, (String)"this.host!!.getTile()");
        TileEntity self = tileEntity;
        BlockPos blockPos = self.func_174877_v();
        iPartHost = this.getSide();
        Intrinsics.checkNotNull((Object)iPartHost);
        BlockPos selfPos = blockPos.func_177972_a(iPartHost.getFacing());
        World world = self.func_145831_w();
        return world != null && world.func_72863_F().func_222866_a(selfPos) && this.getProxy().isActive();
    }

    protected final long calculateThroughput() {
        double d;
        IStorageChannel<IAEChemicalStack> iStorageChannel = StorageChannels.INSTANCE.getCHEMICAL();
        Intrinsics.checkNotNull(iStorageChannel);
        double amount = iStorageChannel.transferFactor();
        int n = this.getInstalledUpgrades(Upgrades.SPEED);
        switch (n) {
            case 4: {
                d = amount * (double)8 * (double)4 * (double)2 * 1.5;
                break;
            }
            case 3: {
                d = amount * (double)8 * (double)4 * (double)2;
                break;
            }
            case 2: {
                d = amount * (double)8 * (double)4;
                break;
            }
            case 1: {
                d = amount * (double)8;
                break;
            }
            default: {
                boolean bl = false;
                d = Math.floor(amount);
            }
        }
        amount = d;
        n = 0;
        return (long)Math.floor(amount);
    }

    protected final boolean isInFilter(@NotNull Chemical<?> chemical) {
        Intrinsics.checkNotNullParameter(chemical, (String)"chemical");
        for (Chemical item2 : this._chemicalConfig) {
            if (!Intrinsics.areEqual(chemical, (Object)item2)) continue;
            return true;
        }
        return false;
    }

    protected final boolean filterEnabled() {
        for (Chemical chemical : this._chemicalConfig) {
            if (chemical == null) continue;
            return true;
        }
        return false;
    }
}

