/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.parts.chemical;

import appeng.api.IAppEngApi;
import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.MachineSource;
import appeng.parts.PartModel;
import com.the9grounds.aeadditions.api.chemical.IAEChemicalStack;
import com.the9grounds.aeadditions.container.ContainerOpener;
import com.the9grounds.aeadditions.container.Locator;
import com.the9grounds.aeadditions.container.chemical.ChemicalIOContainer;
import com.the9grounds.aeadditions.core.TickRates;
import com.the9grounds.aeadditions.integration.Mods;
import com.the9grounds.aeadditions.integration.appeng.AppEng;
import com.the9grounds.aeadditions.integration.mekanism.Mekanism;
import com.the9grounds.aeadditions.integration.mekanism.chemical.AEChemicalStack;
import com.the9grounds.aeadditions.parts.SharedIOBus;
import com.the9grounds.aeadditions.util.StorageChannels;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J&\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0016\u00a8\u0006\""}, d2={"Lcom/the9grounds/aeadditions/parts/chemical/ChemicalExportBus;", "Lcom/the9grounds/aeadditions/parts/SharedIOBus;", "Lappeng/api/networking/ticking/IGridTickable;", "itemStack", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/item/ItemStack;)V", "doWork", "Lappeng/api/networking/ticking/TickRateModulation;", "getBoxes", "", "bch", "Lappeng/api/parts/IPartCollisionHelper;", "getCableConnectionLength", "", "cable", "Lappeng/api/util/AECableType;", "getStaticModels", "Lappeng/api/parts/IPartModel;", "getTickingRequest", "Lappeng/api/networking/ticking/TickingRequest;", "node", "Lappeng/api/networking/IGridNode;", "onPartActivate", "", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "hand", "Lnet/minecraft/util/Hand;", "pos", "Lnet/minecraft/util/math/vector/Vector3d;", "tickingRequest", "ticksSinceLastCall", "", "Companion", "AEAdditions-1.16.5"})
public final class ChemicalExportBus
extends SharedIOBus
implements IGridTickable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ResourceLocation MODEL_BASE = new ResourceLocation("aeadditions", "part/chemical/export_bus_base");
    @PartModels
    @NotNull
    private static final PartModel MODELS_OFF;
    @PartModels
    @NotNull
    private static final PartModel MODELS_ON;
    @PartModels
    @NotNull
    private static final PartModel MODELS_HAS_CHANNEL;

    public ChemicalExportBus(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        super(itemStack);
    }

    @NotNull
    public IPartModel getStaticModels() {
        return this.isActive() && this.isPowered() ? (IPartModel)MODELS_HAS_CHANNEL : (this.isPowered() ? (IPartModel)MODELS_ON : (IPartModel)MODELS_OFF);
    }

    @Override
    public void getBoxes(@Nullable IPartCollisionHelper bch) {
        Intrinsics.checkNotNull((Object)bch);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 13.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
    }

    @Override
    public float getCableConnectionLength(@Nullable AECableType cable) {
        return 5.0f;
    }

    @Override
    public boolean onPartActivate(@Nullable PlayerEntity player, @Nullable Hand hand, @Nullable Vector3d pos) {
        if (!this.isRemote()) {
            ContainerType<ChemicalIOContainer> containerType = ChemicalIOContainer.Companion.getEXPORT_BUS();
            Intrinsics.checkNotNull((Object)player);
            ContainerOpener.INSTANCE.openContainer(containerType, player, Locator.Companion.forPart(this));
        }
        return true;
    }

    @NotNull
    public TickingRequest getTickingRequest(@NotNull IGridNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return new TickingRequest(TickRates.ChemicalExportBus.getMin(), TickRates.ChemicalExportBus.getMax(), this.isSleeping(), false);
    }

    @NotNull
    public TickRateModulation tickingRequest(@NotNull IGridNode node, int ticksSinceLastCall) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.canDoBusWork() && Mods.MEKANISM.isEnabled() ? this.doWork() : TickRateModulation.IDLE;
    }

    @Override
    @NotNull
    public TickRateModulation doWork() {
        if (!this.canDoBusWork()) {
            return TickRateModulation.IDLE;
        }
        if (this.getFacingChemicalTank() == null) {
            return TickRateModulation.SLOWER;
        }
        try {
            boolean bl = false;
            Map alreadyUsedChemicals = new LinkedHashMap();
            boolean didWork = false;
            for (Chemical item2 : this.getChemicalConfig()) {
                if (item2 == null || alreadyUsedChemicals.containsKey(item2)) continue;
                Map map = alreadyUsedChemicals;
                Boolean bl2 = true;
                boolean bl3 = false;
                map.put(item2, bl2);
                AEChemicalStack aeChemicalStack = new AEChemicalStack(item2);
                aeChemicalStack.setStackSize(this.calculateThroughput());
                Object object = AppEng.Companion.getAPI();
                Intrinsics.checkNotNull((Object)object);
                IAEChemicalStack iAEChemicalStack = (IAEChemicalStack)object.storage().poweredExtraction(this.getPowerSource(), (IMEInventory)this.getProxy().getStorage().getInventory(StorageChannels.INSTANCE.getCHEMICAL()), (IAEStack)aeChemicalStack, (IActionSource)new MachineSource((IActionHost)this), Actionable.SIMULATE);
                if (iAEChemicalStack == null) continue;
                IAEChemicalStack extracted = iAEChemicalStack;
                object = this.getFacingChemicalTank();
                Intrinsics.checkNotNull((Object)object);
                IAppEngApi iAppEngApi = object;
                AEPartLocation aEPartLocation = this.getSide();
                Intrinsics.checkNotNull((Object)aEPartLocation);
                object = aEPartLocation.getFacing().func_176734_d();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"side!!.facing.opposite");
                ChemicalStack<?> remaining = Mekanism.INSTANCE.insertChemicalForChemicalCapability((TileEntity)iAppEngApi, (Direction)object, extracted.getChemicalStack(), Action.EXECUTE);
                if (remaining != null && remaining.getAmount() > 0L) {
                    object = extracted;
                    object.setStackSize(object.getStackSize() - remaining.getAmount());
                }
                object = AppEng.Companion.getAPI();
                Intrinsics.checkNotNull((Object)object);
                object.storage().poweredExtraction(this.getPowerSource(), (IMEInventory)this.getProxy().getStorage().getInventory(StorageChannels.INSTANCE.getCHEMICAL()), (IAEStack)extracted, (IActionSource)new MachineSource((IActionHost)this), Actionable.MODULATE);
                didWork = true;
            }
            if (didWork) {
                return TickRateModulation.FASTER;
            }
            return TickRateModulation.SLOWER;
        }
        catch (GridAccessException gridAccessException) {
            return TickRateModulation.SLEEP;
        }
    }

    static {
        ResourceLocation[] resourceLocationArray = new ResourceLocation[]{MODEL_BASE, new ResourceLocation("aeadditions", "part/chemical/export_bus_off")};
        MODELS_OFF = new PartModel(resourceLocationArray);
        resourceLocationArray = new ResourceLocation[]{MODEL_BASE, new ResourceLocation("aeadditions", "part/chemical/export_bus_on")};
        MODELS_ON = new PartModel(resourceLocationArray);
        resourceLocationArray = new ResourceLocation[]{MODEL_BASE, new ResourceLocation("aeadditions", "part/chemical/export_bus_has_channel")};
        MODELS_HAS_CHANNEL = new PartModel(resourceLocationArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0016\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/the9grounds/aeadditions/parts/chemical/ChemicalExportBus$Companion;", "", "()V", "MODELS_HAS_CHANNEL", "Lappeng/parts/PartModel;", "getMODELS_HAS_CHANNEL", "()Lappeng/parts/PartModel;", "MODELS_OFF", "getMODELS_OFF", "MODELS_ON", "getMODELS_ON", "MODEL_BASE", "Lnet/minecraft/util/ResourceLocation;", "getMODEL_BASE", "()Lnet/minecraft/util/ResourceLocation;", "AEAdditions-1.16.5"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getMODEL_BASE() {
            return MODEL_BASE;
        }

        @NotNull
        public final PartModel getMODELS_OFF() {
            return MODELS_OFF;
        }

        @NotNull
        public final PartModel getMODELS_ON() {
            return MODELS_ON;
        }

        @NotNull
        public final PartModel getMODELS_HAS_CHANNEL() {
            return MODELS_HAS_CHANNEL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

