/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.parts.fluid;

import appeng.api.IAppEngApi;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.fluids.items.FluidDummyItem;
import appeng.fluids.util.AEFluidStack;
import appeng.items.parts.PartModels;
import appeng.me.helpers.PlayerSource;
import appeng.parts.PartModel;
import com.the9grounds.aeadditions.LoggerKt;
import com.the9grounds.aeadditions.integration.appeng.AppEng;
import com.the9grounds.aeadditions.network.NetworkManager;
import com.the9grounds.aeadditions.network.packets.UpdateSlotInHandPacket;
import com.the9grounds.aeadditions.parts.AbstractConversionMonitorPart;
import com.the9grounds.aeadditions.parts.AbstractDisplayPart;
import com.the9grounds.aeadditions.util.FluidSounds;
import com.the9grounds.aeadditions.util.StorageChannels;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J$\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0014J\u001c\u0010\r\u001a\u00020\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u00022\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\u00020\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014\u00a8\u0006\u0018"}, d2={"Lcom/the9grounds/aeadditions/parts/fluid/FluidConversionMonitorPart;", "Lcom/the9grounds/aeadditions/parts/AbstractConversionMonitorPart;", "Lappeng/api/storage/data/IAEFluidStack;", "itemStack", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/item/ItemStack;)V", "canExtractOrInsertFromHeldItem", "", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "hand", "Lnet/minecraft/util/Hand;", "extract", "extractStack", "", "getStackFromHeldItem", "getStaticModels", "Lappeng/api/parts/IPartModel;", "getStorageChannel", "Lappeng/api/storage/IStorageChannel;", "getWatchedItemName", "", "insertStack", "Companion", "AEAdditions-1.16.5"})
public final class FluidConversionMonitorPart
extends AbstractConversionMonitorPart<IAEFluidStack> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @PartModels
    @NotNull
    private static final ResourceLocation MODEL_OFF = new ResourceLocation("aeadditions", "part/fluid/conversion_monitor_off");
    @PartModels
    @NotNull
    private static final ResourceLocation MODEL_ON = new ResourceLocation("aeadditions", "part/fluid/conversion_monitor_on");
    @PartModels
    @NotNull
    private static final ResourceLocation MODEL_LOCKED_OFF = new ResourceLocation("aeadditions", "part/fluid/conversion_monitor_locked_off");
    @PartModels
    @NotNull
    private static final ResourceLocation MODEL_LOCKED_ON = new ResourceLocation("aeadditions", "part/fluid/conversion_monitor_locked_on");
    @NotNull
    private static final PartModel MODELS_ON;
    @NotNull
    private static final PartModel MODELS_OFF;
    @NotNull
    private static final PartModel MODELS_HAS_CHANNEL;
    @NotNull
    private static final PartModel MODELS_LOCKED_ON;
    @NotNull
    private static final PartModel MODELS_LOCKED_OFF;
    @NotNull
    private static final PartModel MODELS_LOCKED_HAS_CHANNEL;

    public FluidConversionMonitorPart(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        super(itemStack);
    }

    @NotNull
    public IPartModel getStaticModels() {
        return this.selectModel((IPartModel)MODELS_ON, (IPartModel)MODELS_OFF, (IPartModel)MODELS_HAS_CHANNEL, (IPartModel)MODELS_LOCKED_ON, (IPartModel)MODELS_LOCKED_OFF, (IPartModel)MODELS_LOCKED_HAS_CHANNEL);
    }

    @Override
    protected boolean canExtractOrInsertFromHeldItem(@Nullable PlayerEntity player, @Nullable Hand hand, boolean extract) {
        IAEFluidStack localWatchedItem = (IAEFluidStack)this.getWatchedItem();
        if (localWatchedItem == null && !extract) {
            return false;
        }
        Intrinsics.checkNotNull((Object)player);
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b()) {
            return false;
        }
        Optional fluidInItem = FluidUtil.getFluidContained((ItemStack)heldItem);
        if (extract) {
            return fluidInItem.isPresent();
        }
        if (fluidInItem.isPresent()) {
            Fluid fluid = ((FluidStack)fluidInItem.get()).getFluid();
            Intrinsics.checkNotNull((Object)localWatchedItem);
            if (Intrinsics.areEqual((Object)fluid, (Object)localWatchedItem.getFluid())) {
                return true;
            }
        }
        return !fluidInItem.isPresent();
    }

    @Override
    protected void insertStack(@Nullable PlayerEntity player, @Nullable Hand hand) {
        IAEFluidStack iAEFluidStack = (IAEFluidStack)this.getWatchedItem();
        if (iAEFluidStack == null) {
            return;
        }
        IAEFluidStack localWatchedItem = iAEFluidStack;
        Intrinsics.checkNotNull((Object)player);
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b()) {
            return;
        }
        IFluidHandlerItem iFluidHandlerItem = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)heldItem).orElse(null);
        if (iFluidHandlerItem == null) {
            return;
        }
        IFluidHandlerItem fluidHandler = iFluidHandlerItem;
        IMEMonitor monitor = this.getProxy().getStorage().getInventory(this.getStorageChannel());
        PlayerSource source = new PlayerSource(player, (IActionHost)this);
        IAEFluidStack stack = localWatchedItem.copy();
        stack.setStackSize(Integer.MAX_VALUE);
        int amountAllowed = fluidHandler.fill(stack.getFluidStack(), IFluidHandler.FluidAction.SIMULATE);
        stack.setStackSize((long)amountAllowed);
        IAppEngApi iAppEngApi = AppEng.Companion.getAPI();
        Intrinsics.checkNotNull((Object)iAppEngApi);
        IAEFluidStack canPull = (IAEFluidStack)iAppEngApi.storage().poweredExtraction(this.getPowerSource(), (IMEInventory)monitor, (IAEStack)stack, (IActionSource)source, Actionable.SIMULATE);
        if (canPull == null || canPull.getStackSize() < 1L) {
            return;
        }
        int canFill = fluidHandler.fill(canPull.getFluidStack(), IFluidHandler.FluidAction.SIMULATE);
        if (canFill == 0) {
            return;
        }
        stack.setStackSize((long)canFill);
        IAppEngApi iAppEngApi2 = AppEng.Companion.getAPI();
        Intrinsics.checkNotNull((Object)iAppEngApi2);
        IAEFluidStack pulled = (IAEFluidStack)iAppEngApi2.storage().poweredExtraction(this.getPowerSource(), (IMEInventory)monitor, (IAEStack)stack, (IActionSource)source, Actionable.MODULATE);
        if (pulled == null || pulled.getStackSize() < 1L) {
            LoggerKt.getLogger().info("Unable to pull fluid out of the ME system even though the simulation said yes");
            return;
        }
        int filled = fluidHandler.fill(pulled.getFluidStack(), IFluidHandler.FluidAction.EXECUTE);
        if (filled != canFill) {
            LoggerKt.getLogger().warn("Filled is different than can fill for {}", (Object)heldItem.func_200301_q());
        }
        if (filled != (int)pulled.getStackSize()) {
            int insert = (int)pulled.getStackSize() - filled;
            IAEFluidStack stackToInsert = stack.copy();
            stackToInsert.setStackSize((long)insert);
            monitor.injectItems((IAEStack)stackToInsert, Actionable.MODULATE, (IActionSource)source);
            LoggerKt.getLogger().warn("Pulled amount did not equal filled, inserting difference back into system");
        }
        FluidStack insert = pulled.getFluidStack();
        Intrinsics.checkNotNullExpressionValue((Object)insert, (String)"pulled.fluidStack");
        FluidSounds.INSTANCE.playFillSound(player, insert);
        Hand hand2 = hand;
        int n = hand2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[hand2.ordinal()];
        EquipmentSlotType slot = n == 1 ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
        player.func_184201_a(slot, fluidHandler.getContainer());
        hand2 = fluidHandler.getContainer();
        Intrinsics.checkNotNullExpressionValue((Object)hand2, (String)"fluidHandler.container");
        NetworkManager.INSTANCE.sendTo(new UpdateSlotInHandPacket(slot, (ItemStack)hand2), (ServerPlayerEntity)player);
    }

    @Override
    protected void extractStack(@Nullable PlayerEntity player, @Nullable Hand hand) {
        Hand hand2;
        FluidStack storable;
        IAppEngApi iAppEngApi;
        Intrinsics.checkNotNull((Object)player);
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b()) {
            return;
        }
        IFluidHandlerItem iFluidHandlerItem = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)heldItem).orElse(null);
        if (iFluidHandlerItem == null) {
            return;
        }
        IFluidHandlerItem fluidHandler = iFluidHandlerItem;
        IMEMonitor monitor = this.getProxy().getStorage().getInventory(this.getStorageChannel());
        PlayerSource source = new PlayerSource(player, (IActionHost)this);
        FluidStack fluidStack = fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
        Intrinsics.checkNotNullExpressionValue((Object)fluidStack, (String)"fluidHandler.drain(Int.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE)");
        FluidStack extract = fluidStack;
        if (extract.isEmpty() || extract.getAmount() < 1) {
            return;
        }
        IAppEngApi iAppEngApi2 = AppEng.Companion.getAPI();
        Intrinsics.checkNotNull((Object)iAppEngApi2);
        IAEFluidStack notStorable = (IAEFluidStack)iAppEngApi2.storage().poweredInsert(this.getPowerSource(), (IMEInventory)monitor, (IAEStack)AEFluidStack.fromFluidStack((FluidStack)extract), (IActionSource)source, Actionable.SIMULATE);
        if (notStorable != null && notStorable.getStackSize() > 0L) {
            int toStore = (int)((long)extract.getAmount() - notStorable.getStackSize());
            iAppEngApi = fluidHandler.drain(toStore, IFluidHandler.FluidAction.SIMULATE);
            Intrinsics.checkNotNullExpressionValue((Object)iAppEngApi, (String)"fluidHandler.drain(toStore, IFluidHandler.FluidAction.SIMULATE)");
            storable = iAppEngApi;
            if (storable.isEmpty() || storable.getAmount() == 0) {
                return;
            }
            extract.setAmount(storable.getAmount());
        }
        storable = fluidHandler.drain(extract, IFluidHandler.FluidAction.EXECUTE);
        Intrinsics.checkNotNullExpressionValue((Object)storable, (String)"fluidHandler.drain(extract, IFluidHandler.FluidAction.EXECUTE)");
        FluidStack drained = storable;
        extract.setAmount(drained.getAmount());
        iAppEngApi = AppEng.Companion.getAPI();
        Intrinsics.checkNotNull((Object)iAppEngApi);
        IAEFluidStack notInserted = (IAEFluidStack)iAppEngApi.storage().poweredInsert(this.getPowerSource(), (IMEInventory)monitor, (IAEStack)AEFluidStack.fromFluidStack((FluidStack)extract), (IActionSource)source, Actionable.MODULATE);
        if (notInserted != null && notInserted.getStackSize() > 0L) {
            LoggerKt.getLogger().error("Fluid item {} reported a different possible amount to drain than it actually provided.", (Object)heldItem.func_200301_q());
            fluidHandler.fill(notInserted.getFluidStack(), IFluidHandler.FluidAction.EXECUTE);
        }
        int n = (hand2 = hand) == null ? -1 : WhenMappings.$EnumSwitchMapping$0[hand2.ordinal()];
        EquipmentSlotType slot = n == 1 ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND;
        player.func_184201_a(slot, fluidHandler.getContainer());
        hand2 = fluidHandler.getContainer();
        Intrinsics.checkNotNullExpressionValue((Object)hand2, (String)"fluidHandler.container");
        NetworkManager.INSTANCE.sendTo(new UpdateSlotInHandPacket(slot, (ItemStack)hand2), (ServerPlayerEntity)player);
        FluidSounds.INSTANCE.playEmptySound(player, extract);
    }

    @Override
    @NotNull
    public String getWatchedItemName() {
        IAEFluidStack iAEFluidStack = (IAEFluidStack)this.getWatchedItem();
        Intrinsics.checkNotNull((Object)iAEFluidStack);
        ItemStack itemStack = iAEFluidStack.asItemStackRepresentation();
        Item item2 = itemStack.func_77973_b();
        if (item2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type appeng.fluids.items.FluidDummyItem");
        }
        FluidDummyItem item3 = (FluidDummyItem)item2;
        FluidStack fluidStack = item3.getFluidStack(itemStack);
        String string = new TranslationTextComponent(fluidStack.getTranslationKey()).getString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TranslationTextComponent(fluidStack.translationKey).string");
        return string;
    }

    @Override
    @Nullable
    public IAEFluidStack getStackFromHeldItem(@Nullable PlayerEntity player, @Nullable Hand hand) {
        FluidStack fluidStack;
        Intrinsics.checkNotNull((Object)player);
        ItemStack itemStack = player.func_184586_b(hand);
        if (itemStack == null) {
            return null;
        }
        ItemStack heldItem = itemStack;
        Optional optional = FluidUtil.getFluidContained((ItemStack)heldItem);
        FluidStack fluidStack2 = fluidStack = optional == null ? null : (FluidStack)optional.orElse(null);
        if (fluidStack == null) {
            return null;
        }
        FluidStack fluidStack3 = fluidStack;
        return (IAEFluidStack)AEFluidStack.fromFluidStack((FluidStack)fluidStack3);
    }

    @Override
    @NotNull
    public IStorageChannel<IAEFluidStack> getStorageChannel() {
        return (IStorageChannel)StorageChannels.INSTANCE.getFLUID();
    }

    static {
        ResourceLocation[] resourceLocationArray = new ResourceLocation[]{AbstractDisplayPart.Companion.getMODEL_BASE(), MODEL_ON, AbstractDisplayPart.Companion.getMODEL_STATUS_ON()};
        MODELS_ON = new PartModel(resourceLocationArray);
        resourceLocationArray = new ResourceLocation[]{AbstractDisplayPart.Companion.getMODEL_BASE(), MODEL_OFF, AbstractDisplayPart.Companion.getMODEL_STATUS_OFF()};
        MODELS_OFF = new PartModel(resourceLocationArray);
        resourceLocationArray = new ResourceLocation[]{AbstractDisplayPart.Companion.getMODEL_BASE(), MODEL_ON, AbstractDisplayPart.Companion.getMODEL_STATUS_HAS_CHANNEL()};
        MODELS_HAS_CHANNEL = new PartModel(resourceLocationArray);
        resourceLocationArray = new ResourceLocation[]{AbstractDisplayPart.Companion.getMODEL_BASE(), MODEL_LOCKED_ON, AbstractDisplayPart.Companion.getMODEL_STATUS_ON()};
        MODELS_LOCKED_ON = new PartModel(resourceLocationArray);
        resourceLocationArray = new ResourceLocation[]{AbstractDisplayPart.Companion.getMODEL_BASE(), MODEL_LOCKED_OFF, AbstractDisplayPart.Companion.getMODEL_STATUS_OFF()};
        MODELS_LOCKED_OFF = new PartModel(resourceLocationArray);
        resourceLocationArray = new ResourceLocation[]{AbstractDisplayPart.Companion.getMODEL_BASE(), MODEL_LOCKED_ON, AbstractDisplayPart.Companion.getMODEL_STATUS_HAS_CHANNEL()};
        MODELS_LOCKED_HAS_CHANNEL = new PartModel(resourceLocationArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0016\u0010\u0011\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0016\u0010\u0017\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u0016\u0010\u0019\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014\u00a8\u0006\u001b"}, d2={"Lcom/the9grounds/aeadditions/parts/fluid/FluidConversionMonitorPart$Companion;", "", "()V", "MODELS_HAS_CHANNEL", "Lappeng/parts/PartModel;", "getMODELS_HAS_CHANNEL", "()Lappeng/parts/PartModel;", "MODELS_LOCKED_HAS_CHANNEL", "getMODELS_LOCKED_HAS_CHANNEL", "MODELS_LOCKED_OFF", "getMODELS_LOCKED_OFF", "MODELS_LOCKED_ON", "getMODELS_LOCKED_ON", "MODELS_OFF", "getMODELS_OFF", "MODELS_ON", "getMODELS_ON", "MODEL_LOCKED_OFF", "Lnet/minecraft/util/ResourceLocation;", "getMODEL_LOCKED_OFF", "()Lnet/minecraft/util/ResourceLocation;", "MODEL_LOCKED_ON", "getMODEL_LOCKED_ON", "MODEL_OFF", "getMODEL_OFF", "MODEL_ON", "getMODEL_ON", "AEAdditions-1.16.5"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getMODEL_OFF() {
            return MODEL_OFF;
        }

        @NotNull
        public final ResourceLocation getMODEL_ON() {
            return MODEL_ON;
        }

        @NotNull
        public final ResourceLocation getMODEL_LOCKED_OFF() {
            return MODEL_LOCKED_OFF;
        }

        @NotNull
        public final ResourceLocation getMODEL_LOCKED_ON() {
            return MODEL_LOCKED_ON;
        }

        @NotNull
        public final PartModel getMODELS_ON() {
            return MODELS_ON;
        }

        @NotNull
        public final PartModel getMODELS_OFF() {
            return MODELS_OFF;
        }

        @NotNull
        public final PartModel getMODELS_HAS_CHANNEL() {
            return MODELS_HAS_CHANNEL;
        }

        @NotNull
        public final PartModel getMODELS_LOCKED_ON() {
            return MODELS_LOCKED_ON;
        }

        @NotNull
        public final PartModel getMODELS_LOCKED_OFF() {
            return MODELS_LOCKED_OFF;
        }

        @NotNull
        public final PartModel getMODELS_LOCKED_HAS_CHANNEL() {
            return MODELS_LOCKED_HAS_CHANNEL;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Hand.values().length];
            nArray[Hand.MAIN_HAND.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

