/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.sync.gui;

import com.the9grounds.aeadditions.LoggerKt;
import com.the9grounds.aeadditions.network.AEAPacketBuffer;
import com.the9grounds.aeadditions.sync.gui.Field;
import com.the9grounds.aeadditions.sync.gui.GuiSync;
import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00022\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016R'\u0010\u0005\u001a\u0018\u0012\u0004\u0012\u00020\u0007\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00028\u00000\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/the9grounds/aeadditions/sync/gui/DataSync;", "T", "", "host", "(Ljava/lang/Object;)V", "fields", "", "", "Lcom/the9grounds/aeadditions/sync/gui/Field;", "getFields", "()Ljava/util/Map;", "getHost", "()Ljava/lang/Object;", "collectMutableProperties", "", "clazz", "Lkotlin/reflect/KClass;", "hasChanges", "", "hasFields", "readUpdate", "data", "Lcom/the9grounds/aeadditions/network/AEAPacketBuffer;", "writeFields", "includeUnchanged", "writeFull", "writeUpdate", "AEAdditions-1.16.5"})
public final class DataSync<T> {
    @NotNull
    private final Object host;
    @NotNull
    private final Map<String, Field<?, T>> fields;

    public DataSync(@NotNull Object host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.host = host;
        boolean bl = false;
        this.fields = new LinkedHashMap();
        this.collectMutableProperties(this.host, Reflection.getOrCreateKotlinClass(this.host.getClass()));
    }

    @NotNull
    public final Object getHost() {
        return this.host;
    }

    @NotNull
    public final Map<String, Field<?, T>> getFields() {
        return this.fields;
    }

    public final void collectMutableProperties(@NotNull Object host, @NotNull KClass<?> clazz) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        for (KProperty1 property : KClasses.getMemberProperties(clazz)) {
            Object v2;
            block5: {
                Object v0;
                boolean $i$f$firstOrNull;
                boolean $i$f$findAnnotation;
                block4: {
                    if (!(property instanceof KMutableProperty1)) continue;
                    KAnnotatedElement $this$hasAnnotation$iv = (KAnnotatedElement)property;
                    boolean $i$f$hasAnnotation = false;
                    KAnnotatedElement $this$findAnnotation$iv$iv = $this$hasAnnotation$iv;
                    $i$f$findAnnotation = false;
                    Iterable $this$firstOrNull$iv$iv$iv = $this$findAnnotation$iv$iv.getAnnotations();
                    $i$f$firstOrNull = false;
                    for (Object element$iv$iv$iv : $this$firstOrNull$iv$iv$iv) {
                        Annotation it$iv$iv = (Annotation)element$iv$iv$iv;
                        boolean bl = false;
                        if (!(it$iv$iv instanceof GuiSync)) continue;
                        v0 = element$iv$iv$iv;
                        break block4;
                    }
                    v0 = null;
                }
                boolean bl = (Annotation)v0 != null;
                if (!bl) continue;
                KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)property;
                $i$f$findAnnotation = false;
                Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    Annotation it$iv = (Annotation)element$iv$iv;
                    boolean bl2 = false;
                    if (!(it$iv instanceof GuiSync)) continue;
                    v2 = element$iv$iv;
                    break block5;
                }
                v2 = null;
            }
            GuiSync $i$f$hasAnnotation = (GuiSync)((Annotation)v2);
            Intrinsics.checkNotNull((Object)$i$f$hasAnnotation);
            GuiSync annotation = $i$f$hasAnnotation;
            String value = annotation.key();
            if (this.fields.containsKey(value)) {
                throw new IllegalStateException("Class " + host.getClass() + " declares the same sync key twice: " + value);
            }
            Map<String, Field<?, T>> map = this.fields;
            Field field = Field.Companion.create(host, (KMutableProperty1)property);
            boolean bl = false;
            map.put(value, field);
        }
    }

    public final boolean hasChanges() {
        for (Field<?, T> value : this.fields.values()) {
            if (!value.hasChanges()) continue;
            return true;
        }
        return false;
    }

    public final void writeFull(@NotNull AEAPacketBuffer data) {
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        this.writeFields(data, true);
    }

    public final void writeUpdate(@NotNull AEAPacketBuffer data) {
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        this.writeFields(data, false);
    }

    private final void writeFields(AEAPacketBuffer data, boolean includeUnchanged) {
        Map<String, Field<?, T>> map = this.fields;
        boolean bl = false;
        for (Map.Entry<String, Field<?, T>> item2 : map.entrySet()) {
            if (!includeUnchanged && !item2.getValue().hasChanges()) continue;
            data.func_180714_a(item2.getKey());
            item2.getValue().write(data);
        }
        data.func_180714_a("-1");
    }

    public final void readUpdate(@NotNull AEAPacketBuffer data) {
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        String key = data.func_218666_n();
        int i = 0;
        while (!Intrinsics.areEqual((Object)key, (Object)"-1")) {
            int n;
            Field<?, T> field = this.fields.get(key);
            if (field == null) {
                LoggerKt.getLogger().warn("Server sent update for GUI field %d, which we don't know.", (Object)key);
                key = data.func_218666_n();
                n = i;
                i = n + 1;
                continue;
            }
            field.read(data);
            key = data.func_218666_n();
            n = i;
            i = n + 1;
        }
    }

    public final boolean hasFields() {
        return !this.fields.isEmpty();
    }
}

