/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util;

import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SphereBuilder {
    public static List<TriangleFace> buildFaces(Vector3 axis, int fractionsSplit, int fractionsCircle) {
        ArrayList<TriangleFace> sphereFaces = new ArrayList<TriangleFace>();
        Vector3 centerPerp = axis.clone().perpendicular();
        double degSplit = 180.0 / (double)fractionsSplit;
        double degCircleSplit = 360.0 / (double)fractionsCircle;
        double degCircleOffsetShifted = degCircleSplit / 2.0;
        boolean shift = false;
        Object[] prevArray = new Vector3[fractionsCircle];
        Vector3 prev = axis.clone();
        Arrays.fill(prevArray, prev.clone());
        for (int i = 1; i <= fractionsSplit; ++i) {
            Vector3 splitVec = axis.clone().rotate(Math.toRadians(degSplit * (double)i), centerPerp);
            Vector3[] circlePositions = new Vector3[fractionsCircle];
            for (int j = 0; j < fractionsCircle; ++j) {
                double deg = shift ? degCircleOffsetShifted : 0.0;
                circlePositions[j] = splitVec.clone().rotate(Math.toRadians(deg += degCircleSplit * (double)j), axis);
            }
            for (int k = 0; k < fractionsCircle; ++k) {
                int nextIndex;
                int prevIndex;
                int n = prevIndex = shift ? k : k - 1;
                if (prevIndex < 0) {
                    prevIndex = fractionsCircle - 1;
                }
                int n2 = nextIndex = shift ? k + 1 : k;
                if (nextIndex >= fractionsCircle) {
                    nextIndex = 0;
                }
                sphereFaces.add(new TriangleFace((Vector3)prevArray[prevIndex], (Vector3)prevArray[nextIndex], circlePositions[k]));
                int nextCircle = k + 1;
                if (nextCircle >= fractionsCircle) {
                    nextCircle = 0;
                }
                sphereFaces.add(new TriangleFace(circlePositions[k], (Vector3)prevArray[nextIndex], circlePositions[nextCircle]));
            }
            prevArray = circlePositions;
            shift = !shift;
        }
        return sphereFaces;
    }

    public static class TriangleFace {
        private Vector3 v1;
        private Vector3 v2;
        private Vector3 v3;

        private TriangleFace(Vector3 v1, Vector3 v2, Vector3 v3) {
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
        }

        public Vector3 getV1() {
            return this.v1;
        }

        public Vector3 getV2() {
            return this.v2;
        }

        public Vector3 getV3() {
            return this.v3;
        }
    }
}

