/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.cmd.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ProgressionTier;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ICommandSource;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.server.command.EnumArgument;

public class CommandProgress {
    private CommandProgress() {
    }

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"progress").requires(cs -> cs.func_197034_c(2))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"progress", (ArgumentType)EnumArgument.enumArgument(ProgressionTier.class)).executes(ctx -> {
            ServerPlayerEntity src = ((CommandSource)ctx.getSource()).func_197035_h();
            ServerPlayerEntity target = EntityArgument.func_197089_d((CommandContext)ctx, (String)"player");
            ProgressionTier goal = (ProgressionTier)((Object)((Object)ctx.getArgument("progress", ProgressionTier.class)));
            return CommandProgress.pushPlayerToProgress((ICommandSource)src, (PlayerEntity)target, goal);
        })));
    }

    private static int pushPlayerToProgress(ICommandSource src, PlayerEntity target, ProgressionTier goal) {
        ITextComponent targetName = target.func_145748_c_();
        PlayerProgress progress = ResearchHelper.getProgress(target, LogicalSide.SERVER);
        if (!progress.isValid() || progress.getTierReached().isThisLaterOrEqual(goal)) {
            src.func_145747_a((ITextComponent)new StringTextComponent("Failed! ").func_230529_a_(targetName).func_240702_b_("'s progress is higher or equal to ").func_240702_b_(goal.name()).func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            return 0;
        }
        ResearchProgression research = null;
        switch (goal) {
            case DISCOVERY: {
                research = ResearchProgression.DISCOVERY;
                break;
            }
            case BASIC_CRAFT: {
                research = ResearchProgression.BASIC_CRAFT;
                break;
            }
            case ATTUNEMENT: {
                research = ResearchProgression.ATTUNEMENT;
                break;
            }
            case CONSTELLATION_CRAFT: {
                research = ResearchProgression.CONSTELLATION;
                break;
            }
            case TRAIT_CRAFT: {
                research = ResearchProgression.RADIANCE;
                break;
            }
            case BRILLIANCE: {
                research = ResearchProgression.BRILLIANCE;
                break;
            }
        }
        if (research == null) {
            src.func_145747_a((ITextComponent)new StringTextComponent("Invalid progression tier: " + goal.name()).func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
        }
        if (ResearchManager.grantProgress(target, goal) && ResearchManager.grantResearch(target, research)) {
            src.func_145747_a((ITextComponent)new StringTextComponent("Success!").func_240699_a_(TextFormatting.GREEN), Util.field_240973_b_);
            return 1;
        }
        src.func_145747_a((ITextComponent)new StringTextComponent("Failed!").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
        return 0;
    }
}

